/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.xml.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.maven.model.LocatedAttributeAdapter;
import org.sonar.maven.model.LocatedTreeImpl;
import org.sonar.maven.model.XmlLocation;
import org.sonar.maven.model.maven2.MavenProject;
import org.sonar.maven.model.maven2.ObjectFactory;

public class PomParser {
    private static final Logger LOG = Loggers.get(PomParser.class);

    private PomParser() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CheckForNull
    public static MavenProject parseXML(File file) {
        try (FileInputStream is = new FileInputStream(file);){
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLStreamReader reader = factory.createXMLStreamReader(is);
            StreamListener streamListener = new StreamListener(reader);
            Unmarshaller unmarshaller = context.createUnmarshaller();
            unmarshaller.setListener((Unmarshaller.Listener)streamListener);
            unmarshaller.setAdapter((XmlAdapter)new LocatedAttributeAdapter(reader));
            JAXBElement unmarshalledObject = unmarshaller.unmarshal(reader, MavenProject.class);
            if (!"project".equalsIgnoreCase(unmarshalledObject.getName().getLocalPart())) {
                MavenProject mavenProject2 = null;
                return mavenProject2;
            }
            MavenProject mavenProject = (MavenProject)unmarshalledObject.getValue();
            return mavenProject;
        }
        catch (IOException | JAXBException | XMLStreamException e) {
            LOG.error("Unable to parse pom file " + file.getPath(), e);
            return null;
        }
    }

    private static class StreamListener
    extends Unmarshaller.Listener {
        private final XMLStreamReader reader;

        public StreamListener(XMLStreamReader reader) {
            this.reader = reader;
        }

        public void beforeUnmarshal(Object target, Object parent) {
            XmlLocation beforeLocation = XmlLocation.getLocation((Location)this.reader.getLocation());
            ((LocatedTreeImpl)target).setStartLocation(beforeLocation);
        }

        public void afterUnmarshal(Object target, Object parent) {
            XmlLocation afterLocation = XmlLocation.getLocation((Location)this.reader.getLocation());
            ((LocatedTreeImpl)target).setEndLocation(afterLocation);
        }
    }
}

