/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.measures;

import java.util.Collection;
import javax.annotation.Nullable;
import org.sonar.api.internal.apachecommons.lang.StringUtils;
import org.sonar.api.measures.Measure;

@Deprecated
public final class MeasureUtils {
    private MeasureUtils() {
    }

    public static boolean haveValues(Measure ... measures) {
        if (measures == null || measures.length == 0) {
            return false;
        }
        for (Measure measure : measures) {
            if (MeasureUtils.hasValue(measure)) continue;
            return false;
        }
        return true;
    }

    public static Double getValue(Measure measure, @Nullable Double defaultValue) {
        if (MeasureUtils.hasValue(measure)) {
            return measure.getValue();
        }
        return defaultValue;
    }

    public static Long getValueAsLong(Measure measure, Long defaultValue) {
        if (MeasureUtils.hasValue(measure)) {
            return measure.getValue().longValue();
        }
        return defaultValue;
    }

    public static Double getVariation(Measure measure, int periodIndex) {
        return MeasureUtils.getVariation(measure, periodIndex, null);
    }

    public static Double getVariation(Measure measure, int periodIndex, @Nullable Double defaultValue) {
        Double result = null;
        if (measure != null) {
            result = measure.getVariation(periodIndex);
        }
        return result != null ? result : defaultValue;
    }

    public static Long getVariationAsLong(Measure measure, int periodIndex) {
        return MeasureUtils.getVariationAsLong(measure, periodIndex, null);
    }

    public static Long getVariationAsLong(Measure measure, int periodIndex, @Nullable Long defaultValue) {
        Double result = null;
        if (measure != null) {
            result = measure.getVariation(periodIndex);
        }
        return result == null ? defaultValue : Long.valueOf(result.longValue());
    }

    public static boolean hasValue(Measure measure) {
        return measure != null && measure.getValue() != null;
    }

    public static boolean hasData(Measure measure) {
        return measure != null && StringUtils.isNotBlank(measure.getData());
    }

    public static Double sum(boolean zeroIfNone, Collection<Measure> measures) {
        if (measures != null) {
            return MeasureUtils.sum(zeroIfNone, measures.toArray(new Measure[measures.size()]));
        }
        return MeasureUtils.zeroIfNone(zeroIfNone);
    }

    public static Double sum(boolean zeroIfNone, Measure ... measures) {
        if (measures == null) {
            return MeasureUtils.zeroIfNone(zeroIfNone);
        }
        Double sum = 0.0;
        boolean hasValue = false;
        for (Measure measure : measures) {
            if (measure == null || measure.getValue() == null) continue;
            hasValue = true;
            sum = sum + measure.getValue();
        }
        if (hasValue) {
            return sum;
        }
        return MeasureUtils.zeroIfNone(zeroIfNone);
    }

    public static Double sumOnVariation(boolean zeroIfNone, int variationIndex, Collection<Measure> measures) {
        if (measures == null) {
            return MeasureUtils.zeroIfNone(zeroIfNone);
        }
        Double sum = 0.0;
        for (Measure measure : measures) {
            Double var = measure.getVariation(variationIndex);
            if (var == null) continue;
            sum = sum + var;
        }
        return sum;
    }

    private static Double zeroIfNone(boolean zeroIfNone) {
        return zeroIfNone ? Double.valueOf(0.0) : null;
    }
}

