/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.task;

import java.util.regex.Pattern;
import org.sonar.api.ExtensionPoint;
import org.sonar.api.batch.BatchSide;
import org.sonar.api.batch.InstantiationStrategy;
import org.sonar.api.internal.google.common.base.Preconditions;
import org.sonar.api.internal.google.common.base.Strings;
import org.sonar.api.task.Task;

@ExtensionPoint
@BatchSide
@InstantiationStrategy(value="PER_TASK")
public class TaskDefinition
implements Comparable<TaskDefinition> {
    static final String KEY_PATTERN = "[a-zA-Z0-9\\-\\_]+";
    private final String key;
    private final String description;
    private final Class<? extends Task> taskClass;

    private TaskDefinition(Builder builder) {
        this.key = builder.key;
        this.description = builder.description;
        this.taskClass = builder.taskClass;
    }

    public String description() {
        return this.description;
    }

    public String key() {
        return this.key;
    }

    public Class<? extends Task> taskClass() {
        return this.taskClass;
    }

    public String toString() {
        return "Task " + this.key + "[class=" + this.taskClass.getName() + ", desc=" + this.description + "]";
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskDefinition that = (TaskDefinition)o;
        return this.key.equals(that.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    @Override
    public int compareTo(TaskDefinition o) {
        return this.key.compareTo(o.key);
    }

    public static class Builder {
        private String key;
        private String description;
        private Class<? extends Task> taskClass;

        private Builder() {
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder description(String s) {
            this.description = s;
            return this;
        }

        public Builder taskClass(Class<? extends Task> taskClass) {
            this.taskClass = taskClass;
            return this;
        }

        public TaskDefinition build() {
            Preconditions.checkArgument(!Strings.isNullOrEmpty(this.key), "Task key must be set");
            Preconditions.checkArgument(Pattern.matches(TaskDefinition.KEY_PATTERN, this.key), "Task key '" + this.key + "' must match " + TaskDefinition.KEY_PATTERN);
            Preconditions.checkArgument(!Strings.isNullOrEmpty(this.description), "Description must be set for task '" + this.key + "'");
            Preconditions.checkArgument(this.taskClass != null, "Class must be set for task '" + this.key + "'");
            return new TaskDefinition(this);
        }
    }
}

