/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.impl.typed;

import com.google.common.base.Preconditions;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.TokenType;
import com.sonar.sslr.api.Trivia;
import com.sonar.sslr.api.typed.Input;
import com.sonar.sslr.api.typed.NodeBuilder;
import com.sonar.sslr.api.typed.Optional;
import com.sonar.sslr.impl.typed.GrammarBuilderInterceptor;
import com.sonar.sslr.impl.typed.ReflectionUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.sonar.sslr.grammar.GrammarRuleKey;
import org.sonar.sslr.internal.grammar.MutableParsingRule;
import org.sonar.sslr.internal.matchers.ParseNode;
import org.sonar.sslr.internal.vm.TokenExpression;
import org.sonar.sslr.internal.vm.TriviaExpression;

public class SyntaxTreeCreator<T> {
    private final Object treeFactory;
    private final GrammarBuilderInterceptor mapping;
    private final NodeBuilder nodeBuilder;
    private final Token.Builder tokenBuilder = Token.builder();
    private final List<Trivia> trivias = new ArrayList<Trivia>();
    private Input input;

    public SyntaxTreeCreator(Object treeFactory, GrammarBuilderInterceptor mapping, NodeBuilder nodeBuilder) {
        this.treeFactory = treeFactory;
        this.mapping = mapping;
        this.nodeBuilder = nodeBuilder;
    }

    public T create(ParseNode node, Input input) {
        this.input = input;
        this.trivias.clear();
        Object result = this.visit(node);
        if (result instanceof AstNode) {
            ((AstNode)result).hasToBeSkippedFromAst();
        }
        return (T)result;
    }

    private Object visit(ParseNode node) {
        if (node.getMatcher() instanceof MutableParsingRule) {
            return this.visitNonTerminal(node);
        }
        return this.visitTerminal(node);
    }

    private Object visitNonTerminal(ParseNode node) {
        Object result;
        MutableParsingRule rule = (MutableParsingRule)node.getMatcher();
        GrammarRuleKey ruleKey = rule.getRuleKey();
        Method method = this.mapping.actionForRuleKey(ruleKey);
        if (this.mapping.hasMethodForRuleKey(ruleKey)) {
            Preconditions.checkState((node.getChildren().size() == 1 ? 1 : 0) != 0);
            result = this.visit(node.getChildren().get(0));
        } else if (this.mapping.isOptionalRule(ruleKey)) {
            Preconditions.checkState((node.getChildren().size() <= 1 ? 1 : 0) != 0);
            if (node.getChildren().isEmpty()) {
                result = Optional.absent();
            } else {
                Object child = this.visit(node.getChildren().get(0));
                if (child instanceof AstNode) {
                    ((AstNode)child).hasToBeSkippedFromAst();
                }
                result = Optional.of(child);
            }
        } else if (this.mapping.isOneOrMoreRule(ruleKey)) {
            result = this.convertChildren(node);
        } else if (this.mapping.isZeroOrMoreRule(ruleKey)) {
            List<Object> convertedChildren = this.convertChildren(node);
            result = convertedChildren.isEmpty() ? Optional.absent() : Optional.of(convertedChildren);
        } else if (method == null) {
            result = this.nodeBuilder.createNonTerminal(rule.getRuleKey(), rule, this.convertChildren(node), node.getStartIndex(), node.getEndIndex());
        } else {
            List<Object> convertedChildren = this.convertChildren(node);
            result = ReflectionUtils.invokeMethod(method, this.treeFactory, convertedChildren.toArray(new Object[convertedChildren.size()]));
        }
        return result;
    }

    private List<Object> convertChildren(ParseNode node) {
        ArrayList<Object> convertedChildren = new ArrayList<Object>();
        for (ParseNode child : node.getChildren()) {
            Object result = this.visit(child);
            if (result == null) continue;
            if (result instanceof Optional && ((Optional)result).isPresent() && SyntaxTreeCreator.hasToBeSkippedFromAst(((Optional)result).get())) {
                for (AstNode resultChild : ((AstNode)((Optional)result).get()).getChildren()) {
                    convertedChildren.add(resultChild);
                }
                continue;
            }
            if (SyntaxTreeCreator.hasToBeSkippedFromAst(result)) {
                for (AstNode resultChild : ((AstNode)result).getChildren()) {
                    convertedChildren.add(resultChild);
                }
                continue;
            }
            convertedChildren.add(result);
        }
        return convertedChildren;
    }

    private static boolean hasToBeSkippedFromAst(Object object) {
        return object instanceof AstNode && ((AstNode)object).hasToBeSkippedFromAst();
    }

    private Object visitTerminal(ParseNode node) {
        TokenType type = null;
        if (node.getMatcher() instanceof TriviaExpression) {
            TriviaExpression ruleMatcher = (TriviaExpression)node.getMatcher();
            if (ruleMatcher.getTriviaKind() == Trivia.TriviaKind.SKIPPED_TEXT) {
                return null;
            }
            if (ruleMatcher.getTriviaKind() == Trivia.TriviaKind.COMMENT) {
                this.addComment(node);
                return null;
            }
            throw new IllegalStateException("Unexpected trivia kind: " + (Object)((Object)ruleMatcher.getTriviaKind()));
        }
        if (node.getMatcher() instanceof TokenExpression) {
            TokenExpression ruleMatcher = (TokenExpression)node.getMatcher();
            type = ruleMatcher.getTokenType();
            if (GenericTokenType.COMMENT.equals(ruleMatcher.getTokenType())) {
                this.addComment(node);
                return null;
            }
        }
        Object result = this.nodeBuilder.createTerminal(this.input, node.getStartIndex(), node.getEndIndex(), this.trivias, type);
        this.trivias.clear();
        return result;
    }

    private void addComment(ParseNode node) {
        this.tokenBuilder.setGeneratedCode(false);
        int[] lineAndColumn = this.input.lineAndColumnAt(node.getStartIndex());
        this.tokenBuilder.setLine(lineAndColumn[0]);
        this.tokenBuilder.setColumn(lineAndColumn[1] - 1);
        this.tokenBuilder.setURI(this.input.uri());
        String value = this.input.substring(node.getStartIndex(), node.getEndIndex());
        this.tokenBuilder.setValueAndOriginalValue(value);
        this.tokenBuilder.setTrivia(Collections.emptyList());
        this.tokenBuilder.setType(GenericTokenType.COMMENT);
        this.trivias.add(Trivia.createComment(this.tokenBuilder.build()));
    }
}

