/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sslr.grammar;

import com.google.common.collect.Lists;
import java.util.List;
import org.sonar.sslr.grammar.GrammarException;
import org.sonar.sslr.grammar.GrammarRuleBuilder;
import org.sonar.sslr.grammar.GrammarRuleKey;
import org.sonar.sslr.internal.vm.CompilableGrammarRule;
import org.sonar.sslr.internal.vm.FirstOfExpression;
import org.sonar.sslr.internal.vm.NextExpression;
import org.sonar.sslr.internal.vm.NextNotExpression;
import org.sonar.sslr.internal.vm.NothingExpression;
import org.sonar.sslr.internal.vm.OneOrMoreExpression;
import org.sonar.sslr.internal.vm.OptionalExpression;
import org.sonar.sslr.internal.vm.ParsingExpression;
import org.sonar.sslr.internal.vm.SequenceExpression;
import org.sonar.sslr.internal.vm.ZeroOrMoreExpression;

abstract class GrammarBuilder {
    GrammarBuilder() {
    }

    public abstract GrammarRuleBuilder rule(GrammarRuleKey var1);

    public abstract void setRootRule(GrammarRuleKey var1);

    public final Object sequence(Object e1, Object e2) {
        return new SequenceExpression(this.convertToExpression(e1), this.convertToExpression(e2));
    }

    public final Object sequence(Object e1, Object e2, Object ... rest) {
        return new SequenceExpression(this.convertToExpressions(Lists.asList((Object)e1, (Object)e2, (Object[])rest)));
    }

    public final Object firstOf(Object e1, Object e2) {
        return new FirstOfExpression(this.convertToExpression(e1), this.convertToExpression(e2));
    }

    public final Object firstOf(Object e1, Object e2, Object ... rest) {
        return new FirstOfExpression(this.convertToExpressions(Lists.asList((Object)e1, (Object)e2, (Object[])rest)));
    }

    public final Object optional(Object e) {
        return new OptionalExpression(this.convertToExpression(e));
    }

    public final Object optional(Object e1, Object ... rest) {
        return new OptionalExpression(new SequenceExpression(this.convertToExpressions(Lists.asList((Object)e1, (Object[])rest))));
    }

    public final Object oneOrMore(Object e) {
        return new OneOrMoreExpression(this.convertToExpression(e));
    }

    public final Object oneOrMore(Object e1, Object ... rest) {
        return new OneOrMoreExpression(new SequenceExpression(this.convertToExpressions(Lists.asList((Object)e1, (Object[])rest))));
    }

    public final Object zeroOrMore(Object e) {
        return new ZeroOrMoreExpression(this.convertToExpression(e));
    }

    public final Object zeroOrMore(Object e1, Object ... rest) {
        return new ZeroOrMoreExpression(new SequenceExpression(this.convertToExpressions(Lists.asList((Object)e1, (Object[])rest))));
    }

    public final Object next(Object e) {
        return new NextExpression(this.convertToExpression(e));
    }

    public final Object next(Object e1, Object ... rest) {
        return new NextExpression(new SequenceExpression(this.convertToExpressions(Lists.asList((Object)e1, (Object[])rest))));
    }

    public final Object nextNot(Object e) {
        return new NextNotExpression(this.convertToExpression(e));
    }

    public final Object nextNot(Object e1, Object ... rest) {
        return new NextNotExpression(new SequenceExpression(this.convertToExpressions(Lists.asList((Object)e1, (Object[])rest))));
    }

    public final Object nothing() {
        return NothingExpression.INSTANCE;
    }

    protected abstract ParsingExpression convertToExpression(Object var1);

    protected final ParsingExpression[] convertToExpressions(List<Object> expressions) {
        ParsingExpression[] result = new ParsingExpression[expressions.size()];
        for (int i = 0; i < expressions.size(); ++i) {
            result[i] = this.convertToExpression(expressions.get(i));
        }
        return result;
    }

    static class RuleBuilder
    implements GrammarRuleBuilder {
        private final GrammarBuilder b;
        private final CompilableGrammarRule delegate;

        public RuleBuilder(GrammarBuilder b, CompilableGrammarRule delegate) {
            this.b = b;
            this.delegate = delegate;
        }

        @Override
        public GrammarRuleBuilder is(Object e) {
            if (this.delegate.getExpression() != null) {
                throw new GrammarException("The rule '" + this.delegate.getRuleKey() + "' has already been defined somewhere in the grammar.");
            }
            this.delegate.setExpression(this.b.convertToExpression(e));
            return this;
        }

        @Override
        public GrammarRuleBuilder is(Object e, Object ... rest) {
            return this.is(new SequenceExpression(this.b.convertToExpressions(Lists.asList((Object)e, (Object[])rest))));
        }

        @Override
        public GrammarRuleBuilder override(Object e) {
            this.delegate.setExpression(this.b.convertToExpression(e));
            return this;
        }

        @Override
        public GrammarRuleBuilder override(Object e, Object ... rest) {
            return this.override(new SequenceExpression(this.b.convertToExpressions(Lists.asList((Object)e, (Object[])rest))));
        }

        @Override
        public void skip() {
            this.delegate.skip();
        }

        @Override
        public void skipIfOneChild() {
            this.delegate.skipIfOneChild();
        }

        @Override
        public void recoveryRule() {
            throw new UnsupportedOperationException();
        }
    }
}

