/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sslr.internal.vm;

import com.sonar.sslr.api.TokenType;
import org.sonar.sslr.internal.matchers.Matcher;
import org.sonar.sslr.internal.vm.CompilationHandler;
import org.sonar.sslr.internal.vm.Instruction;
import org.sonar.sslr.internal.vm.ParsingExpression;

public class TokenExpression
implements Matcher,
ParsingExpression {
    private final TokenType tokenType;
    private final ParsingExpression subExpression;

    public TokenExpression(TokenType tokenType, ParsingExpression subExpression) {
        this.tokenType = tokenType;
        this.subExpression = subExpression;
    }

    public TokenType getTokenType() {
        return this.tokenType;
    }

    @Override
    public Instruction[] compile(CompilationHandler compiler) {
        return TokenExpression.compile(compiler, this, this.subExpression);
    }

    static Instruction[] compile(CompilationHandler compiler, Matcher expression, ParsingExpression subExpression) {
        Instruction[] instr = compiler.compile(subExpression);
        Instruction[] result = new Instruction[instr.length + 4];
        result[0] = Instruction.call(2, expression);
        result[1] = Instruction.jump(instr.length + 3);
        result[2] = Instruction.ignoreErrors();
        System.arraycopy(instr, 0, result, 3, instr.length);
        result[3 + instr.length] = Instruction.ret();
        return result;
    }

    public String toString() {
        return "Token " + this.tokenType + "[" + this.subExpression + "]";
    }
}

