/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.maven;

import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.library.ModelCopyManager;
import org.spdx.library.model.SpdxDocument;
import org.spdx.library.model.license.AnyLicenseInfo;
import org.spdx.library.model.license.InvalidLicenseStringException;
import org.spdx.library.model.license.LicenseInfoFactory;
import org.spdx.maven.utils.SpdxBuilderException;
import org.spdx.storage.IModelStore;

public class SnippetInfo {
    private static final Logger LOG = LoggerFactory.getLogger(SnippetInfo.class);
    private static final Pattern NUMBER_RANGE_PATTERN = Pattern.compile("(\\d+):(\\d+)");
    private String name;
    private String comment;
    private String concludedLicense;
    private String lineRange;
    private String byteRange;
    private String licenseComment;
    private String copyrightText;
    private String licenseInfoInSnippet;

    public void logInfo() {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        LOG.debug("Snippet information follows:");
        if (this.name != null) {
            LOG.debug("Name: " + this.name);
        }
        LOG.debug("Byte range: " + this.byteRange);
        if (this.comment != null) {
            LOG.debug("Comment: " + this.comment);
        }
        LOG.debug("Concluded license: " + this.concludedLicense);
        if (this.copyrightText != null) {
            LOG.debug("Copyright: " + this.copyrightText);
        }
        if (this.licenseComment != null) {
            LOG.debug("License comment: " + this.licenseComment);
        }
        LOG.debug("License info in Snippet: " + this.licenseInfoInSnippet);
        if (this.lineRange != null) {
            LOG.debug("Line range: " + this.lineRange);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getComment() {
        return this.comment;
    }

    public AnyLicenseInfo getLicenseConcluded(SpdxDocument spdxDoc) throws InvalidLicenseStringException {
        return LicenseInfoFactory.parseSPDXLicenseString((String)this.concludedLicense, (IModelStore)spdxDoc.getModelStore(), (String)spdxDoc.getDocumentUri(), (ModelCopyManager)spdxDoc.getCopyManager());
    }

    public Collection<AnyLicenseInfo> getLicenseInfoInSnippet(SpdxDocument spdxDoc) throws InvalidLicenseStringException {
        ArrayList<AnyLicenseInfo> retval = new ArrayList<AnyLicenseInfo>();
        retval.add(LicenseInfoFactory.parseSPDXLicenseString((String)this.licenseInfoInSnippet, (IModelStore)spdxDoc.getModelStore(), (String)spdxDoc.getDocumentUri(), (ModelCopyManager)spdxDoc.getCopyManager()));
        return retval;
    }

    public String getCopyrightText() {
        return this.copyrightText;
    }

    public String getLicensComment() {
        return this.licenseComment;
    }

    public int getByteRangeStart() throws SpdxBuilderException {
        Matcher matcher = NUMBER_RANGE_PATTERN.matcher(this.byteRange.trim());
        if (!matcher.find()) {
            throw new SpdxBuilderException("Invalid snippet byte range: " + this.byteRange);
        }
        try {
            return Integer.parseInt(matcher.group(1));
        }
        catch (Exception ex) {
            throw new SpdxBuilderException("Non integer start to snippet byte offset: " + this.byteRange);
        }
    }

    public int getByteRangeEnd() throws SpdxBuilderException {
        Matcher matcher = NUMBER_RANGE_PATTERN.matcher(this.byteRange.trim());
        if (!matcher.find()) {
            throw new SpdxBuilderException("Invalid snippet byte range: " + this.byteRange);
        }
        try {
            return Integer.parseInt(matcher.group(2));
        }
        catch (Exception ex) {
            throw new SpdxBuilderException("Non integer end to snippet byte offset: " + this.byteRange);
        }
    }

    public int getLineRangeStart() throws SpdxBuilderException {
        Matcher matcher = NUMBER_RANGE_PATTERN.matcher(this.lineRange);
        if (!matcher.find()) {
            throw new SpdxBuilderException("Invalid snippet line range: " + this.lineRange);
        }
        try {
            return Integer.parseInt(matcher.group(1));
        }
        catch (Exception ex) {
            throw new SpdxBuilderException("Non integer end to snippet line offset: " + this.lineRange);
        }
    }

    public int getLineRangeEnd() throws SpdxBuilderException {
        Matcher matcher = NUMBER_RANGE_PATTERN.matcher(this.lineRange);
        if (!matcher.find()) {
            throw new SpdxBuilderException("Invalid snippet line range: " + this.lineRange);
        }
        try {
            return Integer.parseInt(matcher.group(2));
        }
        catch (Exception ex) {
            throw new SpdxBuilderException("Non integer end to snippet line offset: " + this.lineRange);
        }
    }

    public String getConcludedLicense() {
        return this.concludedLicense;
    }

    public void setConcludedLicense(String concludedLicense) {
        this.concludedLicense = concludedLicense;
    }

    public String getLicenseComment() {
        return this.licenseComment;
    }

    public void setLicenseComment(String licenseComment) {
        this.licenseComment = licenseComment;
    }

    public String getLicenseInfoInSnippet() {
        return this.licenseInfoInSnippet;
    }

    public void setLicenseInfoInSnippet(String licenseInfoInSnippet) {
        this.licenseInfoInSnippet = licenseInfoInSnippet;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setLineRange(String lineRange) {
        this.lineRange = lineRange;
    }

    public void setByteRange(String byteRange) {
        this.byteRange = byteRange;
    }

    public void setCopyrightText(String copyrightText) {
        this.copyrightText = copyrightText;
    }
}

