/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.maven.utils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.spdx.library.model.license.AnyLicenseInfo;
import org.spdx.library.model.license.InvalidLicenseStringException;
import org.spdx.library.model.license.LicenseInfoFactory;
import org.spdx.maven.utils.SpdxSourceParserException;

public class SpdxSourceFileParser {
    public static final long MAXIMUM_SOURCE_FILE_LENGTH = 300000L;
    protected static final Pattern SPDX_LICENSE_PATTERN = Pattern.compile("SPDX-License-Identifier:\\s*([^\\n^\\r]+)(\\n|\\r|$)", 34);

    public static List<AnyLicenseInfo> parseFileForSpdxLicenses(File file) throws SpdxSourceParserException {
        try {
            return SpdxSourceFileParser.parseTextForSpdxLicenses(FileUtils.readFileToString((File)file, (String)"utf-8"));
        }
        catch (IOException e) {
            throw new SpdxSourceParserException("I/O error reading text for source file " + file.getName(), e);
        }
        catch (SpdxSourceParserException e) {
            throw new SpdxSourceParserException("Error parsing license text for file " + file.getName(), e);
        }
    }

    public static List<AnyLicenseInfo> parseTextForSpdxLicenses(String text) throws SpdxSourceParserException {
        ArrayList<AnyLicenseInfo> retval = new ArrayList<AnyLicenseInfo>();
        Matcher match = SPDX_LICENSE_PATTERN.matcher(text);
        int pos = 0;
        while (pos < text.length() && match.find(pos)) {
            String matchingLine = match.group(1).trim();
            if (matchingLine.startsWith("(")) {
                int parenCount = 1;
                StringBuilder sb = new StringBuilder("(");
                for (pos = match.start(1) + 1; parenCount > 0 && pos < text.length(); ++pos) {
                    char ch = text.charAt(pos);
                    if (ch == '(') {
                        ++parenCount;
                    } else if (ch == ')') {
                        --parenCount;
                    }
                    if (ch == '\n' || ch == '\r') {
                        sb.append(' ');
                        continue;
                    }
                    sb.append(ch);
                }
                if (parenCount > 0) {
                    throw new SpdxSourceParserException("Miss-matched parenthesis for expression");
                }
                matchingLine = sb.toString();
            } else {
                pos = match.end() + 1;
            }
            try {
                retval.add(LicenseInfoFactory.parseSPDXLicenseString((String)matchingLine));
            }
            catch (InvalidLicenseStringException e) {
                throw new SpdxSourceParserException("Invalid SPDX license string '" + matchingLine + "'.");
            }
        }
        return retval;
    }
}

