/*
 * Decompiled with CFR 0.152.
 */
package org.specs2.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.specs2.io.FileReader;
import org.specs2.io.FileWriter;
import org.specs2.io.Paths$;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Stream;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]h\u0001C\u0001\u0003!\u0003\r\t\u0001\u0002\u0005\u0003\u0015\u0019KG.Z*zgR,WN\u0003\u0002\u0004\t\u0005\u0011\u0011n\u001c\u0006\u0003\u000b\u0019\taa\u001d9fGN\u0014$\"A\u0004\u0002\u0007=\u0014xm\u0005\u0003\u0001\u0013=\u0019\u0002C\u0001\u0006\u000e\u001b\u0005Y!\"\u0001\u0007\u0002\u000bM\u001c\u0017\r\\1\n\u00059Y!AB!osJ+g\r\u0005\u0002\u0011#5\t!!\u0003\u0002\u0013\u0005\tQa)\u001b7f%\u0016\fG-\u001a:\u0011\u0005A!\u0012BA\u000b\u0003\u0005)1\u0015\u000e\\3Xe&$XM\u001d\u0005\u0006/\u0001!\t!G\u0001\u0007I%t\u0017\u000e\u001e\u0013\u0004\u0001Q\t!\u0004\u0005\u0002\u000b7%\u0011Ad\u0003\u0002\u0005+:LG\u000fC\u0003\u001f\u0001\u0011\u0005q$A\u0005gS2,\u0007+\u0019;igR!\u0001\u0005\u000e\u001c9!\r\t\u0013\u0006\f\b\u0003E\u001dr!a\t\u0014\u000e\u0003\u0011R!!\n\r\u0002\rq\u0012xn\u001c;?\u0013\u0005a\u0011B\u0001\u0015\f\u0003\u001d\u0001\u0018mY6bO\u0016L!AK\u0016\u0003\u0007M+\u0017O\u0003\u0002)\u0017A\u0011Q&\r\b\u0003]=\u0002\"aI\u0006\n\u0005AZ\u0011A\u0002)sK\u0012,g-\u0003\u00023g\t11\u000b\u001e:j]\u001eT!\u0001M\u0006\t\u000fUj\u0002\u0013!a\u0001Y\u0005A!-Y:f!\u0006$\b\u000eC\u00048;A\u0005\t\u0019\u0001\u0017\u0002\tA\fG\u000f\u001b\u0005\bsu\u0001\n\u00111\u0001;\u0003\u001d1XM\u001d2pg\u0016\u0004\"AC\u001e\n\u0005qZ!a\u0002\"p_2,\u0017M\u001c\u0005\u0006}\u0001!\taP\u0001\fM&dG/\u001a:GS2,7\u000f\u0006\u0003!\u0001*[\u0005\"B!>\u0001\u0004\u0011\u0015!\u00024pk:$\u0007cA\u0011*\u0007B\u0011A\tS\u0007\u0002\u000b*\u00111A\u0012\u0006\u0002\u000f\u0006!!.\u0019<b\u0013\tIUI\u0001\u0003GS2,\u0007\"B\u001c>\u0001\u0004a\u0003\"B\u001d>\u0001\u0004Q\u0004\"B'\u0001\t\u0013q\u0015!D5t-\u0016\u00148/[8o\r&dW\r\u0006\u0002;\u001f\")\u0001\u000b\u0014a\u0001\u0007\u0006\ta\rC\u0003S\u0001\u0011%1+\u0001\ngS2,W*\u0019;dQ\u0016\u001c\b+\u0019;uKJtG\u0003\u0002\u001eU+^CQ\u0001U)A\u0002\rCQAV)A\u00021\nq\u0001]1ui\u0016\u0014h\u000eC\u0004:#B\u0005\t\u0019\u0001\u001e\t\u000be\u0003A\u0011\u0002.\u0002\u000fI,7-\u001e:tKR\u00111L\u0018\t\u0004Cq\u001b\u0015BA/,\u0005\u0019\u0019FO]3b[\")q\f\u0017a\u0001\u0007\u0006!a-\u001b7f\u0011\u0015\t\u0007\u0001\"\u0001c\u000359Gn\u001c2U_B\u000bG\u000f^3s]R\u0011Af\u0019\u0005\u0006I\u0002\u0004\r\u0001L\u0001\u0005O2|'\rC\u0003g\u0001\u0011\u0005q-A\u0003jg\u0012K'\u000f\u0006\u0002;Q\")q'\u001aa\u0001Y!)!\u000e\u0001C\u0001W\u0006I1M]3bi\u0016$\u0015N\u001d\u000b\u0003u1DQaN5A\u00021BQA\u001c\u0001\u0005\u0002=\f\u0011B]3n_Z,G)\u001b:\u0015\u00051\u0002\b\"B\u001cn\u0001\u0004a\u0003\"\u0002:\u0001\t\u0003\u0019\u0018aB2b]J+\u0017\r\u001a\u000b\u0003uQDQaN9A\u00021BQA\u001e\u0001\u0005\u0002]\f\u0001bY1o/JLG/\u001a\u000b\u0003uaDQaN;A\u00021BQA\u001f\u0001\u0005\u0002m\f!\"[:BEN|G.\u001e;f)\tQD\u0010C\u00038s\u0002\u0007A\u0006C\u0003\u007f\u0001\u0011\u0005q0\u0001\u0004jg\u001aKG.\u001a\u000b\u0004u\u0005\u0005\u0001\"B\u001c~\u0001\u0004a\u0003bBA\u0003\u0001\u0011\u0005\u0011qA\u0001\fSN$\u0015N]3di>\u0014\u0018\u0010F\u0002;\u0003\u0013AaaNA\u0002\u0001\u0004a\u0003bBA\u0007\u0001\u0011\u0005\u0011qB\u0001\tSND\u0015\u000e\u001a3f]R\u0019!(!\u0005\t\r]\nY\u00011\u0001-\u0011\u001d\t)\u0002\u0001C\u0001\u0003/\tqaZ3u\u001d\u0006lW\r\u0006\u0003\u0002\u001a\u0005\r\u0002\u0003BA\u000e\u0003Ci!!!\b\u000b\u0007\u0005}a)\u0001\u0003mC:<\u0017b\u0001\u001a\u0002\u001e!1q'a\u0005A\u00021Bq!a\n\u0001\t\u0003\tI#A\bhKR\f%m]8mkR,\u0007+\u0019;i)\u0011\tI\"a\u000b\t\r]\n)\u00031\u0001-\u0011\u001d\ty\u0003\u0001C\u0001\u0003c\t\u0001cZ3u\u0007\u0006twN\\5dC2\u0004\u0016\r\u001e5\u0015\t\u0005e\u00111\u0007\u0005\u0007o\u00055\u0002\u0019\u0001\u0017\t\u000f\u0005]\u0002\u0001\"\u0001\u0002:\u0005Iq-\u001a;QCJ,g\u000e\u001e\u000b\u0005\u00033\tY\u0004\u0003\u00048\u0003k\u0001\r\u0001\f\u0005\b\u0003\u007f\u0001A\u0011AA!\u0003%a\u0017n\u001d;GS2,7\u000f\u0006\u0003\u0002D\u0005%\u0003\u0003B\u0011\u0002F1J1!a\u0012,\u0005\u0011a\u0015n\u001d;\t\r]\ni\u00041\u0001-\u0011\u001d\ti\u0005\u0001C\u0001\u0003\u001f\nqaY8qs\u0012K'\u000fF\u0003\u001b\u0003#\n)\u0006C\u0004\u0002T\u0005-\u0003\u0019\u0001\u0017\u0002\u0007M\u00148\rC\u0004\u0002X\u0005-\u0003\u0019\u0001\u0017\u0002\t\u0011,7\u000f\u001e\u0005\b\u00037\u0002A\u0011AA/\u0003!\u0019w\u000e]=GS2,G#\u0002\u000e\u0002`\u0005\u0005\u0004BB\u001c\u0002Z\u0001\u0007A\u0006C\u0004\u0002X\u0005e\u0003\u0019\u0001\u0017\t\u000f\u0005\u0015\u0004\u0001\"\u0003\u0002h\u0005)QO\u001c6beR9!$!\u001b\u0002z\u0005u\u0004\u0002CA6\u0003G\u0002\r!!\u001c\u0002\r)\f'/\u0016:m!\u0011\ty'!\u001e\u000e\u0005\u0005E$bAA:\r\u0006\u0019a.\u001a;\n\t\u0005]\u0014\u0011\u000f\u0002\u0004+Jc\u0005bBA>\u0003G\u0002\r\u0001L\u0001\bI&\u0014\b+\u0019;i\u0011\u001d\ty(a\u0019A\u00021\n1B]3hKb4\u0015\u000e\u001c;fe\"9\u00111\u0011\u0001\u0005\u0002\u0005\u0015\u0015\u0001B2paf$RAGAD\u0003#C\u0001\"!#\u0002\u0002\u0002\u0007\u00111R\u0001\u0006S:\u0004X\u000f\u001e\t\u0004\t\u00065\u0015bAAH\u000b\nY\u0011J\u001c9viN#(/Z1n\u0011!\t\u0019*!!A\u0002\u0005U\u0015AB8viB,H\u000fE\u0002E\u0003/K1!!'F\u00051yU\u000f\u001e9viN#(/Z1n\u0011\u001d\ti\n\u0001C\u0001\u0003?\u000bAcY8qsN\u0003Xm\u0019*fg>,(oY3t\t&\u0014H#\u0003\u000e\u0002\"\u0006\u0015\u0016qUAV\u0011\u001d\t\u0019+a'A\u00021\nAAY1tK\"9\u00111KAN\u0001\u0004a\u0003bBAU\u00037\u0003\r\u0001L\u0001\n_V$\b/\u001e;ESJD\u0001\"!,\u0002\u001c\u0002\u0007\u0011qV\u0001\u0007Y>\fG-\u001a:\u0011\t\u0005m\u0011\u0011W\u0005\u0005\u0003g\u000biBA\u0006DY\u0006\u001c8\u000fT8bI\u0016\u0014\bbBA\\\u0001\u0011%\u0011\u0011X\u0001\u0006U\u0006\u0014xJ\u001a\u000b\u0005\u0003[\nY\f\u0003\u0005\u0002>\u0006U\u0006\u0019AA7\u0003\r)(\u000f\u001c\u0005\b\u0003\u0003\u0004A\u0011AAb\u0003!\u0019\u0018-\\3QCRDG#\u0002\u001e\u0002F\u0006%\u0007bBAd\u0003\u007f\u0003\r\u0001L\u0001\u0003aFBq!a3\u0002@\u0002\u0007A&\u0001\u0002qe!I\u0011q\u001a\u0001\u0012\u0002\u0013\u0005\u0011\u0011[\u0001\u0014M&dW\rU1uQN$C-\u001a4bk2$H%M\u000b\u0003\u0003'T3\u0001LAkW\t\t9\u000e\u0005\u0003\u0002Z\u0006\rXBAAn\u0015\u0011\ti.a8\u0002\u0013Ut7\r[3dW\u0016$'bAAq\u0017\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u0015\u00181\u001c\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"CAu\u0001E\u0005I\u0011AAi\u0003M1\u0017\u000e\\3QCRD7\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0011%\ti\u000fAI\u0001\n\u0003\ty/A\ngS2,\u0007+\u0019;ig\u0012\"WMZ1vYR$3'\u0006\u0002\u0002r*\u001a!(!6\t\u0013\u0005U\b!%A\u0005\n\u0005=\u0018\u0001\b4jY\u0016l\u0015\r^2iKN\u0004\u0016\r\u001e;fe:$C-\u001a4bk2$He\r")
public interface FileSystem
extends FileReader,
FileWriter {
    public static /* synthetic */ Seq filePaths$(FileSystem $this, String basePath, String path, boolean verbose) {
        return $this.filePaths(basePath, path, verbose);
    }

    default public Seq<String> filePaths(String basePath, String path, boolean verbose) {
        Stream<File> found;
        block0: {
            found = this.recurse(new File(basePath));
            if (!verbose) break block0;
            found.foreach((Function1 & Serializable & scala.Serializable)f -> {
                Predef$.MODULE$.println((Object)("found file: " + f));
                return BoxedUnit.UNIT;
            });
        }
        return this.filterFiles((Seq<File>)found, path, verbose);
    }

    public static /* synthetic */ String filePaths$default$1$(FileSystem $this) {
        return $this.filePaths$default$1();
    }

    default public String filePaths$default$1() {
        return ".";
    }

    public static /* synthetic */ String filePaths$default$2$(FileSystem $this) {
        return $this.filePaths$default$2();
    }

    default public String filePaths$default$2() {
        return "*";
    }

    public static /* synthetic */ boolean filePaths$default$3$(FileSystem $this) {
        return $this.filePaths$default$3();
    }

    default public boolean filePaths$default$3() {
        return false;
    }

    public static /* synthetic */ Seq filterFiles$(FileSystem $this, Seq found, String path, boolean verbose) {
        return $this.filterFiles((Seq<File>)found, path, verbose);
    }

    default public Seq<String> filterFiles(Seq<File> found, String path, boolean verbose) {
        String pattern = this.globToPattern(path) + (this.isDir(path) ? "/*.*" : "");
        if (verbose) {
            Predef$.MODULE$.println((Object)("\nThe pattern used to match files is: " + pattern));
        }
        return ((SeqLike)found.collect((PartialFunction)new scala.Serializable(this, verbose, pattern){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileSystem $outer;
            private final boolean verbose$1;
            private final String pattern$1;

            public final <A1 extends File, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = this.$outer.org$specs2$io$FileSystem$$fileMatchesPattern(A1, this.pattern$1, this.verbose$1) ? A1.getPath() : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(File x1) {
                File file = x1;
                boolean bl = this.$outer.org$specs2$io$FileSystem$$fileMatchesPattern(file, this.pattern$1, this.verbose$1);
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.verbose$1 = verbose$1;
                this.pattern$1 = pattern$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).toSeq();
    }

    private boolean isVersionFile(File f) {
        return ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{".svn", ".cvs"}))).exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FileSystem.$anonfun$isVersionFile$1(f, x$1)));
    }

    public static /* synthetic */ boolean org$specs2$io$FileSystem$$fileMatchesPattern$(FileSystem $this, File f, String pattern, boolean verbose) {
        return $this.org$specs2$io$FileSystem$$fileMatchesPattern(f, pattern, verbose);
    }

    default public boolean org$specs2$io$FileSystem$$fileMatchesPattern(File f, String pattern, boolean verbose) {
        String filePath;
        block0: {
            filePath = Paths$.MODULE$.toPath(f.getPath().replaceFirst(".:", "")).unixize();
            if (!verbose) break block0;
            Predef$.MODULE$.println((Object)(filePath + " matches pattern: " + filePath.matches(pattern)));
        }
        return filePath.matches(pattern);
    }

    private boolean fileMatchesPattern$default$3() {
        return false;
    }

    private Stream<File> recurse(File file) {
        return (Stream)Stream.cons$.MODULE$.apply((Object)file, (Function0 & Serializable & scala.Serializable)() -> file.listFiles() == null ? package$.MODULE$.Stream().empty() : (Stream)((Stream)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])file.listFiles())).toStream().filterNot((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)this.isVersionFile(f)))).flatMap((Function1 & Serializable & scala.Serializable)file -> this.recurse((File)file), package$.MODULE$.Stream().canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isFile()));
    }

    public static /* synthetic */ String globToPattern$(FileSystem $this, String glob) {
        return $this.globToPattern(glob);
    }

    default public String globToPattern(String glob) {
        String star = "<STAR>";
        String authorizedNamePattern = "[^\\/\\?<>\\|\\" + star + ":\"]" + star;
        return glob.replace("\\", "/").replace(".", "\\.").replace("**/", "(" + authorizedNamePattern + "/)" + star).replace("*", authorizedNamePattern).replace(star, "*");
    }

    public static /* synthetic */ boolean isDir$(FileSystem $this, String path) {
        return $this.isDir(path);
    }

    default public boolean isDir(String path) {
        return this.isDirectory(path);
    }

    public static /* synthetic */ boolean createDir$(FileSystem $this, String path) {
        return $this.createDir(path);
    }

    default public boolean createDir(String path) {
        return new File(path).mkdirs();
    }

    public static /* synthetic */ String removeDir$(FileSystem $this, String path) {
        return $this.removeDir(path);
    }

    default public String removeDir(String path) {
        Object object;
        File dir = new File(path);
        if (dir.isDirectory()) {
            boolean bl;
            if (dir.listFiles() == null || new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dir.listFiles())).isEmpty()) {
                bl = dir.delete();
            } else {
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dir.listFiles())).foreach((Function1 & Serializable & scala.Serializable)file -> file.isFile() ? BoxesRunTime.boxToBoolean((boolean)file.delete()) : this.removeDir(file.getPath()));
                bl = dir.delete();
            }
            object = BoxesRunTime.boxToBoolean((boolean)bl);
        } else {
            object = BoxedUnit.UNIT;
        }
        return dir.getParent();
    }

    public static /* synthetic */ boolean canRead$(FileSystem $this, String path) {
        return $this.canRead(path);
    }

    default public boolean canRead(String path) {
        return path != null && new File(path).canRead();
    }

    public static /* synthetic */ boolean canWrite$(FileSystem $this, String path) {
        return $this.canWrite(path);
    }

    default public boolean canWrite(String path) {
        return path != null && new File(path).canWrite();
    }

    public static /* synthetic */ boolean isAbsolute$(FileSystem $this, String path) {
        return $this.isAbsolute(path);
    }

    default public boolean isAbsolute(String path) {
        return path != null && new File(path).isAbsolute();
    }

    public static /* synthetic */ boolean isFile$(FileSystem $this, String path) {
        return $this.isFile(path);
    }

    default public boolean isFile(String path) {
        return path != null && new File(path).isFile();
    }

    public static /* synthetic */ boolean isDirectory$(FileSystem $this, String path) {
        return $this.isDirectory(path);
    }

    default public boolean isDirectory(String path) {
        return path != null && new File(path).isDirectory();
    }

    public static /* synthetic */ boolean isHidden$(FileSystem $this, String path) {
        return $this.isHidden(path);
    }

    default public boolean isHidden(String path) {
        return path != null && new File(path).isHidden();
    }

    public static /* synthetic */ String getName$(FileSystem $this, String path) {
        return $this.getName(path);
    }

    default public String getName(String path) {
        return new File(path).getName();
    }

    public static /* synthetic */ String getAbsolutePath$(FileSystem $this, String path) {
        return $this.getAbsolutePath(path);
    }

    default public String getAbsolutePath(String path) {
        return new File(path).getAbsolutePath();
    }

    public static /* synthetic */ String getCanonicalPath$(FileSystem $this, String path) {
        return $this.getCanonicalPath(path);
    }

    default public String getCanonicalPath(String path) {
        return new File(path).getCanonicalPath();
    }

    public static /* synthetic */ String getParent$(FileSystem $this, String path) {
        return $this.getParent(path);
    }

    default public String getParent(String path) {
        return new File(path).getParent();
    }

    public static /* synthetic */ List listFiles$(FileSystem $this, String path) {
        return $this.listFiles(path);
    }

    default public List<String> listFiles(String path) {
        return new File(path).list() == null ? Nil$.MODULE$ : new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new File(path).list())).toList();
    }

    public static /* synthetic */ void copyDir$(FileSystem $this, String src, String dest) {
        $this.copyDir(src, dest);
    }

    default public void copyDir(String src, String dest) {
        ((List)this.listFiles(src).filterNot((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.contains(".svn")))).foreach((Function1 & Serializable & scala.Serializable)name -> {
            FileSystem.$anonfun$copyDir$2(this, src, dest, name);
            return BoxedUnit.UNIT;
        });
    }

    public static /* synthetic */ void copyFile$(FileSystem $this, String path, String dest) {
        $this.copyFile(path, dest);
    }

    default public void copyFile(String path, String dest) {
        this.mkdirs(dest);
        String destFilePath = dest + "/" + new File(path).getName();
        new File(destFilePath).createNewFile();
        try (BufferedInputStream input = new BufferedInputStream(new FileInputStream(path));
             BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(destFilePath), 2048);){
            this.copy(input, output);
            output.flush();
        }
    }

    private void unjar(URL jarUrl, String dirPath, String regexFilter) {
        this.mkdirs(dirPath);
        Pattern regex = Pattern.compile(regexFilter);
        InputStream uis = jarUrl.openStream();
        try (ZipInputStream zis = new ZipInputStream(new BufferedInputStream(uis));){
            this.extractEntry$1(zis.getNextEntry(), dirPath, regex, zis);
        }
    }

    public static /* synthetic */ void copy$(FileSystem $this, InputStream input, OutputStream output) {
        $this.copy(input, output);
    }

    default public void copy(InputStream input, OutputStream output) {
        byte[] data = new byte[2048];
        this.readData$1(input.read(data, 0, 2048), input, output, data);
    }

    public static /* synthetic */ void copySpecResourcesDir$(FileSystem $this, String base, String src, String outputDir, ClassLoader loader) {
        $this.copySpecResourcesDir(base, src, outputDir, loader);
    }

    default public void copySpecResourcesDir(String base, String src, String outputDir, ClassLoader loader) {
        Option$.MODULE$.apply((Object)loader.getResource(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{base, src})))).foreach((Function1 & Serializable & scala.Serializable)url -> {
            FileSystem.$anonfun$copySpecResourcesDir$1(this, base, src, outputDir, url);
            return BoxedUnit.UNIT;
        });
    }

    private URL jarOf(URL url) {
        return ((JarURLConnection)url.openConnection()).getJarFileURL();
    }

    public static /* synthetic */ boolean samePath$(FileSystem $this, String p1, String p2) {
        return $this.samePath(p1, p2);
    }

    default public boolean samePath(String p1, String p2) {
        String string = new File(p1).getCanonicalPath();
        String string2 = new File(p2).getCanonicalPath();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static /* synthetic */ boolean $anonfun$isVersionFile$1(File f$1, String x$1) {
        return f$1.getPath().contains(x$1);
    }

    public static /* synthetic */ void $anonfun$copyDir$2(FileSystem $this, String src$1, String dest$1, String name) {
        String path = src$1 + "/" + name;
        if (new File(path).isDirectory()) {
            $this.copyDir(path, dest$1);
        } else {
            $this.copyFile(path, dest$1);
        }
    }

    private void extractEntry$1(ZipEntry entry, String dirPath$1, Pattern regex$1, ZipInputStream zis$1) {
        while (entry != null) {
            Object object;
            Matcher matcher = regex$1.matcher(entry.getName());
            if (matcher.matches()) {
                String target = matcher.replaceFirst(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "$1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Matcher.quoteReplacement(dirPath$1)})));
                if (entry.isDirectory()) {
                    object = BoxesRunTime.boxToBoolean((boolean)this.createDir(target));
                } else {
                    this.createFile(target);
                    FileOutputStream fos = new FileOutputStream(target);
                    try (BufferedOutputStream dest = new BufferedOutputStream(fos, 2048);){
                        this.copy(zis$1, dest);
                        dest.flush();
                    }
                    object = BoxedUnit.UNIT;
                }
            } else {
                object = BoxedUnit.UNIT;
            }
            entry = zis$1.getNextEntry();
        }
    }

    private void readData$1(int count, InputStream input$1, OutputStream output$1, byte[] data$1) {
        while (count != -1) {
            output$1.write(data$1, 0, count);
            output$1.flush();
            count = input$1.read(data$1, 0, 2048);
        }
    }

    public static /* synthetic */ void $anonfun$copySpecResourcesDir$1(FileSystem $this, String base$1, String src$2, String outputDir$1, URL url) {
        if (url.getProtocol().equalsIgnoreCase("jar")) {
            $this.unjar($this.jarOf(url), outputDir$1, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"^", "(/", "/.*)$"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Pattern.quote(base$1), Pattern.quote(src$2)})));
        } else {
            $this.copyDir(url.getPath(), new File(outputDir$1, src$2).getPath());
        }
    }

    public static void $init$(FileSystem $this) {
    }
}

