/*
 * Decompiled with CFR 0.152.
 */
package org.specs2.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.specs2.control.eff.Eff;
import org.specs2.control.eff.Eff$;
import org.specs2.control.eff.Evaluate;
import org.specs2.control.eff.Fx1;
import org.specs2.control.eff.Fx3;
import org.specs2.control.eff.FxAppend;
import org.specs2.control.eff.MemberIn$;
import org.specs2.control.eff.MemberInOut$;
import org.specs2.control.eff.Safe;
import org.specs2.control.eff.Writer;
import org.specs2.control.eff.syntax.all$;
import org.specs2.control.package$Operations$;
import org.specs2.fp.Traverse$;
import org.specs2.fp.package;
import org.specs2.io.DirectoryPath;
import org.specs2.io.FilePath;
import org.specs2.io.FilePathReader;
import org.specs2.io.FileSystem$copyLock$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Right$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015da\u0002\f\u0018!\u0003\r\tA\b\u0005\u0006S\u0001!\tA\u000b\u0005\u0006]\u0001!\ta\f\u0005\u0006\t\u0002!\t!\u0012\u0005\u00063\u0002!\tA\u0017\u0005\u0006A\u0002!\t!\u0019\u0005\u0006K\u0002!\tA\u001a\u0005\u0006Y\u0002!\t!\u001c\u0005\u0006Y\u0002!\tA\u001d\u0005\u0006i\u0002!\t!\u001e\u0005\b\u0003\u0013\u0001A\u0011BA\u0006\u0011\u001d\t)\u0003\u0001C\u0001\u0003OAq!a\f\u0001\t\u0003\t\td\u0002\u0005\u0002:\u0001\u0001\u000b\u0012BA\u001e\r!\ty\u0004\u0001Q\t\n\u0005\u0005\u0003bBA\"\u001d\u0011\u0005\u0011Q\t\u0005\b\u0003\u000f\u0002A\u0011AA%\u0011\u001d\ti\u0005\u0001C\u0001\u0003\u001fBq!!\u0014\u0001\t\u0003\t)fB\u0004\u0002\\]A\t!!\u0018\u0007\rY9\u0002\u0012AA0\u0011\u001d\t\u0019\u0005\u0006C\u0001\u0003G\u0012!BR5mKNK8\u000f^3n\u0015\tA\u0012$\u0001\u0002j_*\u0011!dG\u0001\u0007gB,7m\u001d\u001a\u000b\u0003q\t1a\u001c:h\u0007\u0001\u00192\u0001A\u0010&!\t\u00013%D\u0001\"\u0015\u0005\u0011\u0013!B:dC2\f\u0017B\u0001\u0013\"\u0005\u0019\te.\u001f*fMB\u0011aeJ\u0007\u0002/%\u0011\u0001f\u0006\u0002\u000f\r&dW\rU1uQJ+\u0017\rZ3s\u0003\u0019!\u0013N\\5uIQ\t1\u0006\u0005\u0002!Y%\u0011Q&\t\u0002\u0005+:LG/\u0001\u0006eK2,G/\u001a$jY\u0016$\"\u0001M \u0011\u0007EJDH\u0004\u00023m9\u00111\u0007N\u0007\u00023%\u0011Q'G\u0001\bG>tGO]8m\u0013\t9\u0004(A\u0004qC\u000e\\\u0017mZ3\u000b\u0005UJ\u0012B\u0001\u001e<\u0005%y\u0005/\u001a:bi&|gN\u0003\u00028qA\u0011\u0001%P\u0005\u0003}\u0005\u0012qAQ8pY\u0016\fg\u000eC\u0003A\u0005\u0001\u0007\u0011)\u0001\u0005gS2,\u0007+\u0019;i!\t1#)\u0003\u0002D/\tAa)\u001b7f!\u0006$\b.A\tva\u0012\fG/\u001a$jY\u0016\u001cuN\u001c;f]R$\"A\u0012-\u0015\u0005\u001dC\u0005cA\u0019:W!)\u0011j\u0001a\u0001\u0015\u00061Q\u000f\u001d3bi\u0016\u0004B\u0001I&N\u001b&\u0011A*\t\u0002\n\rVt7\r^5p]F\u0002\"AT+\u000f\u0005=\u001b\u0006C\u0001)\"\u001b\u0005\t&B\u0001*\u001e\u0003\u0019a$o\\8u}%\u0011A+I\u0001\u0007!J,G-\u001a4\n\u0005Y;&AB*ue&twM\u0003\u0002UC!)\u0001i\u0001a\u0001\u0003\u0006i!/\u001a9mC\u000e,\u0017J\u001c$jY\u0016$BaR.]=\")\u0001\t\u0002a\u0001\u0003\")Q\f\u0002a\u0001\u001b\u000611o\\;sG\u0016DQa\u0018\u0003A\u00025\u000ba\u0001^1sO\u0016$\u0018!C<sSR,g)\u001b7f)\r9%m\u0019\u0005\u0006\u0001\u0016\u0001\r!\u0011\u0005\u0006I\u0016\u0001\r!T\u0001\bG>tG/\u001a8u\u0003E9\u0018\u000e\u001e5Fa\",W.\u001a:bY\u001aKG.\u001a\u000b\u0003O*$\"a\u00125\t\u000b%4\u0001\u0019A$\u0002\u0013=\u0004XM]1uS>t\u0007\"B6\u0007\u0001\u0004\t\u0015\u0001\u00029bi\"\fa!\\6eSJ\u001cHCA$o\u0011\u0015Yw\u00011\u0001p!\t1\u0003/\u0003\u0002r/\tiA)\u001b:fGR|'/\u001f)bi\"$\"aR:\t\u000b-D\u0001\u0019A!\u0002\u000bUt'.\u0019:\u0015\r\u001d3\u0018\u0011AA\u0003\u0011\u00159\u0018\u00021\u0001y\u0003\u0019Q\u0017M]+sYB\u0011\u0011P`\u0007\u0002u*\u00111\u0010`\u0001\u0004]\u0016$(\"A?\u0002\t)\fg/Y\u0005\u0003\u007fj\u00141!\u0016*M\u0011\u0019\t\u0019!\u0003a\u0001_\u0006!A-Z:u\u0011\u0019\t9!\u0003a\u0001\u001b\u0006Y!/Z4fq\u001aKG\u000e^3s\u0003\u0011\u0019w\u000e]=\u0015\u000b-\ni!a\u0007\t\u000f\u0005=!\u00021\u0001\u0002\u0012\u0005)\u0011N\u001c9viB!\u00111CA\f\u001b\t\t)B\u0003\u0002\u0019y&!\u0011\u0011DA\u000b\u0005-Ie\u000e];u'R\u0014X-Y7\t\u000f\u0005u!\u00021\u0001\u0002 \u00051q.\u001e;qkR\u0004B!a\u0005\u0002\"%!\u00111EA\u000b\u00051yU\u000f\u001e9viN#(/Z1n\u0003\u001d\u0019w\u000e]=ESJ$RaRA\u0015\u0003[Aa!a\u000b\f\u0001\u0004y\u0017aA:sG\"1\u00111A\u0006A\u0002=\f\u0001bY8qs\u001aKG.\u001a\u000b\u0005\u0003g\t9\u0004F\u0002H\u0003kAQ\u0001\u0011\u0007A\u0002\u0005Ca!a\u0001\r\u0001\u0004y\u0017\u0001C2pafdunY6\u0011\u0007\u0005ub\"D\u0001\u0001\u0005!\u0019w\u000e]=M_\u000e\\7C\u0001\b \u0003\u0019a\u0014N\\5u}Q\u0011\u00111H\u0001\u000bGJ,\u0017\r^3GS2,Gc\u0001\u0019\u0002L!)\u0001\t\u0005a\u0001\u0003\u00061A-\u001a7fi\u0016$2aRA)\u0011\u0019\t\u0019&\u0005a\u0001\u0003\u0006!a-\u001b7f)\r9\u0015q\u000b\u0005\u0007\u00033\u0012\u0002\u0019A8\u0002\u0007\u0011L'/\u0001\u0006GS2,7+_:uK6\u0004\"A\n\u000b\u0014\tQy\u0012\u0011\r\t\u0003M\u0001!\"!!\u0018")
public interface FileSystem
extends FilePathReader {
    public FileSystem$copyLock$ org$specs2$io$FileSystem$$copyLock();

    public static /* synthetic */ Eff deleteFile$(FileSystem $this, FilePath filePath) {
        return $this.deleteFile(filePath);
    }

    default public Eff<FxAppend<Fx1<Evaluate>, Fx3<Writer, Writer, Safe>>, Object> deleteFile(FilePath filePath) {
        return package$Operations$.MODULE$.delayed((JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> filePath.toFile().delete());
    }

    public static /* synthetic */ Eff updateFileContent$(FileSystem $this, FilePath filePath, Function1 update) {
        return $this.updateFileContent(filePath, (Function1<String, String>)update);
    }

    default public Eff<FxAppend<Fx1<Evaluate>, Fx3<Writer, Writer, Safe>>, BoxedUnit> updateFileContent(FilePath filePath, Function1<String, String> update) {
        return this.readFile(filePath).flatMap((Function1 & Serializable & scala.Serializable)s -> this.writeFile(filePath, (String)update.apply(s)));
    }

    public static /* synthetic */ Eff replaceInFile$(FileSystem $this, FilePath filePath, String source, String target) {
        return $this.replaceInFile(filePath, source, target);
    }

    default public Eff<FxAppend<Fx1<Evaluate>, Fx3<Writer, Writer, Safe>>, BoxedUnit> replaceInFile(FilePath filePath, String source, String target) {
        return this.updateFileContent(filePath, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)x$1 -> x$1.replace(source, target));
    }

    public static /* synthetic */ Eff writeFile$(FileSystem $this, FilePath filePath, String content) {
        return $this.writeFile(filePath, content);
    }

    default public Eff<FxAppend<Fx1<Evaluate>, Fx3<Writer, Writer, Safe>>, BoxedUnit> writeFile(FilePath filePath, String content) {
        return (Eff)package.syntax$.MODULE$.MonadOps(this.mkdirs(filePath), Eff$.MODULE$.EffMonad()).$greater$greater(package$Operations$.MODULE$.protect((Function0 & Serializable & scala.Serializable)() -> {
            Left left;
            try (PrintWriter writer2 = new PrintWriter(filePath.path(), "UTF-8");){
                try {
                    Right$ right$ = package$.MODULE$.Right();
                    writer2.write(content);
                    left = right$.apply((Object)BoxedUnit.UNIT);
                }
                catch (Exception e) {
                    left = package$.MODULE$.Left().apply((Object)e);
                }
            }
            return left;
        }).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Either either = x0$1;
            if (either instanceof Left) {
                Left left = (Left)either;
                Exception e = (Exception)left.value();
                return (Eff)package.syntax$.MODULE$.MonadOps(package$Operations$.MODULE$.logThrowable(e, MemberIn$.MODULE$.MemberInAppendR(MemberIn$.MODULE$.MemberIn3L())), Eff$.MODULE$.EffMonad()).$greater$greater(package$Operations$.MODULE$.warn(new StringBuilder(21).append("could not write file ").append(filePath.path()).toString()));
            }
            if (either instanceof Right) {
                return package$Operations$.MODULE$.unit();
            }
            throw new MatchError((Object)either);
        }));
    }

    public static /* synthetic */ Eff withEphemeralFile$(FileSystem $this, FilePath path, Eff operation) {
        return $this.withEphemeralFile(path, operation);
    }

    default public Eff<FxAppend<Fx1<Evaluate>, Fx3<Writer, Writer, Safe>>, BoxedUnit> withEphemeralFile(FilePath path, Eff<FxAppend<Fx1<?>, Fx3<?, ?, Safe>>, BoxedUnit> operation) {
        return all$.MODULE$.SafeEffectOps(operation).thenFinally((Eff)package.syntax$.MODULE$.FunctorOps(this.deleteFile(path), Eff$.MODULE$.EffMonad()).void(), MemberInOut$.MODULE$.MemberInOutAppendR(MemberInOut$.MODULE$.MemberInOut3R()));
    }

    public static /* synthetic */ Eff mkdirs$(FileSystem $this, DirectoryPath path) {
        return $this.mkdirs(path);
    }

    default public Eff<FxAppend<Fx1<Evaluate>, Fx3<Writer, Writer, Safe>>, BoxedUnit> mkdirs(DirectoryPath path) {
        return (Eff)package.syntax$.MODULE$.FunctorOps(package$Operations$.MODULE$.protect((JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> path.toFile().mkdirs()), Eff$.MODULE$.EffMonad()).void();
    }

    public static /* synthetic */ Eff mkdirs$(FileSystem $this, FilePath path) {
        return $this.mkdirs(path);
    }

    default public Eff<FxAppend<Fx1<Evaluate>, Fx3<Writer, Writer, Safe>>, BoxedUnit> mkdirs(FilePath path) {
        return this.mkdirs(path.dir());
    }

    public static /* synthetic */ Eff unjar$(FileSystem $this, URL jarUrl, DirectoryPath dest, String regexFilter) {
        return $this.unjar(jarUrl, dest, regexFilter);
    }

    default public Eff<FxAppend<Fx1<Evaluate>, Fx3<Writer, Writer, Safe>>, BoxedUnit> unjar(URL jarUrl, DirectoryPath dest, String regexFilter) {
        Pattern regex = Pattern.compile(regexFilter);
        InputStream uis = jarUrl.openStream();
        ZipInputStream zis = new ZipInputStream(new BufferedInputStream(uis));
        return package$Operations$.MODULE$.delayed((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            try {
                this.extractEntry$1(zis.getNextEntry(), regex, dest, zis);
            }
            finally {
                zis.close();
            }
        });
    }

    private void copy(InputStream input, OutputStream output) {
        byte[] data = new byte[2048];
        this.readData$1(input.read(data, 0, 2048), output, data, input);
    }

    public static /* synthetic */ Eff copyDir$(FileSystem $this, DirectoryPath src, DirectoryPath dest) {
        return $this.copyDir(src, dest);
    }

    default public Eff<FxAppend<Fx1<Evaluate>, Fx3<Writer, Writer, Safe>>, BoxedUnit> copyDir(DirectoryPath src, DirectoryPath dest) {
        return (Eff)package.syntax$.MODULE$.MonadOps(package.syntax$.MODULE$.MonadOps(this.mkdirs(dest), Eff$.MODULE$.EffMonad()).$greater$greater(this.listDirectFilePaths(src).flatMap((Function1 & Serializable & scala.Serializable)files -> (Eff)package.syntax$.MODULE$.FunctorOps(package.syntax$.MODULE$.SequenceOps(files.toList().map((Function1 & Serializable & scala.Serializable)filePath -> this.copyFile(dest, (FilePath)filePath), List$.MODULE$.canBuildFrom()), Traverse$.MODULE$.listInstance(), Eff$.MODULE$.EffMonad()).sequence(), Eff$.MODULE$.EffMonad()).void())), Eff$.MODULE$.EffMonad()).$greater$greater(this.listDirectDirectoryPaths(src).flatMap((Function1 & Serializable & scala.Serializable)directories -> (Eff)package.syntax$.MODULE$.FunctorOps(package.syntax$.MODULE$.SequenceOps(directories.toList().map((Function1 & Serializable & scala.Serializable)dir -> this.copyDir((DirectoryPath)dir, dest.$div(dir.name())), List$.MODULE$.canBuildFrom()), Traverse$.MODULE$.listInstance(), Eff$.MODULE$.EffMonad()).sequence(), Eff$.MODULE$.EffMonad()).void()));
    }

    public static /* synthetic */ Eff copyFile$(FileSystem $this, DirectoryPath dest, FilePath filePath) {
        return $this.copyFile(dest, filePath);
    }

    default public Eff<FxAppend<Fx1<Evaluate>, Fx3<Writer, Writer, Safe>>, BoxedUnit> copyFile(DirectoryPath dest, FilePath filePath) {
        return (Eff)package.syntax$.MODULE$.MonadOps(this.mkdirs(dest), Eff$.MODULE$.EffMonad()).$greater$greater(package.syntax$.MODULE$.FunctorOps(package$Operations$.MODULE$.delayed((Function0 & Serializable & scala.Serializable)() -> {
            Path path;
            FileSystem$copyLock$ fileSystem$copyLock$ = this.org$specs2$io$FileSystem$$copyLock();
            synchronized (fileSystem$copyLock$) {
                path = Files.copy(Paths.get(filePath.path(), new String[0]), Paths.get(dest.path(), new String[0]).resolve(Paths.get(filePath.name().name(), new String[0])), StandardCopyOption.REPLACE_EXISTING);
            }
            return path;
        }), Eff$.MODULE$.EffMonad()).void());
    }

    public static /* synthetic */ Eff createFile$(FileSystem $this, FilePath filePath) {
        return $this.createFile(filePath);
    }

    default public Eff<FxAppend<Fx1<Evaluate>, Fx3<Writer, Writer, Safe>>, Object> createFile(FilePath filePath) {
        return (Eff)package.syntax$.MODULE$.MonadOps(this.mkdirs(filePath.dir()), Eff$.MODULE$.EffMonad()).$greater$greater(package$Operations$.MODULE$.delayed((JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> filePath.toFile().createNewFile()));
    }

    public static /* synthetic */ Eff delete$(FileSystem $this, FilePath file) {
        return $this.delete(file);
    }

    default public Eff<FxAppend<Fx1<Evaluate>, Fx3<Writer, Writer, Safe>>, BoxedUnit> delete(FilePath file) {
        return (Eff)package.syntax$.MODULE$.FunctorOps(package$Operations$.MODULE$.delayed((JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> file.toFile().delete()), Eff$.MODULE$.EffMonad()).void();
    }

    public static /* synthetic */ Eff delete$(FileSystem $this, DirectoryPath dir) {
        return $this.delete(dir);
    }

    default public Eff<FxAppend<Fx1<Evaluate>, Fx3<Writer, Writer, Safe>>, BoxedUnit> delete(DirectoryPath dir) {
        return (Eff)package.syntax$.MODULE$.MonadOps(this.listFilePaths(dir).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> (Eff)package.syntax$.MODULE$.FunctorOps(package.syntax$.MODULE$.SequenceOps((Object)((List)x$2.map((Function1 & Serializable & scala.Serializable)file -> this.delete((FilePath)file), List$.MODULE$.canBuildFrom())).toList(), Traverse$.MODULE$.listInstance(), Eff$.MODULE$.EffMonad()).sequence(), Eff$.MODULE$.EffMonad()).void()), Eff$.MODULE$.EffMonad()).$greater$greater(this.delete(dir.toFilePath()));
    }

    private void extractEntry$1(ZipEntry entry, Pattern regex$1, DirectoryPath dest$1, ZipInputStream zis$1) {
        while (entry != null) {
            Matcher matcher = regex$1.matcher(entry.getName());
            if (matcher.matches()) {
                String target = matcher.replaceFirst(new StringBuilder(2).append(Matcher.quoteReplacement(dest$1.path())).append("$1").toString());
                if (!entry.isDirectory()) {
                    new File(target).getParentFile().mkdirs();
                    new File(target).createNewFile();
                    FileOutputStream fos = new FileOutputStream(target);
                    try (BufferedOutputStream dest = new BufferedOutputStream(fos, 2048);){
                        this.copy(zis$1, dest);
                        dest.flush();
                    }
                }
            }
            entry = zis$1.getNextEntry();
        }
    }

    private void readData$1(int count, OutputStream output$1, byte[] data$1, InputStream input$1) {
        while (count != -1) {
            output$1.write(data$1, 0, count);
            output$1.flush();
            count = input$1.read(data$1, 0, 2048);
        }
    }

    public static void $init$(FileSystem $this) {
    }
}

