/*
 * Decompiled with CFR 0.152.
 */
package spire.math;

import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichFloat;
import spire.math.package$;

public final class FastComplex$ {
    public static FastComplex$ MODULE$;
    private final long i;
    private final long one;
    private final long zero;

    static {
        new FastComplex$();
    }

    public final long apply(float real, float imag) {
        return (long)Float.floatToIntBits(real) & 0xFFFFFFFFL | ((long)Float.floatToIntBits(imag) & 0xFFFFFFFFL) << 32;
    }

    public final long apply(double real, double imag) {
        float encode_imag = (float)imag;
        return (long)Float.floatToIntBits((float)real) & 0xFFFFFFFFL | ((long)Float.floatToIntBits(encode_imag) & 0xFFFFFFFFL) << 32;
    }

    public final int bits(float n) {
        return Float.floatToIntBits(n);
    }

    public final float bits(int n) {
        return Float.intBitsToFloat(n);
    }

    public final float real(long d) {
        return Float.intBitsToFloat((int)(d & 0xFFFFFFFFFFFFFFFFL));
    }

    public final float imag(long d) {
        return Float.intBitsToFloat((int)(d >>> 32));
    }

    public final long i() {
        return this.i;
    }

    public final long one() {
        return this.one;
    }

    public final long zero() {
        return this.zero;
    }

    public final long encode(float real, float imag) {
        return (long)Float.floatToIntBits(real) & 0xFFFFFFFFL | ((long)Float.floatToIntBits(imag) & 0xFFFFFFFFL) << 32;
    }

    public final long polar(float magnitude, float angle) {
        float encode_imag = magnitude * (float)Math.sin(angle);
        return (long)Float.floatToIntBits(magnitude * (float)Math.cos(angle)) & 0xFFFFFFFFL | ((long)Float.floatToIntBits(encode_imag) & 0xFFFFFFFFL) << 32;
    }

    public final Tuple2<Object, Object> decode(long d) {
        return new Tuple2((Object)BoxesRunTime.boxToFloat((float)Float.intBitsToFloat((int)(d & 0xFFFFFFFFFFFFFFFFL))), (Object)BoxesRunTime.boxToFloat((float)Float.intBitsToFloat((int)(d >>> 32))));
    }

    public final String toRepr(long d) {
        String string = "FastComplex(%s -> %s)";
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        return new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)d), this.decode(d)}));
    }

    public final float abs(long d) {
        float f = Float.intBitsToFloat((int)(d & 0xFFFFFFFFFFFFFFFFL));
        float f2 = Float.intBitsToFloat((int)(d >>> 32));
        return (float)Math.sqrt(f * f + f2 * f2);
    }

    public final float angle(long d) {
        return (float)Math.atan2(Float.intBitsToFloat((int)(d >>> 32)), Float.intBitsToFloat((int)(d & 0xFFFFFFFFFFFFFFFFL)));
    }

    public final long conjugate(long d) {
        float f = Float.intBitsToFloat((int)(d & 0xFFFFFFFFFFFFFFFFL));
        float encode_imag = -Float.intBitsToFloat((int)(d >>> 32));
        return (long)Float.floatToIntBits(f) & 0xFFFFFFFFL | ((long)Float.floatToIntBits(encode_imag) & 0xFFFFFFFFL) << 32;
    }

    public final boolean isWhole(long d) {
        return Float.intBitsToFloat((int)(d & 0xFFFFFFFFFFFFFFFFL)) % 1.0f == 0.0f && Float.intBitsToFloat((int)(d >>> 32)) % 1.0f == 0.0f;
    }

    public final int signum(long d) {
        float f = Float.intBitsToFloat((int)(d & 0xFFFFFFFFFFFFFFFFL));
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        return new RichFloat(f).compare((Object)BoxesRunTime.boxToFloat((float)0.0f));
    }

    public final long complexSignum(long d) {
        float m = this.abs(d);
        if (m == 0.0f) {
            return this.zero();
        }
        float encode_imag = 0.0f;
        return this.divide(d, (long)Float.floatToIntBits(m) & 0xFFFFFFFFL | ((long)Float.floatToIntBits(encode_imag) & 0xFFFFFFFFL) << 32);
    }

    public final long negate(long a) {
        float encode_imag = -Float.intBitsToFloat((int)(a >>> 32));
        return (long)Float.floatToIntBits(-Float.intBitsToFloat((int)(a & 0xFFFFFFFFFFFFFFFFL))) & 0xFFFFFFFFL | ((long)Float.floatToIntBits(encode_imag) & 0xFFFFFFFFL) << 32;
    }

    public final long add(long a, long b) {
        float encode_imag = Float.intBitsToFloat((int)(a >>> 32)) + Float.intBitsToFloat((int)(b >>> 32));
        return (long)Float.floatToIntBits(Float.intBitsToFloat((int)(a & 0xFFFFFFFFFFFFFFFFL)) + Float.intBitsToFloat((int)(b & 0xFFFFFFFFFFFFFFFFL))) & 0xFFFFFFFFL | ((long)Float.floatToIntBits(encode_imag) & 0xFFFFFFFFL) << 32;
    }

    public final long subtract(long a, long b) {
        float encode_imag = Float.intBitsToFloat((int)(a >>> 32)) - Float.intBitsToFloat((int)(b >>> 32));
        return (long)Float.floatToIntBits(Float.intBitsToFloat((int)(a & 0xFFFFFFFFFFFFFFFFL)) - Float.intBitsToFloat((int)(b & 0xFFFFFFFFFFFFFFFFL))) & 0xFFFFFFFFL | ((long)Float.floatToIntBits(encode_imag) & 0xFFFFFFFFL) << 32;
    }

    public final long multiply(long a, long b) {
        float f = Float.intBitsToFloat((int)(a & 0xFFFFFFFFFFFFFFFFL));
        float f2 = Float.intBitsToFloat((int)(a >>> 32));
        float f3 = Float.intBitsToFloat((int)(b & 0xFFFFFFFFFFFFFFFFL));
        float f4 = Float.intBitsToFloat((int)(b >>> 32));
        float encode_imag = f2 * f3 + f * f4;
        return (long)Float.floatToIntBits(f * f3 - f2 * f4) & 0xFFFFFFFFL | ((long)Float.floatToIntBits(encode_imag) & 0xFFFFFFFFL) << 32;
    }

    public final long divide(long a, long b) {
        float abs_im_b;
        float f = Float.intBitsToFloat((int)(a & 0xFFFFFFFFFFFFFFFFL));
        float f2 = Float.intBitsToFloat((int)(a >>> 32));
        float f3 = Float.intBitsToFloat((int)(b & 0xFFFFFFFFFFFFFFFFL));
        float f4 = Float.intBitsToFloat((int)(b >>> 32));
        float abs_re_b = Math.abs(f3);
        if (abs_re_b >= (abs_im_b = Math.abs(f4))) {
            if (abs_re_b == 0.0f) {
                throw new ArithmeticException("/0");
            }
            float ratio = f4 / f3;
            float denom = f3 + f4 * ratio;
            float encode_imag = (f2 - f * ratio) / denom;
            return (long)Float.floatToIntBits((f + f2 * ratio) / denom) & 0xFFFFFFFFL | ((long)Float.floatToIntBits(encode_imag) & 0xFFFFFFFFL) << 32;
        }
        if (abs_im_b == 0.0f) {
            throw new ArithmeticException("/0");
        }
        float ratio = f3 / f4;
        float denom = f3 * ratio + f4;
        float encode_imag = (f2 * ratio - f) / denom;
        return (long)Float.floatToIntBits((f * ratio + f2) / denom) & 0xFFFFFFFFL | ((long)Float.floatToIntBits(encode_imag) & 0xFFFFFFFFL) << 32;
    }

    public final long quot(long a, long b) {
        float encode_imag = 0.0f;
        return (long)Float.floatToIntBits((float)Math.floor(Float.intBitsToFloat((int)(this.divide(a, b) & 0xFFFFFFFFFFFFFFFFL)))) & 0xFFFFFFFFL | ((long)Float.floatToIntBits(encode_imag) & 0xFFFFFFFFL) << 32;
    }

    public final long mod(long a, long b) {
        return this.subtract(a, this.multiply(b, this.quot(a, b)));
    }

    public final Tuple2<Object, Object> quotmod(long a, long b) {
        long q = this.quot(a, b);
        return new Tuple2.mcJJ.sp(q, this.subtract(a, this.multiply(b, this.quot(a, b))));
    }

    public final long pow(long a, long b) {
        if (b == this.zero()) {
            float encode_imag = 0.0f;
            return (long)Float.floatToIntBits(1.0f) & 0xFFFFFFFFL | ((long)Float.floatToIntBits(encode_imag) & 0xFFFFFFFFL) << 32;
        }
        if (a == this.zero()) {
            if (Float.intBitsToFloat((int)(b >>> 32)) != 0.0f || Float.intBitsToFloat((int)(b & 0xFFFFFFFFFFFFFFFFL)) < 0.0f) {
                throw new Exception("raising 0 to negative/complex power");
            }
            return this.zero();
        }
        if (Float.intBitsToFloat((int)(b >>> 32)) != 0.0f) {
            float f = Float.intBitsToFloat((int)(b >>> 32));
            float f2 = Float.intBitsToFloat((int)(b & 0xFFFFFFFFFFFFFFFFL));
            float len = (float)(Math.pow(this.abs(a), f2) / package$.MODULE$.exp(this.angle(a) * f));
            float phase = (float)((double)(this.angle(a) * f2) + package$.MODULE$.log(this.abs(a)) * (double)f);
            float polar_encode_imag = len * (float)Math.sin(phase);
            return (long)Float.floatToIntBits(len * (float)Math.cos(phase)) & 0xFFFFFFFFL | ((long)Float.floatToIntBits(polar_encode_imag) & 0xFFFFFFFFL) << 32;
        }
        float len = (float)Math.pow(this.abs(a), Float.intBitsToFloat((int)(b & 0xFFFFFFFFFFFFFFFFL)));
        float phase = this.angle(a) * Float.intBitsToFloat((int)(b & 0xFFFFFFFFFFFFFFFFL));
        float polar_encode_imag = len * (float)Math.sin(phase);
        return (long)Float.floatToIntBits(len * (float)Math.cos(phase)) & 0xFFFFFFFFL | ((long)Float.floatToIntBits(polar_encode_imag) & 0xFFFFFFFFL) << 32;
    }

    private FastComplex$() {
        MODULE$ = this;
        float encode_imag = 1.0f;
        this.i = (long)Float.floatToIntBits(0.0f) & 0xFFFFFFFFL | ((long)Float.floatToIntBits(encode_imag) & 0xFFFFFFFFL) << 32;
        float encode_imag2 = 0.0f;
        this.one = (long)Float.floatToIntBits(1.0f) & 0xFFFFFFFFL | ((long)Float.floatToIntBits(encode_imag2) & 0xFFFFFFFFL) << 32;
        float encode_imag3 = 0.0f;
        this.zero = (long)Float.floatToIntBits(0.0f) & 0xFFFFFFFFL | ((long)Float.floatToIntBits(encode_imag3) & 0xFFFFFFFFL) << 32;
    }
}

