/*
 * Decompiled with CFR 0.152.
 */
package spire.math;

import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.math.Ordered;
import scala.math.ScalaNumber;
import scala.math.ScalaNumericAnyConversions;
import scala.math.ScalaNumericConversions;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichLong;
import scala.runtime.RichLong$;
import scala.runtime.Statics;
import spire.algebra.Sign;
import spire.algebra.Sign$;
import spire.algebra.Sign$Negative$;
import spire.algebra.Sign$Positive$;
import spire.algebra.Sign$Zero$;
import spire.math.Algebraic;
import spire.math.Algebraic$;
import spire.math.Complex;
import spire.math.Natural;
import spire.math.Number;
import spire.math.Number$;
import spire.math.NumberTag;
import spire.math.Quaternion;
import spire.math.Rational$;
import spire.math.RationalAlgebra;
import spire.math.Real;
import spire.math.Real$;
import spire.math.SafeLong;
import spire.math.SafeLong$;
import spire.math.SafeLongBigInteger;
import spire.math.SafeLongLong;
import spire.math.package$;
import spire.std.package$long$;
import spire.util.Opt$;

@ScalaSignature(bytes="\u0006\u0001\u0011%a!B\u0001\u0003\u0003C9!\u0001\u0003*bi&|g.\u00197\u000b\u0005\r!\u0011\u0001B7bi\"T\u0011!B\u0001\u0006gBL'/Z\u0002\u0001'\u0011\u0001\u0001b\u0004\n\u0011\u0005%iQ\"\u0001\u0006\u000b\u0005\rY!\"\u0001\u0007\u0002\u000bM\u001c\u0017\r\\1\n\u00059Q!aC*dC2\fg*^7cKJ\u0004\"!\u0003\t\n\u0005EQ!aF*dC2\fg*^7fe&\u001c7i\u001c8wKJ\u001c\u0018n\u001c8t!\r\u00192D\b\b\u0003)eq!!\u0006\r\u000e\u0003YQ!a\u0006\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005a\u0011B\u0001\u000e\f\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001H\u000f\u0003\u000f=\u0013H-\u001a:fI*\u0011!d\u0003\t\u0003?\u0001i\u0011A\u0001\u0005\u0006C\u0001!\tAI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003yAQ\u0001\n\u0001\u0007\u0002\u0015\n\u0011B\\;nKJ\fGo\u001c:\u0016\u0003\u0019\u0002\"aH\u0014\n\u0005!\u0012!\u0001C*bM\u0016duN\\4\t\u000b)\u0002a\u0011A\u0013\u0002\u0017\u0011,gn\\7j]\u0006$xN\u001d\u0005\u0006Y\u00011\t!L\u0001\u0010]VlWM]1u_J\f5\u000fT8oOV\ta\u0006\u0005\u00020a5\t1\"\u0003\u00022\u0017\t!Aj\u001c8h\u0011\u0015\u0019\u0004A\"\u0001.\u0003E!WM\\8nS:\fGo\u001c:Bg2{gn\u001a\u0005\u0006k\u00011\tAN\u0001\fSN4\u0016\r\\5e\u0019>tw-F\u00018!\ty\u0003(\u0003\u0002:\u0017\t9!i\\8mK\u0006t\u0007\"B\u001e\u0001\r\u0003a\u0014aB5t/\"|G.\u001a\u000b\u0002o!)a\b\u0001C\u0001\u007f\u0005IAn\u001c8h-\u0006dW/\u001a\u000b\u0002]!)\u0011\t\u0001C\u0001\u0005\u0006A\u0011N\u001c;WC2,X\rF\u0001D!\tyC)\u0003\u0002F\u0017\t\u0019\u0011J\u001c;\t\u000b\u001d\u0003A\u0011\u0001%\u0002\u0015\u0019dw.\u0019;WC2,X\rF\u0001J!\ty#*\u0003\u0002L\u0017\t)a\t\\8bi\")Q\n\u0001C!\u001d\u0006QQO\u001c3fe2L\u0018N\\4\u0015\u0003=\u0003\"\u0001U+\u000e\u0003ES!AU*\u0002\t1\fgn\u001a\u0006\u0002)\u0006!!.\u0019<b\u0013\t1\u0016K\u0001\u0004PE*,7\r\u001e\u0005\u00061\u0002!\t!W\u0001\u0004C\n\u001cX#\u0001\u0010\t\u000bm\u0003A\u0011A-\u0002\u000f%tg/\u001a:tK\")Q\f\u0001D\u00013\u0006Q!/Z2jaJ|7-\u00197\t\u000b}\u0003a\u0011\u00011\u0002\rMLwM\\;n+\u0005\u0019\u0005\"\u00022\u0001\r\u00031\u0014AB5t5\u0016\u0014x\u000eC\u0003e\u0001\u0019\u0005a'A\u0003jg>sW\rC\u0003g\u0001\u0019\u0005!%\u0001\u0007v]\u0006\u0014\u0018p\u0018\u0013nS:,8\u000fC\u0003i\u0001\u0019\u0005\u0011.A\u0003%a2,8\u000f\u0006\u0002\u001fU\")1n\u001aa\u0001=\u0005\u0019!\u000f[:\t\u000b5\u0004a\u0011\u00018\u0002\r\u0011j\u0017N\\;t)\tqr\u000eC\u0003lY\u0002\u0007a\u0004C\u0003r\u0001\u0019\u0005!/\u0001\u0004%i&lWm\u001d\u000b\u0003=MDQa\u001b9A\u0002yAQ!\u001e\u0001\u0007\u0002Y\fA\u0001\n3jmR\u0011ad\u001e\u0005\u0006WR\u0004\rA\b\u0005\u0006s\u0002!\tA_\u0001\u000bI\u0011Lg\u000f\n;jY\u0012,GC\u0001\u0010|\u0011\u0015Y\u0007\u00101\u0001\u001f\u0011\u0015i\b\u0001\"\u0001\u007f\u0003!!\u0003/\u001a:dK:$HC\u0001\u0010\u0000\u0011\u0015YG\u00101\u0001\u001f\u0011\u001d\t\u0019\u0001\u0001C\u0001\u0003\u000b\tA\u0002\n3jm\u0012\u0002XM]2f]R$B!a\u0002\u0002\u000eA)q&!\u0003\u001f=%\u0019\u00111B\u0006\u0003\rQ+\b\u000f\\33\u0011\u0019Y\u0017\u0011\u0001a\u0001=!9\u0011\u0011\u0003\u0001\u0007\u0002\u0005M\u0011aA4dIR\u0019a$!\u0006\t\r-\fy\u00011\u0001\u001f\u0011\u001d\tI\u0002\u0001C\u0001\u00037\ta\u0001^8SK\u0006dWCAA\u000f!\ry\u0012qD\u0005\u0004\u0003C\u0011!\u0001\u0002*fC2Dq!!\n\u0001\t\u0003\t9#A\u0006u_\u0006cw-\u001a2sC&\u001cWCAA\u0015!\ry\u00121F\u0005\u0004\u0003[\u0011!!C!mO\u0016\u0014'/Y5d\u0011\u001d\t\t\u0004\u0001C\u0001\u0003g\tA\u0002^8CS\u001e$UmY5nC2$b!!\u000e\u0002<\u0005}\u0002cA\n\u00028%\u0019\u0011\u0011H\u000f\u0003\u0015\tKw\rR3dS6\fG\u000eC\u0004\u0002>\u0005=\u0002\u0019A\"\u0002\u000bM\u001c\u0017\r\\3\t\u0011\u0005\u0005\u0013q\u0006a\u0001\u0003\u0007\nA!\\8eKB!\u0011QIA%\u001b\t\t9E\u0003\u0002\u0004'&!\u00111JA$\u00051\u0011v.\u001e8eS:<Wj\u001c3f\u0011\u001d\t\t\u0004\u0001C\u0001\u0003\u001f\"B!!\u000e\u0002R!A\u00111KA'\u0001\u0004\t)&\u0001\u0002nGB!\u0011QIA,\u0013\u0011\tI&a\u0012\u0003\u00175\u000bG\u000f[\"p]R,\u0007\u0010\u001e\u0005\u0007\u0003;\u0002a\u0011A\u0013\u0002\u0015Q|7+\u00194f\u0019>tw\rC\u0004\u0002b\u0001!)!a\u0019\u0002\u0011Q|')[4J]R,\"!!\u001a\u0011\u0007M\t9'C\u0002\u0002ju\u0011aAQ5h\u0013:$\bbBA7\u0001\u0011\u0005\u0013qN\u0001\u000bg\"|'\u000f\u001e,bYV,GCAA9!\ry\u00131O\u0005\u0004\u0003kZ!!B*i_J$\bbBA=\u0001\u0011\u0005\u00131P\u0001\nEf$XMV1mk\u0016$\"!! \u0011\u0007=\ny(C\u0002\u0002\u0002.\u0011AAQ=uK\"1\u0011Q\u0011\u0001\u0007\u0002e\u000bQA\u001a7p_JDa!!#\u0001\r\u0003I\u0016\u0001B2fS2Da!!$\u0001\r\u0003I\u0016!\u0002:pk:$\u0007bBAI\u0001\u0011\u0005\u00111S\u0001\be>,h\u000e\u001a+p)\rq\u0012Q\u0013\u0005\b\u0003/\u000by\t1\u0001'\u0003\u0015!WM\\8n\u0011\u001d\tY\n\u0001D\u0001\u0003;\u000b1\u0001]8x)\rq\u0012q\u0014\u0005\b\u0003C\u000bI\n1\u0001D\u0003\r)\u0007\u0010\u001d\u0005\b\u0003K\u0003A\u0011AAT\u0003\u0011\u0019\u0018n\u001a8\u0016\u0005\u0005%\u0006\u0003BAV\u0003ck!!!,\u000b\u0007\u0005=F!A\u0004bY\u001e,'M]1\n\t\u0005M\u0016Q\u0016\u0002\u0005'&<g\u000e\u0003\u0004\u00028\u00021\t\u0001Y\u0001\rG>l\u0007/\u0019:f)>|e.\u001a\u0005\b\u0003w\u0003A\u0011AA_\u0003\ri\u0017N\u001c\u000b\u0004=\u0005}\u0006BB6\u0002:\u0002\u0007a\u0004C\u0004\u0002D\u0002!\t!!2\u0002\u00075\f\u0007\u0010F\u0002\u001f\u0003\u000fDaa[Aa\u0001\u0004q\u0002BBAf\u0001\u0011\u0005\u0011,\u0001\u0006mS6LG\u000fV8J]RDa!a4\u0001\t\u0003I\u0016a\u00037j[&$Hk\u001c'p]\u001eDq!a5\u0001\t\u0003\t).A\u0004mS6LG\u000fV8\u0015\u0007y\t9\u000eC\u0004\u0002D\u0006E\u0007\u0019\u0001\u0014\t\u000f\u0005m\u0007\u0001\"\u0001\u0002^\u0006\u0011B.[7ji\u0012+gn\\7j]\u0006$xN\u001d+p)\rq\u0012q\u001c\u0005\b\u0003C\fI\u000e1\u0001'\u0003\u0015a\u0017.\\5u\u0011\u001d\t)\u000f\u0001C!\u0003O\fa!Z9vC2\u001cHcA\u001c\u0002j\"A\u00111^Ar\u0001\u0004\ti/\u0001\u0003uQ\u0006$\bcA\u0018\u0002p&\u0019\u0011\u0011_\u0006\u0003\u0007\u0005s\u00170K\u0003\u0001\u0003k\u0014YNB\u0004\u0002x\u0006ehaa%\u0003\u0017\tKwMU1uS>t\u0017\r\u001c\u0004\u0007\u0003\tA\t!a?\u0014\u0011\u0005e\u0018Q B\u0002\u0005\u0013\u00012aLA\u0000\u0013\r\u0011\ta\u0003\u0002\u0007\u0003:L(+\u001a4\u0011\u0007}\u0011)!C\u0002\u0003\b\t\u0011\u0011CU1uS>t\u0017\r\\%ogR\fgnY3t!\ry#1B\u0005\u0004\u0005\u001bY!\u0001D*fe&\fG.\u001b>bE2,\u0007bB\u0011\u0002z\u0012\u0005!\u0011\u0003\u000b\u0003\u0005'\u00012aHA}\u0011)\u00119\"!?C\u0002\u0013%!\u0011D\u0001\u000f%\u0006$\u0018n\u001c8bYN#(/\u001b8h+\t\u0011Y\u0002\u0005\u0003\u0003\u001e\t\u001dRB\u0001B\u0010\u0015\u0011\u0011\tCa\t\u0002\u00115\fGo\u00195j]\u001eT1A!\n\f\u0003\u0011)H/\u001b7\n\t\t%\"q\u0004\u0002\u0006%\u0016<W\r\u001f\u0005\n\u0005[\tI\u0010)A\u0005\u00057\tqBU1uS>t\u0017\r\\*ue&tw\r\t\u0005\u000b\u0005c\tIP1A\u0005\n\te\u0011!D%oi\u0016<WM]*ue&tw\rC\u0005\u00036\u0005e\b\u0015!\u0003\u0003\u001c\u0005q\u0011J\u001c;fO\u0016\u00148\u000b\u001e:j]\u001e\u0004\u0003\"\u0003B\u001d\u0003s\u0014\r\u0011\"\u0001Z\u0003\u0011QXM]8\t\u0011\tu\u0012\u0011 Q\u0001\ny\tQA_3s_\u0002B\u0011B!\u0011\u0002z\n\u0007I\u0011A-\u0002\u0007=tW\r\u0003\u0005\u0003F\u0005e\b\u0015!\u0003\u001f\u0003\u0011yg.\u001a\u0011\t\u0013\t%\u0013\u0011 C\u0001\u0005\t-\u0013\u0001\u0003;p\t>,(\r\\3\u0015\r\t5#1\u000bB,!\ry#qJ\u0005\u0004\u0005#Z!A\u0002#pk\ndW\rC\u0004\u0003V\t\u001d\u0003\u0019\u0001\u0014\u0002\u00039DqA!\u0017\u0003H\u0001\u0007a%A\u0001e\u0011!\u0011i&!?\u0005\u0002\t}\u0013!B1qa2LH#\u0002\u0010\u0003b\t\r\u0004\u0002\u0003B+\u00057\u0002\r!!\u001a\t\u0011\te#1\fa\u0001\u0003KB\u0001B!\u0018\u0002z\u0012\u0005!q\r\u000b\u0006=\t%$1\u000e\u0005\b\u0005+\u0012)\u00071\u0001/\u0011\u001d\u0011IF!\u001aA\u00029B\u0011Ba\u001c\u0002z\u0012\u0005!A!\u001d\u0002\u0019\t,\u0018\u000e\u001c3XSRDG)\u001b<\u0015\u0013y\u0011\u0019Ha\u001e\u0003|\t}\u0004b\u0002B;\u0005[\u0002\rAL\u0001\u0004]Vl\u0007b\u0002B=\u0005[\u0002\rAL\u0001\u0005]\u001e\u001cG\rC\u0004\u0003~\t5\u0004\u0019\u0001\u0018\u0002\u0005I$\u0007b\u0002BA\u0005[\u0002\rAL\u0001\u0005Y\u0012,g\u000e\u0003\u0005\u0003^\u0005eH\u0011\u0001BC)\u0015q\"q\u0011BE\u0011\u001d\u0011)Fa!A\u0002\u0019BqA!\u0017\u0003\u0004\u0002\u0007a\u0005\u0003\u0005\u0003^\u0005eH1\u0001BG)\rq\"q\u0012\u0005\b\u0005#\u0013Y\t1\u0001D\u0003\u0005A\b\u0002\u0003B/\u0003s$\u0019A!&\u0015\u0007y\u00119\nC\u0004\u0003\u0012\nM\u0005\u0019\u0001\u0018\t\u0011\tu\u0013\u0011 C\u0002\u00057#2A\bBO\u0011!\u0011\tJ!'A\u0002\u0005\u0015\u0004\u0002\u0003B/\u0003s$\u0019A!)\u0015\u0007y\u0011\u0019\u000bC\u0004\u0003\u0012\n}\u0005\u0019A%\t\u0011\tu\u0013\u0011 C\u0002\u0005O#2A\bBU\u0011!\u0011\tJ!*A\u0002\t5\u0003\u0002\u0003B/\u0003s$\u0019A!,\u0015\u0007y\u0011y\u000b\u0003\u0005\u0003\u0012\n-\u0006\u0019AA\u001b\u0011!\u0011i&!?\u0005\u0002\tMFc\u0001\u0010\u00036\"A!q\u0017BY\u0001\u0004\u0011I,A\u0001s!\u0011\u0011YLa1\u000f\t\tu&q\u0018\t\u0003+-I1A!1\f\u0003\u0019\u0001&/\u001a3fM&!!Q\u0019Bd\u0005\u0019\u0019FO]5oO*\u0019!\u0011Y\u0006\t\u0011\tu\u0013\u0011 C\u0002\u0005\u0017$2A\bBg\u0011\u001d\u0011)F!3A\u0002\u0019B\u0001B!\u0018\u0002z\u0012\r!\u0011\u001b\u000b\u0004=\tM\u0007\u0002\u0003BI\u0005\u001f\u0004\rA!6\u0011\u0007}\u00119.C\u0002\u0003Z\n\u0011aAT;nE\u0016\u0014ha\u0002Bo\u0003s4!q\u001c\u0002\r\u0019>twMU1uS>t\u0017\r\\\n\u0006\u00057t\"\u0011\u0002\u0005\u000b\u0005+\u0012YN!b\u0001\n\u0003i\u0003B\u0003Bs\u00057\u0014\t\u0011)A\u0005]\u0005\u0011a\u000e\t\u0005\u000b\u00053\u0012YN!b\u0001\n\u0003i\u0003B\u0003Bv\u00057\u0014\t\u0011)A\u0005]\u0005\u0011A\r\t\u0005\bC\tmG\u0011\u0001Bx)\u0019\u0011\tP!>\u0003xB!!1\u001fBn\u001b\t\tI\u0010C\u0004\u0003V\t5\b\u0019\u0001\u0018\t\u000f\te#Q\u001ea\u0001]!1AEa7\u0005\u0002\u0015BaA\u000bBn\t\u0003)\u0003B\u0002\u0017\u0003\\\u0012\u0005Q\u0006\u0003\u00044\u00057$\t!\f\u0005\u0007;\nmG\u0011A-\t\r}\u0013Y\u000e\"\u0011a\u0011\u0019Y$1\u001cC!y!1!Ma7\u0005BYBa\u0001\u001aBn\t\u00032\u0004bBB\u0007\u00057$\tEN\u0001\fSN4\u0016\r\\5e\u0007\"\f'\u000fC\u0004\u0004\u0012\tmG\u0011\t\u001c\u0002\u0017%\u001ch+\u00197jI\nKH/\u001a\u0005\b\u0007+\u0011Y\u000e\"\u00117\u00031I7OV1mS\u0012\u001c\u0006n\u001c:u\u0011\u001d\u0019IBa7\u0005BY\n!\"[:WC2LG-\u00138u\u0011\u0019)$1\u001cC!m!9\u0011Q\fBn\t\u0003*\u0003\u0002CB\u0011\u00057$\tea\t\u0002\u0017\u0011|WO\u00197f-\u0006dW/\u001a\u000b\u0003\u0005\u001bBaA\u001aBn\t\u0003\u0012\u0003b\u00025\u0003\\\u0012\u00051\u0011\u0006\u000b\u0004=\r-\u0002b\u0002B\\\u0007O\u0001\rA\b\u0005\b[\nmG\u0011AB\u0018)\rq2\u0011\u0007\u0005\b\u0005o\u001bi\u00031\u0001\u001f\u0011\u001d\t(1\u001cC\u0001\u0007k!2AHB\u001c\u0011\u001d\u00119la\rA\u0002yAq!\u001eBn\t\u0003\u0019Y\u0004F\u0002\u001f\u0007{AqAa.\u0004:\u0001\u0007a\u0004\u0003\u0005\u0002\u0012\tmG\u0011AB!)\rq21\t\u0005\b\u0005o\u001by\u00041\u0001\u001f\u0011\u001d\t)Ia7\u0005\u0002eCq!!#\u0003\\\u0012\u0005\u0011\fC\u0004\u0002\u000e\nmG\u0011A-\t\u0011\u0005m%1\u001cC\u0001\u0007\u001b\"2AHB(\u0011\u001d\t\tka\u0013A\u0002\rCq!a.\u0003\\\u0012\u0005\u0001\r\u0003\u0005\u0004V\tmG\u0011AB,\u0003\u001d\u0019w.\u001c9be\u0016$2aQB-\u0011\u001d\u00119la\u0015A\u0002yAaA\u0010Bn\t\u0003z\u0004\u0002CAs\u00057$\tea\u0018\u0015\u0007]\u001a\t\u0007\u0003\u0005\u0002l\u000eu\u0003\u0019AAw\u0011\u001d\u0019)Ga7\u0005B\t\u000b\u0001\u0002[1tQ\u000e{G-\u001a\u0005\t\u0007S\u0012Y\u000e\"\u0011\u0004l\u0005AAo\\*ue&tw\r\u0006\u0002\u0003:\"B!1\\B8\u0007k\u001a9\bE\u00020\u0007cJ1aa\u001d\f\u0005A\u0019VM]5bYZ+'o]5p]VKE)A\u0003wC2,XMH\u0001\u0001\u0011!\u0019Y(!?\u0005\n\ru\u0014\u0001\u00047p]\u001e\u0014\u0016\r^5p]\u0006dGC\u0002By\u0007\u007f\u001a\t\tC\u0004\u0003V\re\u0004\u0019\u0001\u0018\t\u000f\te3\u0011\u0010a\u0001]!A1QQA}\t\u0013\u00199)A\u0006cS\u001e\u0014\u0016\r^5p]\u0006dGCBBE\u0007\u0017\u001bi\t\u0005\u0003\u0003t\u0006U\bb\u0002B+\u0007\u0007\u0003\rA\n\u0005\b\u00053\u001a\u0019\t1\u0001'\u0011%\u0019\t*!?\u0002\u0002\u0013%a*A\u0006sK\u0006$'+Z:pYZ,7#BA{=\t%\u0001B\u0003B+\u0003k\u0014)\u0019!C\u0001K!Q!Q]A{\u0005\u0003\u0005\u000b\u0011\u0002\u0014\t\u0015\te\u0013Q\u001fBC\u0002\u0013\u0005Q\u0005\u0003\u0006\u0003l\u0006U(\u0011!Q\u0001\n\u0019Bq!IA{\t\u0003\u0019y\n\u0006\u0004\u0004\n\u000e\u000561\u0015\u0005\b\u0005+\u001ai\n1\u0001'\u0011\u001d\u0011If!(A\u0002\u0019Ba\u0001JA{\t\u0003)\u0003B\u0002\u0016\u0002v\u0012\u0005Q\u0005\u0003\u0004-\u0003k$\t!\f\u0005\u0007g\u0005UH\u0011A\u0017\t\ru\u000b)\u0010\"\u0001Z\u0011\u0019y\u0016Q\u001fC!A\"11(!>\u0005BqBaAYA{\t\u00032\u0004B\u00023\u0002v\u0012\u0005c\u0007C\u0004\u0004\u000e\u0005UH\u0011\t\u001c\t\u000f\rE\u0011Q\u001fC!m!91QCA{\t\u00032\u0004bBB\r\u0003k$\tE\u000e\u0005\u0007k\u0005UH\u0011\t\u001c\t\u000f\u0005u\u0013Q\u001fC!K!A1\u0011EA{\t\u0003\u001a\u0019\u0003\u0003\u0004g\u0003k$\tE\t\u0005\bQ\u0006UH\u0011ABe)\rq21\u001a\u0005\b\u0005o\u001b9\r1\u0001\u001f\u0011\u001di\u0017Q\u001fC\u0001\u0007\u001f$2AHBi\u0011\u001d\u00119l!4A\u0002yAq!]A{\t\u0003\u0019)\u000eF\u0002\u001f\u0007/DqAa.\u0004T\u0002\u0007a\u0004C\u0004v\u0003k$\taa7\u0015\u0007y\u0019i\u000eC\u0004\u00038\u000ee\u0007\u0019\u0001\u0010\t\u0011\u0005E\u0011Q\u001fC\u0001\u0007C$2AHBr\u0011\u001d\u00119la8A\u0002yAq!!\"\u0002v\u0012\u0005\u0011\fC\u0004\u0002\n\u0006UH\u0011A-\t\u000f\u00055\u0015Q\u001fC\u00013\"A\u00111TA{\t\u0003\u0019i\u000fF\u0002\u001f\u0007_Dq!!)\u0004l\u0002\u00071\tC\u0004\u00028\u0006UH\u0011\u00011\t\u0011\rU\u0013Q\u001fC\u0001\u0007k$2aQB|\u0011\u001d\u00119la=A\u0002yA\u0001\"!:\u0002v\u0012\u000531 \u000b\u0004o\ru\b\u0002CAv\u0007s\u0004\r!!<\t\u000f\r\u0015\u0014Q\u001fC!\u0005\"A1\u0011NA{\t\u0003\u001aY\u0007\u000b\u0005\u0002v\u000e=4QOB<\u000f\u001d!9A\u0001E\u0001\u0005'\t\u0001BU1uS>t\u0017\r\u001c")
public abstract class Rational
extends ScalaNumber
implements ScalaNumericConversions,
Ordered<Rational> {
    public static NumberTag.LargeTag<Rational> RationalTag() {
        return Rational$.MODULE$.RationalTag();
    }

    public static RationalAlgebra RationalAlgebra() {
        return Rational$.MODULE$.RationalAlgebra();
    }

    public static Rational apply(Number number) {
        return Rational$.MODULE$.apply(number);
    }

    public static Rational apply(SafeLong safeLong) {
        return Rational$.MODULE$.apply(safeLong);
    }

    public static Rational apply(String string) {
        return Rational$.MODULE$.apply(string);
    }

    public static Rational apply(BigDecimal bigDecimal) {
        return Rational$.MODULE$.apply(bigDecimal);
    }

    public static Rational apply(double d) {
        return Rational$.MODULE$.apply(d);
    }

    public static Rational apply(float f) {
        return Rational$.MODULE$.apply(f);
    }

    public static Rational apply(BigInt bigInt) {
        return Rational$.MODULE$.apply(bigInt);
    }

    public static Rational apply(long l) {
        return Rational$.MODULE$.apply(l);
    }

    public static Rational apply(int n) {
        return Rational$.MODULE$.apply(n);
    }

    public static Rational apply(SafeLong safeLong, SafeLong safeLong2) {
        return Rational$.MODULE$.apply(safeLong, safeLong2);
    }

    public static Rational apply(long l, long l2) {
        return Rational$.MODULE$.apply(l, l2);
    }

    public static Rational apply(BigInt bigInt, BigInt bigInt2) {
        return Rational$.MODULE$.apply(bigInt, bigInt2);
    }

    public static Rational one() {
        return Rational$.MODULE$.one();
    }

    public static Rational zero() {
        return Rational$.MODULE$.zero();
    }

    public boolean $less(Object that) {
        boolean bl = this.compare(that) < 0;
        return bl;
    }

    public boolean $greater(Object that) {
        boolean bl = this.compare(that) > 0;
        return bl;
    }

    public boolean $less$eq(Object that) {
        boolean bl = this.compare(that) <= 0;
        return bl;
    }

    public boolean $greater$eq(Object that) {
        boolean bl = this.compare(that) >= 0;
        return bl;
    }

    public int compareTo(Object that) {
        return this.compare(that);
    }

    public char toChar() {
        return ScalaNumericAnyConversions.toChar$((ScalaNumericAnyConversions)this);
    }

    public byte toByte() {
        return ScalaNumericAnyConversions.toByte$((ScalaNumericAnyConversions)this);
    }

    public short toShort() {
        return ScalaNumericAnyConversions.toShort$((ScalaNumericAnyConversions)this);
    }

    public int toInt() {
        return ScalaNumericAnyConversions.toInt$((ScalaNumericAnyConversions)this);
    }

    public long toLong() {
        return ScalaNumericAnyConversions.toLong$((ScalaNumericAnyConversions)this);
    }

    public float toFloat() {
        return ScalaNumericAnyConversions.toFloat$((ScalaNumericAnyConversions)this);
    }

    public double toDouble() {
        return ScalaNumericAnyConversions.toDouble$((ScalaNumericAnyConversions)this);
    }

    public boolean isValidByte() {
        return ScalaNumericAnyConversions.isValidByte$((ScalaNumericAnyConversions)this);
    }

    public boolean isValidShort() {
        return ScalaNumericAnyConversions.isValidShort$((ScalaNumericAnyConversions)this);
    }

    public boolean isValidInt() {
        return ScalaNumericAnyConversions.isValidInt$((ScalaNumericAnyConversions)this);
    }

    public boolean isValidChar() {
        return ScalaNumericAnyConversions.isValidChar$((ScalaNumericAnyConversions)this);
    }

    public int unifiedPrimitiveHashcode() {
        return ScalaNumericAnyConversions.unifiedPrimitiveHashcode$((ScalaNumericAnyConversions)this);
    }

    public boolean unifiedPrimitiveEquals(Object x) {
        return ScalaNumericAnyConversions.unifiedPrimitiveEquals$((ScalaNumericAnyConversions)this, (Object)x);
    }

    public abstract SafeLong numerator();

    public abstract SafeLong denominator();

    public abstract long numeratorAsLong();

    public abstract long denominatorAsLong();

    public abstract boolean isValidLong();

    public abstract boolean isWhole();

    public long longValue() {
        return this.toBigInt().longValue();
    }

    public int intValue() {
        return Predef$.MODULE$.long2Long(this.longValue()).intValue();
    }

    public float floatValue() {
        return (float)this.doubleValue();
    }

    public Object underlying() {
        return this;
    }

    public Rational abs() {
        if (this.signum() < 0) {
            return this.unary_$minus();
        }
        return this;
    }

    public Rational inverse() {
        return this.reciprocal();
    }

    public abstract Rational reciprocal();

    public abstract int signum();

    public abstract boolean isZero();

    public abstract boolean isOne();

    public abstract Rational unary_$minus();

    public abstract Rational $plus(Rational var1);

    public abstract Rational $minus(Rational var1);

    public abstract Rational $times(Rational var1);

    public abstract Rational $div(Rational var1);

    public Rational $div$tilde(Rational rhs) {
        return Rational$.MODULE$.apply(SafeLong$.MODULE$.apply(this.$div(rhs).toBigInt()), SafeLong$.MODULE$.one());
    }

    public Rational $percent(Rational rhs) {
        return this.$minus(this.$div$tilde(rhs).$times(rhs));
    }

    public Tuple2<Rational, Rational> $div$percent(Rational rhs) {
        Rational q = this.$div$tilde(rhs);
        return new Tuple2((Object)q, (Object)this.$minus(q.$times(rhs)));
    }

    public abstract Rational gcd(Rational var1);

    public Real toReal() {
        return Real$.MODULE$.apply(this);
    }

    public Algebraic toAlgebraic() {
        return Algebraic$.MODULE$.apply(this);
    }

    public BigDecimal toBigDecimal(int scale, RoundingMode mode) {
        java.math.BigDecimal n = new java.math.BigDecimal(this.numerator().toBigInteger());
        java.math.BigDecimal d = new java.math.BigDecimal(this.denominator().toBigInteger());
        return scala.package$.MODULE$.BigDecimal().apply(n.divide(d, scale, mode));
    }

    public BigDecimal toBigDecimal(MathContext mc) {
        java.math.BigDecimal n = new java.math.BigDecimal(this.numerator().toBigInteger());
        java.math.BigDecimal d = new java.math.BigDecimal(this.denominator().toBigInteger());
        return scala.package$.MODULE$.BigDecimal().apply(n.divide(d, mc));
    }

    public abstract SafeLong toSafeLong();

    public final BigInt toBigInt() {
        return this.toSafeLong().toBigInt();
    }

    public short shortValue() {
        return (short)this.longValue();
    }

    public byte byteValue() {
        return (byte)this.longValue();
    }

    public abstract Rational floor();

    public abstract Rational ceil();

    public abstract Rational round();

    public Rational roundTo(SafeLong denom) {
        return this.$times(Rational$.MODULE$.apply(denom)).round().$div(Rational$.MODULE$.apply(denom));
    }

    public abstract Rational pow(int var1);

    public Sign sign() {
        return Sign$.MODULE$.apply(this.signum());
    }

    public abstract int compareToOne();

    public Rational min(Rational rhs) {
        if (this.compare((Object)rhs) < 0) {
            return this;
        }
        return rhs;
    }

    public Rational max(Rational rhs) {
        if (this.compare((Object)rhs) > 0) {
            return this;
        }
        return rhs;
    }

    public Rational limitToInt() {
        return this.limitTo(SafeLong$.MODULE$.apply(scala.package$.MODULE$.BigInt().apply(Integer.MAX_VALUE)));
    }

    public Rational limitToLong() {
        return this.limitTo(SafeLong$.MODULE$.apply(scala.package$.MODULE$.BigInt().apply(Long.MAX_VALUE)));
    }

    /*
     * WARNING - void declaration
     */
    public Rational limitTo(SafeLong max) {
        void require_requirement;
        boolean bl;
        if (this.signum() < 0) {
            return this.unary_$minus().limitTo(max).unary_$minus();
        }
        boolean bl2 = bl = max.signum() > 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        if (require_requirement == false) {
            throw new IllegalArgumentException("requirement failed: " + Rational.$anonfun$limitTo$1());
        }
        max.$greater$greater(1);
        SafeLong floor = SafeLong$.MODULE$.apply(this.toBigInt());
        if (floor.$greater$eq((Object)max)) {
            return Rational$.MODULE$.apply(max);
        }
        if (floor.$greater$eq((Object)max.$greater$greater(1))) {
            return Rational$.MODULE$.apply(floor.toLong());
        }
        if (this.compareToOne() < 0) {
            return this.limitDenominatorTo(max);
        }
        return this.limitDenominatorTo(max.$times(this.denominator()).$div(this.numerator()));
    }

    /*
     * WARNING - void declaration
     */
    public Rational limitDenominatorTo(SafeLong limit) {
        Rational rational;
        void require_requirement;
        boolean bl;
        boolean bl2 = bl = limit.signum() > 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        if (require_requirement == false) {
            throw new IllegalArgumentException("requirement failed: " + Rational.$anonfun$limitDenominatorTo$1());
        }
        Sign sign = this.sign();
        if (Sign$Zero$.MODULE$.equals(sign)) {
            rational = this;
        } else if (Sign$Positive$.MODULE$.equals(sign)) {
            rational = this.closest$1(Rational$.MODULE$.apply(this.toBigInt()), new LongRational(1L, 0L), (SafeLong)((Object)Opt$.MODULE$.empty()), (SafeLong)((Object)Opt$.MODULE$.empty()), limit);
        } else if (Sign$Negative$.MODULE$.equals(sign)) {
            rational = this.closest$1(new LongRational(-1L, 0L), Rational$.MODULE$.apply(this.toBigInt()), (SafeLong)((Object)Opt$.MODULE$.empty()), (SafeLong)((Object)Opt$.MODULE$.empty()), limit);
        } else {
            throw new MatchError((Object)sign);
        }
        return rational;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object that) {
        if (that instanceof Real) {
            Real real = (Real)that;
            if (!BoxesRunTime.equalsNumNum((java.lang.Number)((Object)this), (java.lang.Number)((Object)real.toRational()))) return false;
            return true;
        }
        if (that instanceof Algebraic) {
            if (!BoxesRunTime.equalsNumNum((java.lang.Number)((Object)((Algebraic)((Object)that))), (java.lang.Number)((Object)this))) return false;
            return true;
        }
        if (that instanceof BigInt) {
            BigInt bigInt = (BigInt)that;
            if (!this.isWhole()) return false;
            BigInt bigInt2 = this.toBigInt();
            if (bigInt2 != null) {
                if (!bigInt2.equals(bigInt)) return false;
                return true;
            }
            if (bigInt == null) return true;
            return false;
        }
        if (that instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)that;
            try {
                BigDecimal bigDecimal2 = this.toBigDecimal(bigDecimal.mc());
                if (bigDecimal2 == null) return false;
                if (!bigDecimal2.equals(bigDecimal)) return false;
                return true;
            }
            catch (ArithmeticException arithmeticException) {
                return false;
            }
        }
        if (that instanceof SafeLong) {
            SafeLong safeLong = (SafeLong)((Object)that);
            if (!BoxesRunTime.equalsNumNum((java.lang.Number)((Object)SafeLong$.MODULE$.apply(this.toBigInt())), (java.lang.Number)((Object)safeLong))) return false;
            return true;
        }
        if (that instanceof Number) {
            Number number = (Number)that;
            Number number2 = Number$.MODULE$.apply(this);
            if (number2 != null) {
                if (!number2.equals(number)) return false;
                return true;
            }
            if (number == null) return true;
            return false;
        }
        if (that instanceof Natural) {
            Natural natural = (Natural)((Object)that);
            if (!this.isWhole()) return false;
            if (!BoxesRunTime.equalsNumNum((java.lang.Number)((Object)this), (java.lang.Number)((Object)Rational$.MODULE$.apply(natural.toBigInt())))) return false;
            return true;
        }
        if (that instanceof Complex) {
            if (!BoxesRunTime.equalsNumNum((java.lang.Number)((Object)((Complex)((Object)that))), (java.lang.Number)((Object)this))) return false;
            return true;
        }
        if (that instanceof Quaternion) {
            if (!BoxesRunTime.equalsNumNum((java.lang.Number)((Object)((Quaternion)((Object)that))), (java.lang.Number)((Object)this))) return false;
            return true;
        }
        if (!(that instanceof Long)) return this.unifiedPrimitiveEquals(that);
        long l = BoxesRunTime.unboxToLong((Object)that);
        if (!this.isValidLong()) return false;
        if (this.toLong() != l) return false;
        return true;
    }

    public static final /* synthetic */ String $anonfun$limitTo$1() {
        return "Limit must be a positive integer.";
    }

    public static final /* synthetic */ String $anonfun$limitDenominatorTo$1() {
        return "Cannot limit denominator to non-positive number.";
    }

    private static final SafeLong nextK$1(SafeLong curr) {
        if (Opt$.MODULE$.isEmpty$extension(curr)) {
            return Opt$.MODULE$.apply(SafeLong$.MODULE$.apply(2L));
        }
        return Opt$.MODULE$.apply(Opt$.MODULE$.get$extension(curr).$times(2L));
    }

    private final Rational closest$1(Rational l, Rational u, SafeLong lk, SafeLong rk, SafeLong limit$1) {
        while (true) {
            boolean bl = Opt$.MODULE$.nonEmpty$extension(rk);
            boolean bl2 = Opt$.MODULE$.nonEmpty$extension(lk);
            Rational rational = true == bl2 && false == bl ? Rational$.MODULE$.apply(Opt$.MODULE$.get$extension(lk).$times(l.numerator()).$plus(u.numerator()), Opt$.MODULE$.get$extension(lk).$times(l.denominator()).$plus(u.denominator())) : (false == bl2 && true == bl ? Rational$.MODULE$.apply(l.numerator().$plus(Opt$.MODULE$.get$extension(rk).$times(u.numerator())), l.denominator().$plus(Opt$.MODULE$.get$extension(rk).$times(u.denominator()))) : Rational$.MODULE$.apply(l.numerator().$plus(u.numerator()), l.denominator().$plus(u.denominator())));
            if (rational.denominator().$greater((Object)limit$1)) {
                if (Opt$.MODULE$.nonEmpty$extension(lk) || Opt$.MODULE$.nonEmpty$extension(rk)) {
                    rk = (SafeLong)((Object)Opt$.MODULE$.empty());
                    lk = (SafeLong)((Object)Opt$.MODULE$.empty());
                    continue;
                }
                if (this.$minus(l).abs().$greater((Object)u.$minus(this).abs())) {
                    return u;
                }
                return l;
            }
            if (BoxesRunTime.equalsNumNum((java.lang.Number)((Object)rational), (java.lang.Number)((Object)this))) {
                return rational;
            }
            if (rational.$less((Object)this)) {
                rk = Rational.nextK$1(rk);
                lk = (SafeLong)((Object)Opt$.MODULE$.empty());
                l = rational;
                continue;
            }
            rk = (SafeLong)((Object)Opt$.MODULE$.empty());
            lk = Rational.nextK$1(lk);
            u = rational;
        }
    }

    public Rational() {
        ScalaNumericAnyConversions.$init$((ScalaNumericAnyConversions)this);
    }

    public static final class BigRational
    extends Rational
    implements Serializable {
        public static final long serialVersionUID = 0L;
        private final SafeLong n;
        private final SafeLong d;

        public SafeLong n() {
            return this.n;
        }

        public SafeLong d() {
            return this.d;
        }

        @Override
        public SafeLong numerator() {
            return this.n();
        }

        @Override
        public SafeLong denominator() {
            return this.d();
        }

        @Override
        public long numeratorAsLong() {
            return this.n().toLong();
        }

        @Override
        public long denominatorAsLong() {
            return this.d().toLong();
        }

        @Override
        public Rational reciprocal() {
            if (this.signum() < 0) {
                return Rational$.MODULE$.apply(this.d().unary_$minus(), this.n().unary_$minus());
            }
            return Rational$.MODULE$.spire$math$Rational$$bigRational(this.d(), this.n());
        }

        @Override
        public int signum() {
            return this.n().signum();
        }

        @Override
        public boolean isWhole() {
            return this.d().isOne();
        }

        @Override
        public boolean isZero() {
            return false;
        }

        @Override
        public boolean isOne() {
            return false;
        }

        @Override
        public boolean isValidChar() {
            return false;
        }

        @Override
        public boolean isValidByte() {
            return false;
        }

        @Override
        public boolean isValidShort() {
            return false;
        }

        @Override
        public boolean isValidInt() {
            return false;
        }

        @Override
        public boolean isValidLong() {
            return false;
        }

        @Override
        public SafeLong toSafeLong() {
            return this.n().$div(this.d());
        }

        public double doubleValue() {
            return Rational$.MODULE$.toDouble(this.n(), this.d());
        }

        @Override
        public Rational unary_$minus() {
            return Rational$.MODULE$.apply(this.n().unary_$minus(), this.d());
        }

        @Override
        public Rational $plus(Rational r) {
            Rational rational;
            if (r instanceof LongRational) {
                rational = ((LongRational)r).$plus(this);
            } else if (r instanceof BigRational) {
                Rational rational2;
                BigRational bigRational = (BigRational)r;
                SafeLong dgcd = this.d().gcd(bigRational.d());
                if (dgcd.isOne()) {
                    rational2 = Rational$.MODULE$.apply(bigRational.d().$times(this.n()).$plus(bigRational.n().$times(this.d())), bigRational.d().$times(this.d()));
                } else {
                    SafeLong lden = this.d().$div(dgcd);
                    SafeLong num = bigRational.d().$div(dgcd).$times(this.n()).$plus(bigRational.n().$times(lden));
                    SafeLong ngcd = num.gcd(dgcd);
                    rational2 = ngcd.isOne() ? Rational$.MODULE$.apply(num, lden.$times(bigRational.d())) : Rational$.MODULE$.apply(num.$div(ngcd), bigRational.d().$div(ngcd).$times(lden));
                }
                rational = rational2;
            } else {
                throw new MatchError((Object)r);
            }
            return rational;
        }

        @Override
        public Rational $minus(Rational r) {
            Rational rational;
            if (r instanceof LongRational) {
                rational = ((LongRational)r).unary_$minus().$plus(this);
            } else if (r instanceof BigRational) {
                Rational rational2;
                BigRational bigRational = (BigRational)r;
                SafeLong dgcd = this.d().gcd(bigRational.d());
                if (dgcd.isOne()) {
                    rational2 = Rational$.MODULE$.apply(bigRational.d().$times(this.n()).$minus(bigRational.n().$times(this.d())), bigRational.d().$times(this.d()));
                } else {
                    SafeLong lden = this.d().$div(dgcd);
                    SafeLong num = bigRational.d().$div(dgcd).$times(this.n()).$minus(bigRational.n().$times(lden));
                    SafeLong ngcd = num.gcd(dgcd);
                    rational2 = ngcd.isOne() ? Rational$.MODULE$.apply(num, lden.$times(bigRational.d())) : Rational$.MODULE$.apply(num.$div(ngcd), bigRational.d().$div(ngcd).$times(lden));
                }
                rational = rational2;
            } else {
                throw new MatchError((Object)r);
            }
            return rational;
        }

        @Override
        public Rational $times(Rational r) {
            Rational rational;
            if (r instanceof LongRational) {
                rational = ((LongRational)r).$times(this);
            } else if (r instanceof BigRational) {
                BigRational bigRational = (BigRational)r;
                SafeLong a = this.n().gcd(bigRational.d());
                SafeLong b = this.d().gcd(bigRational.n());
                rational = Rational$.MODULE$.apply(this.n().$div(a).$times(bigRational.n().$div(b)), this.d().$div(b).$times(bigRational.d().$div(a)));
            } else {
                throw new MatchError((Object)r);
            }
            return rational;
        }

        @Override
        public Rational $div(Rational r) {
            Rational rational;
            if (r instanceof LongRational) {
                rational = ((LongRational)r).inverse().$times(this);
            } else if (r instanceof BigRational) {
                BigRational bigRational = (BigRational)r;
                SafeLong a = this.n().gcd(bigRational.n());
                SafeLong b = this.d().gcd(bigRational.d());
                SafeLong num = this.n().$div(a).$times(bigRational.d().$div(b));
                SafeLong den = this.d().$div(b).$times(bigRational.n().$div(a));
                rational = den.signum() < 0 ? Rational$.MODULE$.apply(num.unary_$minus(), den.unary_$minus()) : Rational$.MODULE$.apply(num, den);
            } else {
                throw new MatchError((Object)r);
            }
            return rational;
        }

        @Override
        public Rational gcd(Rational r) {
            Rational rational;
            if (r instanceof LongRational) {
                rational = ((LongRational)r).gcd(this);
            } else if (r instanceof BigRational) {
                Rational rational2;
                BigRational bigRational = (BigRational)r;
                SafeLong dgcd = this.d().gcd(bigRational.d());
                if (dgcd.isOne()) {
                    rational2 = Rational$.MODULE$.apply(this.n().abs().gcd(bigRational.n().abs()), this.d().$times(bigRational.d()));
                } else {
                    SafeLong lm = this.d().$div(dgcd);
                    SafeLong rm = bigRational.d().$div(dgcd);
                    rational2 = Rational$.MODULE$.apply(this.n().$times(rm).abs().gcd(bigRational.n().$times(lm).abs()), dgcd.$times(lm).$times(rm));
                }
                rational = rational2;
            } else {
                throw new MatchError((Object)r);
            }
            return rational;
        }

        @Override
        public Rational floor() {
            if (this.isWhole()) {
                return this;
            }
            if (this.n().signum() >= 0) {
                return Rational$.MODULE$.apply(this.n().$div(this.d()), SafeLong$.MODULE$.one());
            }
            return Rational$.MODULE$.apply(this.n().$div(this.d()).$minus(1L), SafeLong$.MODULE$.one());
        }

        @Override
        public Rational ceil() {
            if (this.isWhole()) {
                return this;
            }
            if (this.n().signum() >= 0) {
                return Rational$.MODULE$.apply(this.n().$div(this.d()).$plus(1L), SafeLong$.MODULE$.one());
            }
            return Rational$.MODULE$.apply(this.n().$div(this.d()), SafeLong$.MODULE$.one());
        }

        @Override
        public Rational round() {
            if (this.n().signum() >= 0) {
                SafeLong m = this.n().$percent(this.d());
                if (m.$greater$eq((Object)this.d().$minus(m))) {
                    return Rational$.MODULE$.apply(this.n().$div(this.d()).$plus(1L));
                }
                return Rational$.MODULE$.apply(this.n().$div(this.d()));
            }
            SafeLong m = this.n().$percent(this.d()).unary_$minus();
            if (m.$greater$eq((Object)this.d().$minus(m))) {
                return Rational$.MODULE$.apply(this.n().$div(this.d()).$minus(1L));
            }
            return Rational$.MODULE$.apply(this.n().$div(this.d()));
        }

        @Override
        public Rational pow(int exp) {
            if (exp == 0) {
                return Rational$.MODULE$.one();
            }
            if (exp < 0) {
                return Rational$.MODULE$.apply(this.d().pow(-exp), this.n().pow(-exp));
            }
            return Rational$.MODULE$.apply(this.n().pow(exp), this.d().pow(exp));
        }

        @Override
        public int compareToOne() {
            return this.n().compare((Object)this.d());
        }

        public int compare(Rational r) {
            int n;
            if (r instanceof LongRational) {
                LongRational longRational = (LongRational)r;
                long dgcd = package$.MODULE$.gcd(longRational.d(), this.d().$percent(longRational.d()).toLong());
                n = dgcd == 1L ? this.n().$times(longRational.d()).compare((Object)SafeLong$.MODULE$.apply(longRational.n()).$times(this.d())) : this.n().$times(longRational.d() / dgcd).compare((Object)SafeLong$.MODULE$.apply(longRational.n()).$times(this.d().$div(dgcd)));
            } else if (r instanceof BigRational) {
                BigRational bigRational = (BigRational)r;
                SafeLong dgcd = this.d().gcd(bigRational.d());
                n = dgcd.isOne() ? this.n().$times(bigRational.d()).compare((Object)bigRational.n().$times(this.d())) : bigRational.d().$div(dgcd).$times(this.n()).compare((Object)this.d().$div(dgcd).$times(bigRational.n()));
            } else {
                throw new MatchError((Object)r);
            }
            return n;
        }

        @Override
        public boolean equals(Object that) {
            boolean bl;
            if (that instanceof BigRational) {
                BigRational bigRational = (BigRational)((Object)that);
                bl = BoxesRunTime.equalsNumNum((java.lang.Number)((Object)this.n()), (java.lang.Number)((Object)bigRational.n())) && BoxesRunTime.equalsNumNum((java.lang.Number)((Object)this.d()), (java.lang.Number)((Object)bigRational.d()));
            } else {
                bl = super.equals(that);
            }
            return bl;
        }

        public int hashCode() {
            return 29 * (37 * Statics.anyHash((Object)((Object)this.n())) + Statics.anyHash((Object)((Object)this.d())));
        }

        public String toString() {
            if (this.isWhole()) {
                return this.n().toString();
            }
            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.n(), this.d()}));
        }

        public BigRational(SafeLong n, SafeLong d) {
            this.n = n;
            this.d = d;
        }
    }

    public static final class LongRational
    extends Rational
    implements Serializable {
        public static final long serialVersionUID = 0L;
        private final long n;
        private final long d;

        public long n() {
            return this.n;
        }

        public long d() {
            return this.d;
        }

        @Override
        public SafeLong numerator() {
            return SafeLong$.MODULE$.apply(this.n());
        }

        @Override
        public SafeLong denominator() {
            return SafeLong$.MODULE$.apply(this.d());
        }

        @Override
        public long numeratorAsLong() {
            return this.n();
        }

        @Override
        public long denominatorAsLong() {
            return this.d();
        }

        @Override
        public Rational reciprocal() {
            if (this.n() == 0L) {
                throw new ArithmeticException("reciprocal called on 0/1");
            }
            if (this.n() > 0L) {
                return Rational$.MODULE$.spire$math$Rational$$longRational(this.d(), this.n());
            }
            if (this.n() == Long.MIN_VALUE || this.d() == Long.MIN_VALUE) {
                return Rational$.MODULE$.spire$math$Rational$$bigRational(SafeLong$.MODULE$.apply(this.d()).unary_$minus(), SafeLong$.MODULE$.apply(this.n()).unary_$minus());
            }
            return Rational$.MODULE$.spire$math$Rational$$longRational(-this.d(), -this.n());
        }

        @Override
        public int signum() {
            return Long.signum(this.n());
        }

        @Override
        public boolean isWhole() {
            return this.d() == 1L;
        }

        @Override
        public boolean isZero() {
            return this.n() == 0L;
        }

        @Override
        public boolean isOne() {
            return this.d() == 1L && this.n() == 1L;
        }

        @Override
        public boolean isValidChar() {
            return this.isWhole() && RichLong$.MODULE$.isValidChar$extension(this.n());
        }

        @Override
        public boolean isValidByte() {
            return this.isWhole() && RichLong$.MODULE$.isValidByte$extension(this.n());
        }

        @Override
        public boolean isValidShort() {
            return this.isWhole() && RichLong$.MODULE$.isValidShort$extension(this.n());
        }

        @Override
        public boolean isValidInt() {
            return this.isWhole() && RichLong$.MODULE$.isValidInt$extension(this.n());
        }

        @Override
        public boolean isValidLong() {
            return this.isWhole();
        }

        @Override
        public SafeLong toSafeLong() {
            return SafeLong$.MODULE$.apply(this.n() / this.d());
        }

        public double doubleValue() {
            return Rational$.MODULE$.toDouble(SafeLong$.MODULE$.apply(this.n()), SafeLong$.MODULE$.apply(this.d()));
        }

        @Override
        public Rational unary_$minus() {
            if (this.n() == Long.MIN_VALUE) {
                return Rational$.MODULE$.spire$math$Rational$$bigRational(SafeLong$.MODULE$.safe64(), SafeLong$.MODULE$.apply(this.d()));
            }
            return Rational$.MODULE$.spire$math$Rational$$longRational(-this.n(), this.d());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Rational $plus(Rational r) {
            Rational rational;
            if (r instanceof LongRational) {
                Rational rational2;
                LongRational longRational = (LongRational)r;
                long dgcd = package$.MODULE$.gcd(this.d(), longRational.d());
                if (dgcd == 1L) {
                    void var18_9;
                    void var12_6;
                    long x$macro$435 = this.n();
                    long y$macro$436 = longRational.d();
                    long z$macro$434 = x$macro$435 * y$macro$436;
                    if (x$macro$435 != 0L && (y$macro$436 != z$macro$434 / x$macro$435 || x$macro$435 == -1L && y$macro$436 == Long.MIN_VALUE)) {
                        return this.checked$fallback$macro$430$1(longRational);
                    }
                    long x$macro$438 = longRational.n();
                    long y$macro$439 = this.d();
                    long z$macro$437 = x$macro$438 * y$macro$439;
                    if (x$macro$438 != 0L && (y$macro$439 != z$macro$437 / x$macro$438 || x$macro$438 == -1L && y$macro$439 == Long.MIN_VALUE)) {
                        return this.checked$fallback$macro$430$1(longRational);
                    }
                    void z$macro$431 = var12_6 + var18_9;
                    if (((var12_6 ^ var18_9 ^ 0xFFFFFFFFFFFFFFFFL) & (var12_6 ^ z$macro$431)) < 0L) {
                        return this.checked$fallback$macro$430$1(longRational);
                    }
                    long x$macro$441 = this.d();
                    long y$macro$442 = longRational.d();
                    long z$macro$440 = x$macro$441 * y$macro$442;
                    if (x$macro$441 != 0L && (y$macro$442 != z$macro$440 / x$macro$441 || x$macro$441 == -1L && y$macro$442 == Long.MIN_VALUE)) {
                        return this.checked$fallback$macro$430$1(longRational);
                    }
                    rational2 = Rational$.MODULE$.apply((long)z$macro$431, z$macro$440);
                } else {
                    void var40_20;
                    void var38_19;
                    void var34_17;
                    long lden = this.d() / dgcd;
                    long rden = longRational.d() / dgcd;
                    long x$macro$448 = this.n();
                    long z$macro$447 = x$macro$448 * rden;
                    if (x$macro$448 != 0L && (rden != z$macro$447 / x$macro$448 || x$macro$448 == -1L && rden == Long.MIN_VALUE)) {
                        return this.checked$fallback$macro$443$1(dgcd, lden, rden, longRational);
                    }
                    long x$macro$450 = longRational.n();
                    long z$macro$449 = x$macro$450 * lden;
                    if (x$macro$450 != 0L && (lden != z$macro$449 / x$macro$450 || x$macro$450 == -1L && lden == Long.MIN_VALUE)) {
                        return this.checked$fallback$macro$443$1(dgcd, lden, rden, longRational);
                    }
                    void z$macro$444 = var34_17 + var38_19;
                    if (((var34_17 ^ var38_19 ^ 0xFFFFFFFFFFFFFFFFL) & (var34_17 ^ z$macro$444)) < 0L) {
                        return this.checked$fallback$macro$443$1(dgcd, lden, rden, longRational);
                    }
                    long ngcd = package$.MODULE$.gcd((long)var40_20, dgcd);
                    if (ngcd == 1L) {
                        long y$macro$452 = longRational.d();
                        long z$macro$451 = lden * y$macro$452;
                        if (lden != 0L && (y$macro$452 != z$macro$451 / lden || lden == -1L && y$macro$452 == Long.MIN_VALUE)) {
                            return this.checked$fallback$macro$443$1(dgcd, lden, rden, longRational);
                        }
                        rational2 = Rational$.MODULE$.apply((long)var40_20, z$macro$451);
                    } else {
                        rational2 = Rational$.MODULE$.buildWithDiv((long)var40_20, ngcd, longRational.d(), lden);
                    }
                }
                rational = rational2;
            } else if (r instanceof BigRational) {
                Rational rational3;
                BigRational bigRational = (BigRational)r;
                long dgcd = package$.MODULE$.gcd(this.d(), bigRational.d().$percent(this.d()).toLong());
                if (dgcd == 1L) {
                    SafeLong num = bigRational.d().$times(this.n()).$plus(bigRational.n().$times(this.d()));
                    SafeLong den = bigRational.d().$times(this.d());
                    rational3 = Rational$.MODULE$.apply(num, den);
                } else {
                    long l;
                    long lden = this.d() / dgcd;
                    SafeLong num = bigRational.d().$div(dgcd).$times(this.n()).$plus(bigRational.n().$times(lden));
                    if (num instanceof SafeLongLong) {
                        SafeLongLong safeLongLong = (SafeLongLong)num;
                        l = package$.MODULE$.gcd(safeLongLong.x(), dgcd);
                    } else if (num instanceof SafeLongBigInteger) {
                        SafeLongBigInteger safeLongBigInteger = (SafeLongBigInteger)num;
                        l = package$.MODULE$.gcd(dgcd, safeLongBigInteger.x().mod(BigInteger.valueOf(dgcd)).longValue());
                    } else {
                        throw new MatchError((Object)num);
                    }
                    rational3 = l == 1L ? Rational$.MODULE$.apply(num, SafeLong$.MODULE$.apply(lden).$times(bigRational.d())) : Rational$.MODULE$.apply(num.$div(l), bigRational.d().$div(l).$times(lden));
                }
                rational = rational3;
            } else {
                throw new MatchError((Object)r);
            }
            return rational;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Rational $minus(Rational r) {
            Rational rational;
            if (r instanceof LongRational) {
                Rational rational2;
                LongRational longRational = (LongRational)r;
                long dgcd = package$.MODULE$.gcd(this.d(), longRational.d());
                if (dgcd == 1L) {
                    void var18_9;
                    void var12_6;
                    long x$macro$458 = this.n();
                    long y$macro$459 = longRational.d();
                    long z$macro$457 = x$macro$458 * y$macro$459;
                    if (x$macro$458 != 0L && (y$macro$459 != z$macro$457 / x$macro$458 || x$macro$458 == -1L && y$macro$459 == Long.MIN_VALUE)) {
                        return this.checked$fallback$macro$453$1(longRational);
                    }
                    long x$macro$461 = longRational.n();
                    long y$macro$462 = this.d();
                    long z$macro$460 = x$macro$461 * y$macro$462;
                    if (x$macro$461 != 0L && (y$macro$462 != z$macro$460 / x$macro$461 || x$macro$461 == -1L && y$macro$462 == Long.MIN_VALUE)) {
                        return this.checked$fallback$macro$453$1(longRational);
                    }
                    void z$macro$454 = var12_6 - var18_9;
                    if (((var12_6 ^ var18_9) & (var12_6 ^ z$macro$454)) < 0L) {
                        return this.checked$fallback$macro$453$1(longRational);
                    }
                    long x$macro$464 = this.d();
                    long y$macro$465 = longRational.d();
                    long z$macro$463 = x$macro$464 * y$macro$465;
                    if (x$macro$464 != 0L && (y$macro$465 != z$macro$463 / x$macro$464 || x$macro$464 == -1L && y$macro$465 == Long.MIN_VALUE)) {
                        return this.checked$fallback$macro$453$1(longRational);
                    }
                    rational2 = Rational$.MODULE$.apply((long)z$macro$454, z$macro$463);
                } else {
                    void var40_20;
                    void var38_19;
                    void var34_17;
                    long lden = this.d() / dgcd;
                    long rden = longRational.d() / dgcd;
                    long x$macro$471 = this.n();
                    long z$macro$470 = x$macro$471 * rden;
                    if (x$macro$471 != 0L && (rden != z$macro$470 / x$macro$471 || x$macro$471 == -1L && rden == Long.MIN_VALUE)) {
                        return this.checked$fallback$macro$466$1(dgcd, lden, rden, longRational);
                    }
                    long x$macro$473 = longRational.n();
                    long z$macro$472 = x$macro$473 * lden;
                    if (x$macro$473 != 0L && (lden != z$macro$472 / x$macro$473 || x$macro$473 == -1L && lden == Long.MIN_VALUE)) {
                        return this.checked$fallback$macro$466$1(dgcd, lden, rden, longRational);
                    }
                    void z$macro$467 = var34_17 - var38_19;
                    if (((var34_17 ^ var38_19) & (var34_17 ^ z$macro$467)) < 0L) {
                        return this.checked$fallback$macro$466$1(dgcd, lden, rden, longRational);
                    }
                    long ngcd = package$.MODULE$.gcd((long)var40_20, dgcd);
                    if (ngcd == 1L) {
                        long y$macro$475 = longRational.d();
                        long z$macro$474 = lden * y$macro$475;
                        if (lden != 0L && (y$macro$475 != z$macro$474 / lden || lden == -1L && y$macro$475 == Long.MIN_VALUE)) {
                            return this.checked$fallback$macro$466$1(dgcd, lden, rden, longRational);
                        }
                        rational2 = Rational$.MODULE$.apply((long)var40_20, z$macro$474);
                    } else {
                        rational2 = Rational$.MODULE$.buildWithDiv((long)var40_20, ngcd, longRational.d(), lden);
                    }
                }
                rational = rational2;
            } else if (r instanceof BigRational) {
                Rational rational3;
                BigRational bigRational = (BigRational)r;
                long dgcd = package$.MODULE$.gcd(this.d(), bigRational.d().$percent(this.d()).toLong());
                if (dgcd == 1L) {
                    SafeLong num = bigRational.d().$times(this.n()).$minus(bigRational.n().$times(this.d()));
                    SafeLong den = bigRational.d().$times(this.d());
                    rational3 = Rational$.MODULE$.apply(num, den);
                } else {
                    long l;
                    long lden = this.d() / dgcd;
                    SafeLong num = bigRational.d().$div(dgcd).$times(this.n()).$minus(bigRational.n().$times(lden));
                    if (num instanceof SafeLongLong) {
                        SafeLongLong safeLongLong = (SafeLongLong)num;
                        l = package$.MODULE$.gcd(safeLongLong.x(), dgcd);
                    } else if (num instanceof SafeLongBigInteger) {
                        SafeLongBigInteger safeLongBigInteger = (SafeLongBigInteger)num;
                        l = package$.MODULE$.gcd(dgcd, safeLongBigInteger.x().mod(BigInteger.valueOf(dgcd)).longValue());
                    } else {
                        throw new MatchError((Object)num);
                    }
                    rational3 = l == 1L ? Rational$.MODULE$.apply(num, SafeLong$.MODULE$.apply(lden).$times(bigRational.d())) : Rational$.MODULE$.apply(num.$div(l), bigRational.d().$div(l).$times(lden));
                }
                rational = rational3;
            } else {
                throw new MatchError((Object)r);
            }
            return rational;
        }

        @Override
        public Rational $times(Rational r) {
            Rational rational;
            if (this.n() == 0L) {
                return Rational$.MODULE$.zero();
            }
            if (r instanceof LongRational) {
                LongRational longRational = (LongRational)r;
                long a = package$.MODULE$.gcd(this.n(), longRational.d());
                long b = package$.MODULE$.gcd(this.d(), longRational.n());
                long n1 = this.n() / a;
                long n2 = longRational.n() / b;
                long d1 = this.d() / b;
                long d2 = longRational.d() / a;
                long z$macro$477 = n1 * n2;
                if (n1 != 0L && (n2 != z$macro$477 / n1 || n1 == -1L && n2 == Long.MIN_VALUE)) {
                    return LongRational.checked$fallback$macro$476$1(n1, n2, d1, d2);
                }
                long z$macro$478 = d1 * d2;
                if (d1 != 0L && (d2 != z$macro$478 / d1 || d1 == -1L && d2 == Long.MIN_VALUE)) {
                    return LongRational.checked$fallback$macro$476$1(n1, n2, d1, d2);
                }
                rational = Rational$.MODULE$.spire$math$Rational$$longRational(z$macro$477, z$macro$478);
            } else if (r instanceof BigRational) {
                BigRational bigRational = (BigRational)r;
                long a = package$.MODULE$.gcd(this.n(), bigRational.d().$percent(this.n()).toLong());
                long b = package$.MODULE$.gcd(this.d(), bigRational.n().$percent(this.d()).toLong());
                rational = Rational$.MODULE$.apply(SafeLong$.MODULE$.apply(this.n() / a).$times(bigRational.n().$div(b)), SafeLong$.MODULE$.apply(this.d() / b).$times(bigRational.d().$div(a)));
            } else {
                throw new MatchError((Object)r);
            }
            return rational;
        }

        @Override
        public Rational $div(Rational r) {
            Rational rational;
            if (r instanceof LongRational) {
                LongRational longRational = (LongRational)r;
                if (longRational.n() == 0L) {
                    throw new ArithmeticException("divide (/) by 0");
                }
                if (this.n() == 0L) {
                    return this;
                }
                long a = package$.MODULE$.gcd(this.n(), longRational.n());
                long b = package$.MODULE$.gcd(this.d(), longRational.d());
                long n1 = this.n() / a;
                long n2 = longRational.n() / a;
                LongRef d1 = LongRef.create((long)(this.d() / b));
                LongRef d2 = LongRef.create((long)(longRational.d() / b));
                if (n2 < 0L) {
                    d1.elem = -d1.elem;
                    d2.elem = -d2.elem;
                }
                long z$macro$480 = n1 * d2.elem;
                if (n1 != 0L && (d2.elem != z$macro$480 / n1 || n1 == -1L && d2.elem == Long.MIN_VALUE)) {
                    return LongRational.checked$fallback$macro$479$1(n1, n2, d1, d2);
                }
                long z$macro$481 = d1.elem * n2;
                if (d1.elem != 0L && (n2 != z$macro$481 / d1.elem || d1.elem == -1L && n2 == Long.MIN_VALUE)) {
                    return LongRational.checked$fallback$macro$479$1(n1, n2, d1, d2);
                }
                rational = Rational$.MODULE$.spire$math$Rational$$longRational(z$macro$480, z$macro$481);
            } else if (r instanceof BigRational) {
                BigRational bigRational = (BigRational)r;
                if (this.n() == 0L) {
                    return this;
                }
                long a = package$.MODULE$.gcd(this.n(), bigRational.n().$percent(this.n()).toLong());
                long b = package$.MODULE$.gcd(this.d(), bigRational.d().$percent(this.d()).toLong());
                SafeLong num = SafeLong$.MODULE$.apply(this.n() / a).$times(bigRational.d().$div(b));
                SafeLong den = SafeLong$.MODULE$.apply(this.d() / b).$times(bigRational.n().$div(a));
                rational = den.signum() < 0 ? Rational$.MODULE$.apply(num.unary_$minus(), den.unary_$minus()) : Rational$.MODULE$.apply(num, den);
            } else {
                throw new MatchError((Object)r);
            }
            return rational;
        }

        @Override
        public Rational gcd(Rational r) {
            Rational rational;
            if (this.isZero()) {
                return r.abs();
            }
            if (this.isOne()) {
                return this;
            }
            if (r instanceof LongRational) {
                Rational rational2;
                LongRational longRational = (LongRational)r;
                long dgcd = package$.MODULE$.gcd(this.d(), longRational.d());
                long n0 = package$.MODULE$.abs(this.n());
                long n1 = package$.MODULE$.abs(longRational.n());
                if (dgcd == 1L) {
                    rational2 = Rational$.MODULE$.apply(SafeLong$.MODULE$.apply(package$.MODULE$.gcd(n0, n1)), SafeLong$.MODULE$.apply(this.d()).$times(longRational.d()));
                } else {
                    long lm = this.d() / dgcd;
                    long rm = longRational.d() / dgcd;
                    rational2 = Rational$.MODULE$.apply(SafeLong$.MODULE$.apply(n0).$times(rm).gcd(SafeLong$.MODULE$.apply(n1).$times(lm)), SafeLong$.MODULE$.apply(dgcd).$times(lm).$times(rm));
                }
                rational = rational2;
            } else if (r instanceof BigRational) {
                Rational rational3;
                BigRational bigRational = (BigRational)r;
                long dgcd = package$.MODULE$.gcd(this.d(), bigRational.d().$percent(this.d()).toLong());
                if (dgcd == 1L) {
                    rational3 = Rational$.MODULE$.apply(SafeLong$.MODULE$.apply(package$.MODULE$.gcd(package$.MODULE$.abs(this.n()), package$.MODULE$.abs(bigRational.n().$percent(this.n()).toLong()))), SafeLong$.MODULE$.apply(this.d()).$times(bigRational.d()));
                } else {
                    long lm = this.d() / dgcd;
                    SafeLong rm = bigRational.d().$div(dgcd);
                    rational3 = Rational$.MODULE$.apply(SafeLong$.MODULE$.apply(package$.MODULE$.abs(this.n())).$times(rm).gcd(bigRational.n().abs().$times(lm)), SafeLong$.MODULE$.apply(dgcd).$times(lm).$times(rm));
                }
                rational = rational3;
            } else {
                throw new MatchError((Object)r);
            }
            return rational;
        }

        @Override
        public Rational floor() {
            if (this.d() == 1L) {
                return this;
            }
            if (this.n() >= 0L) {
                return Rational$.MODULE$.apply(this.n() / this.d(), 1L);
            }
            return Rational$.MODULE$.apply(this.n() / this.d() - 1L, 1L);
        }

        @Override
        public Rational ceil() {
            if (this.d() == 1L) {
                return this;
            }
            if (this.n() >= 0L) {
                return Rational$.MODULE$.apply(this.n() / this.d() + 1L, 1L);
            }
            return Rational$.MODULE$.apply(this.n() / this.d(), 1L);
        }

        @Override
        public Rational round() {
            if (this.n() >= 0L) {
                long m = this.n() % this.d();
                if (m >= this.d() - m) {
                    return Rational$.MODULE$.apply(this.n() / this.d() + 1L);
                }
                return Rational$.MODULE$.apply(this.n() / this.d());
            }
            long m = -(this.n() % this.d());
            if (m >= this.d() - m) {
                return Rational$.MODULE$.apply(this.n() / this.d() - 1L);
            }
            return Rational$.MODULE$.apply(this.n() / this.d());
        }

        @Override
        public Rational pow(int exp) {
            if (exp == 0) {
                return Rational$.MODULE$.one();
            }
            if (exp < 0) {
                return this.reciprocal().pow(-exp);
            }
            return Rational$.MODULE$.apply(SafeLong$.MODULE$.apply(this.n()).pow(exp), SafeLong$.MODULE$.apply(this.d()).pow(exp));
        }

        @Override
        public int compareToOne() {
            long l = this.n();
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            return new RichLong(l).compare((Object)BoxesRunTime.boxToLong((long)this.d()));
        }

        public int compare(Rational r) {
            int n;
            if (r instanceof LongRational) {
                LongRational longRational = (LongRational)r;
                n = this.checked$attempt$macro$482$1(longRational);
            } else if (r instanceof BigRational) {
                BigRational bigRational = (BigRational)r;
                long dgcd = package$.MODULE$.gcd(this.d(), bigRational.d().$percent(this.d()).toLong());
                n = dgcd == 1L ? SafeLong$.MODULE$.apply(this.n()).$times(bigRational.d()).compare((Object)bigRational.n().$times(this.d())) : SafeLong$.MODULE$.apply(this.n()).$times(bigRational.d().$div(dgcd)).compare((Object)bigRational.n().$times(this.d() / dgcd));
            } else {
                throw new MatchError((Object)r);
            }
            return n;
        }

        @Override
        public long longValue() {
            if (this.d() == 1L) {
                return this.n();
            }
            return this.n() / this.d();
        }

        @Override
        public boolean equals(Object that) {
            boolean bl;
            if (that instanceof LongRational) {
                LongRational longRational = (LongRational)((Object)that);
                bl = this.n() == longRational.n() && this.d() == longRational.d();
            } else {
                bl = super.equals(that);
            }
            return bl;
        }

        public int hashCode() {
            if (this.d() == 1L) {
                return this.unifiedPrimitiveHashcode();
            }
            return 29 * (37 * Statics.longHash((long)this.n()) + Statics.longHash((long)this.d()));
        }

        public String toString() {
            if (this.isWhole()) {
                return ((Object)BoxesRunTime.boxToLong((long)this.n())).toString();
            }
            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.n()), BoxesRunTime.boxToLong((long)this.d())}));
        }

        private final Rational checked$fallback$macro$430$1(LongRational x2$1) {
            return Rational$.MODULE$.apply(SafeLong$.MODULE$.apply(this.n()).$times(x2$1.d()).$plus(SafeLong$.MODULE$.apply(x2$1.n()).$times(this.d())), SafeLong$.MODULE$.apply(this.d()).$times(x2$1.d()));
        }

        private final Rational checked$fallback$macro$443$1(long dgcd$1, long lden$2, long rden$1, LongRational x2$1) {
            SafeLong num = SafeLong$.MODULE$.apply(this.n()).$times(rden$1).$plus(SafeLong$.MODULE$.apply(x2$1.n()).$times(lden$2));
            long ngcd = package$.MODULE$.gcd(dgcd$1, num.$percent(dgcd$1).toLong());
            if (ngcd == 1L) {
                return Rational$.MODULE$.apply(num, SafeLong$.MODULE$.apply(lden$2).$times(x2$1.d()));
            }
            return Rational$.MODULE$.apply(num.$div(ngcd), SafeLong$.MODULE$.apply(lden$2).$times(x2$1.d() / ngcd));
        }

        private final Rational checked$fallback$macro$453$1(LongRational x2$2) {
            return Rational$.MODULE$.apply(SafeLong$.MODULE$.apply(this.n()).$times(x2$2.d()).$minus(SafeLong$.MODULE$.apply(x2$2.n()).$times(this.d())), SafeLong$.MODULE$.apply(this.d()).$times(x2$2.d()));
        }

        private final Rational checked$fallback$macro$466$1(long dgcd$2, long lden$3, long rden$2, LongRational x2$2) {
            SafeLong num = SafeLong$.MODULE$.apply(this.n()).$times(rden$2).$minus(SafeLong$.MODULE$.apply(x2$2.n()).$times(lden$3));
            long ngcd = package$.MODULE$.gcd(dgcd$2, num.$percent(dgcd$2).toLong());
            if (ngcd == 1L) {
                return Rational$.MODULE$.apply(num, SafeLong$.MODULE$.apply(lden$3).$times(x2$2.d()));
            }
            return Rational$.MODULE$.apply(num.$div(ngcd), SafeLong$.MODULE$.apply(lden$3).$times(x2$2.d() / ngcd));
        }

        private static final Rational checked$fallback$macro$476$1(long n1$1, long n2$1, long d1$1, long d2$1) {
            return Rational$.MODULE$.spire$math$Rational$$bigRational(SafeLong$.MODULE$.apply(n1$1).$times(n2$1), SafeLong$.MODULE$.apply(d1$1).$times(d2$1));
        }

        private static final Rational checked$fallback$macro$479$1(long n1$2, long n2$2, LongRef d1$2, LongRef d2$2) {
            return Rational$.MODULE$.spire$math$Rational$$bigRational(SafeLong$.MODULE$.apply(n1$2).$times(d2$2.elem), SafeLong$.MODULE$.apply(d1$2.elem).$times(n2$2));
        }

        private final int checked$fallback$macro$483$1(LongRational x2$3) {
            long dgcd = package$.MODULE$.gcd(this.d(), x2$3.d());
            if (dgcd == 1L) {
                return SafeLong$.MODULE$.apply(this.n()).$times(x2$3.d()).compare((Object)SafeLong$.MODULE$.apply(x2$3.n()).$times(this.d()));
            }
            return SafeLong$.MODULE$.apply(this.n()).$times(x2$3.d() / dgcd).compare((Object)SafeLong$.MODULE$.apply(x2$3.n()).$times(this.d() / dgcd));
        }

        private final int checked$attempt$macro$482$1(LongRational x2$3) {
            long x$macro$485 = this.n();
            long y$macro$486 = x2$3.d();
            long z$macro$484 = x$macro$485 * y$macro$486;
            if (x$macro$485 != 0L && (y$macro$486 != z$macro$484 / x$macro$485 || x$macro$485 == -1L && y$macro$486 == Long.MIN_VALUE)) {
                return this.checked$fallback$macro$483$1(x2$3);
            }
            long x$macro$488 = x2$3.n();
            long y$macro$489 = this.d();
            long z$macro$487 = x$macro$488 * y$macro$489;
            if (x$macro$488 != 0L && (y$macro$489 != z$macro$487 / x$macro$488 || x$macro$488 == -1L && y$macro$489 == Long.MIN_VALUE)) {
                return this.checked$fallback$macro$483$1(x2$3);
            }
            return package$long$.MODULE$.LongAlgebra().compare$mcJ$sp(z$macro$484, z$macro$487);
        }

        public LongRational(long n, long d) {
            this.n = n;
            this.d = d;
        }
    }
}

