/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.spockframework.runtime.IFeatureFilter;
import org.spockframework.runtime.IFeatureSortOrder;
import org.spockframework.runtime.IMethodNameMapper;
import org.spockframework.runtime.IRunListener;
import org.spockframework.runtime.extension.IMethodInterceptor;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.FieldInfo;
import org.spockframework.runtime.model.IExcludable;
import org.spockframework.runtime.model.IInterceptable;
import org.spockframework.runtime.model.ISkippable;
import org.spockframework.runtime.model.MethodInfo;
import org.spockframework.runtime.model.NodeInfo;
import org.spockframework.util.InternalIdentifiers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpecInfo
extends NodeInfo<NodeInfo, Class<?>>
implements IMethodNameMapper,
ISkippable,
IExcludable,
IInterceptable {
    private final List<FieldInfo> fields = new ArrayList<FieldInfo>();
    private final List<IMethodInterceptor> interceptors = new ArrayList<IMethodInterceptor>();
    private final List<IRunListener> listeners = new ArrayList<IRunListener>();
    private String filename;
    private SpecInfo superSpec;
    private SpecInfo subSpec;
    private List<SpecInfo> specsTopToBottom;
    private List<SpecInfo> specsBottomToTop;
    private MethodInfo initializerMethod;
    private MethodInfo sharedInitializerMethod;
    private MethodInfo setupMethod;
    private MethodInfo cleanupMethod;
    private MethodInfo setupSpecMethod;
    private MethodInfo cleanupSpecMethod;
    private List<FeatureInfo> features = new ArrayList<FeatureInfo>();
    private boolean excluded = false;
    private boolean skipped = false;

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public SpecInfo getSuperSpec() {
        return this.superSpec;
    }

    public void setSuperSpec(SpecInfo superSpec) {
        this.superSpec = superSpec;
    }

    public SpecInfo getSubSpec() {
        return this.subSpec;
    }

    public void setSubSpec(SpecInfo subSpec) {
        this.subSpec = subSpec;
    }

    public SpecInfo getTopSpec() {
        SpecInfo curr = this;
        while (curr.getSuperSpec() != null) {
            curr = curr.getSuperSpec();
        }
        return curr;
    }

    public boolean isTopSpec() {
        return this.superSpec == null;
    }

    public SpecInfo getBottomSpec() {
        SpecInfo curr = this;
        while (curr.getSubSpec() != null) {
            curr = curr.getSubSpec();
        }
        return curr;
    }

    public boolean isBottomSpec() {
        return this.subSpec == null;
    }

    public List<SpecInfo> getSpecsTopToBottom() {
        if (this.specsTopToBottom == null) {
            this.specsTopToBottom = new ArrayList<SpecInfo>();
            for (SpecInfo curr = this.getTopSpec(); curr != null; curr = curr.getSubSpec()) {
                this.specsTopToBottom.add(curr);
            }
        }
        return this.specsTopToBottom;
    }

    public List<SpecInfo> getSpecsBottomToTop() {
        if (this.specsBottomToTop == null) {
            this.specsBottomToTop = new ArrayList<SpecInfo>();
            for (SpecInfo curr = this.getBottomSpec(); curr != null; curr = curr.getSuperSpec()) {
                this.specsBottomToTop.add(curr);
            }
        }
        return this.specsBottomToTop;
    }

    public MethodInfo getInitializerMethod() {
        return this.initializerMethod;
    }

    public void setInitializerMethod(MethodInfo initializerMethod) {
        this.initializerMethod = initializerMethod;
    }

    public MethodInfo getSharedInitializerMethod() {
        return this.sharedInitializerMethod;
    }

    public void setSharedInitializerMethod(MethodInfo sharedInitializerMethod) {
        this.sharedInitializerMethod = sharedInitializerMethod;
    }

    public MethodInfo getSetupMethod() {
        return this.setupMethod;
    }

    public void setSetupMethod(MethodInfo setupMethod) {
        this.setupMethod = setupMethod;
    }

    public MethodInfo getCleanupMethod() {
        return this.cleanupMethod;
    }

    public void setCleanupMethod(MethodInfo cleanupMethod) {
        this.cleanupMethod = cleanupMethod;
    }

    public MethodInfo getSetupSpecMethod() {
        return this.setupSpecMethod;
    }

    public void setSetupSpecMethod(MethodInfo setupSpecMethod) {
        this.setupSpecMethod = setupSpecMethod;
    }

    public MethodInfo getCleanupSpecMethod() {
        return this.cleanupSpecMethod;
    }

    public void setCleanupSpecMethod(MethodInfo cleanupSpecMethod) {
        this.cleanupSpecMethod = cleanupSpecMethod;
    }

    public List<MethodInfo> getFixtureMethods() {
        return Arrays.asList(this.setupSpecMethod, this.setupMethod, this.cleanupMethod, this.cleanupSpecMethod);
    }

    public List<MethodInfo> getAllFixtureMethods() {
        if (this.superSpec == null) {
            return this.getFixtureMethods();
        }
        ArrayList<MethodInfo> result = new ArrayList<MethodInfo>(this.superSpec.getAllFixtureMethods());
        result.addAll(this.getFixtureMethods());
        return result;
    }

    public List<FieldInfo> getFields() {
        return this.fields;
    }

    public List<FieldInfo> getAllFields() {
        if (this.superSpec == null) {
            return this.fields;
        }
        ArrayList<FieldInfo> result = new ArrayList<FieldInfo>(this.superSpec.getAllFields());
        result.addAll(this.fields);
        return result;
    }

    public void addField(FieldInfo field) {
        this.fields.add(field);
    }

    public List<FeatureInfo> getFeatures() {
        return this.features;
    }

    public List<FeatureInfo> getAllFeatures() {
        if (this.superSpec == null) {
            return this.features;
        }
        ArrayList<FeatureInfo> result = new ArrayList<FeatureInfo>(this.superSpec.getAllFeatures());
        result.addAll(this.features);
        return result;
    }

    public List<FeatureInfo> getAllFeaturesInExecutionOrder() {
        List<FeatureInfo> result = this.getAllFeatures();
        Collections.sort(result, new Comparator<FeatureInfo>(){

            @Override
            public int compare(FeatureInfo f1, FeatureInfo f2) {
                return f1.getExecutionOrder() - f2.getExecutionOrder();
            }
        });
        return result;
    }

    public void addFeature(FeatureInfo feature) {
        this.features.add(feature);
    }

    @Override
    public List<IMethodInterceptor> getInterceptors() {
        return this.interceptors;
    }

    @Override
    public void addInterceptor(IMethodInterceptor interceptor) {
        this.interceptors.add(interceptor);
    }

    public List<IRunListener> getListeners() {
        return this.listeners;
    }

    public void addListener(IRunListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public boolean isExcluded() {
        return this.excluded;
    }

    @Override
    public void setExcluded(boolean excluded) {
        this.excluded = excluded;
    }

    @Override
    public boolean isSkipped() {
        return this.skipped;
    }

    @Override
    public void setSkipped(boolean skipped) {
        this.skipped = skipped;
    }

    public void filterFeatures(IFeatureFilter filter) {
        for (FeatureInfo feature : this.getAllFeatures()) {
            if (filter.matches(feature)) continue;
            feature.setExcluded(true);
        }
    }

    public void sortFeatures(IFeatureSortOrder order) {
        List<FeatureInfo> features = this.getAllFeatures();
        Collections.sort(features, order);
        for (int i = 0; i < features.size(); ++i) {
            features.get(i).setExecutionOrder(i);
        }
    }

    @Override
    public boolean isInitializerOrFixtureMethod(String className, String methodName) {
        if (!InternalIdentifiers.INITIALIZER_AND_FIXTURE_METHODS.contains(methodName)) {
            return false;
        }
        for (SpecInfo spec : this.getSpecsBottomToTop()) {
            if (!((Class)spec.getReflection()).getName().equals(className)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toFeatureName(String methodName) {
        for (FeatureInfo feature : this.getAllFeatures()) {
            if (!feature.hasBytecodeName(methodName)) continue;
            return feature.getName();
        }
        return methodName;
    }
}

