/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.util;

import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.spockframework.util.ExceptionUtil;
import org.spockframework.util.ObjectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReflectionUtil {
    public static Class<?> loadClassIfAvailable(String className) {
        try {
            return ReflectionUtil.class.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static boolean isClassAvailable(String className) {
        return ReflectionUtil.loadClassIfAvailable(className) != null;
    }

    public static boolean isMethodAvailable(String className, String methodName) {
        try {
            Class<?> clazz = ReflectionUtil.class.getClassLoader().loadClass(className);
            return ReflectionUtil.getMethodByName(clazz, methodName) != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean isAnnotationPresent(AnnotatedElement element, String className) {
        for (Annotation ann : element.getAnnotations()) {
            if (!ann.annotationType().getName().equals(className)) continue;
            return true;
        }
        return false;
    }

    public static Method getMethodByName(Class<?> clazz, String name) {
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(name)) continue;
            return method;
        }
        return null;
    }

    public static Method getDeclaredMethodByName(Class<?> clazz, String name) {
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.getName().equals(name)) continue;
            return method;
        }
        return null;
    }

    public static Method getMethodBySignature(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        try {
            return clazz.getMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Method getDeclaredMethodBySignature(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        try {
            return clazz.getDeclaredMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static File getClassFile(Class<?> clazz) {
        File dir = new File(clazz.getProtectionDomain().getCodeSource().getLocation().getPath());
        if (!dir.isDirectory()) {
            return null;
        }
        File clazzFile = new File(dir, clazz.getName().replace('.', File.separatorChar) + ".class");
        return clazzFile.isFile() ? clazzFile : null;
    }

    public static Object getDefaultValue(Class<?> type) {
        if (!type.isPrimitive()) {
            return null;
        }
        if (type == Boolean.TYPE) {
            return false;
        }
        if (type == Integer.TYPE) {
            return 0;
        }
        if (type == Long.TYPE) {
            return 0L;
        }
        if (type == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (type == Double.TYPE) {
            return 0.0;
        }
        if (type == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        if (type == Short.TYPE) {
            return (short)0;
        }
        if (type == Byte.TYPE) {
            return (byte)0;
        }
        assert (type == Void.TYPE);
        return null;
    }

    public static boolean hasAnyOfTypes(Object value, Class<?> ... types) {
        for (Class<?> type : types) {
            if (!type.isInstance(value)) continue;
            return true;
        }
        return false;
    }

    public static Class[] getTypes(Object ... objects) {
        Class[] classes = new Class[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            classes[i] = ObjectUtil.getClass(objects[i]);
        }
        return classes;
    }

    public static Object invokeMethod(Object target, Method method, Object ... args) {
        try {
            return method.invoke(target, args);
        }
        catch (IllegalAccessException e) {
            ExceptionUtil.sneakyThrow(e);
            return null;
        }
        catch (InvocationTargetException e) {
            ExceptionUtil.sneakyThrow(e.getCause());
            return null;
        }
    }
}

