/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.mock.constraint;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.spockframework.mock.IArgumentConstraint;
import org.spockframework.mock.IInvocationConstraint;
import org.spockframework.mock.IMockInvocation;
import org.spockframework.util.Assert;

public class NamedArgumentListConstraint
implements IInvocationConstraint {
    private final List<Object> argNames;
    private final List<IArgumentConstraint> argConstraints;

    public NamedArgumentListConstraint(List<Object> argNames, List<IArgumentConstraint> argConstraints) {
        Assert.that(argNames.size() == argConstraints.size());
        this.argNames = argNames;
        this.argConstraints = argConstraints;
    }

    @Override
    public boolean isSatisfiedBy(IMockInvocation invocation) {
        List<Object> args = invocation.getArguments();
        if (args.size() == 1 && args.get(0) instanceof Map) {
            return this.matchesArgMap(new HashMap((Map)args.get(0)));
        }
        return this.matchesArgList(new ArrayList<Object>(args));
    }

    private boolean matchesArgList(List<Object> args) {
        for (int i = 0; i < this.argConstraints.size(); ++i) {
            Iterator<Object> argIter;
            block3: {
                Object name = this.argNames.get(i);
                if (!"_".equals(name)) {
                    return false;
                }
                IArgumentConstraint matcher = this.argConstraints.get(i);
                argIter = args.iterator();
                while (argIter.hasNext()) {
                    if (!matcher.isSatisfiedBy(argIter.next())) continue;
                    break block3;
                }
                return false;
            }
            argIter.remove();
        }
        return true;
    }

    private boolean matchesArgMap(Map argMap) {
        IArgumentConstraint matcher;
        Object name;
        int i;
        for (i = 0; i < this.argConstraints.size(); ++i) {
            name = this.argNames.get(i);
            if ("_".equals(name)) continue;
            matcher = this.argConstraints.get(i);
            if (argMap.containsKey(name) && matcher.isSatisfiedBy(argMap.remove(name))) continue;
            return false;
        }
        block1: for (i = 0; i < this.argConstraints.size(); ++i) {
            name = this.argNames.get(i);
            if (!"_".equals(name)) continue;
            matcher = this.argConstraints.get(i);
            Iterator argIter = argMap.values().iterator();
            while (argIter.hasNext()) {
                if (!matcher.isSatisfiedBy(argIter.next())) continue;
                argIter.remove();
                continue block1;
            }
            return false;
        }
        return true;
    }
}

