/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.mock.constraint;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import org.spockframework.mock.IArgumentConstraint;
import org.spockframework.mock.IInvocationConstraint;
import org.spockframework.mock.IMockInvocation;
import org.spockframework.mock.IMockMethod;
import org.spockframework.mock.constraint.SpreadWildcardArgumentConstraint;
import org.spockframework.util.CollectionUtil;

public class PositionalArgumentListConstraint
implements IInvocationConstraint {
    private final List<IArgumentConstraint> argConstraints;

    public PositionalArgumentListConstraint(List<IArgumentConstraint> argConstraints) {
        this.argConstraints = argConstraints;
    }

    @Override
    public boolean isSatisfiedBy(IMockInvocation invocation) {
        List<Object> args = invocation.getArguments();
        if (this.areConstraintsSatisfiedBy(args)) {
            return true;
        }
        if (!this.hasExpandableVarArgs(invocation.getMethod(), args)) {
            return false;
        }
        return this.areConstraintsSatisfiedBy(this.expandVarArgs(args));
    }

    private boolean hasExpandableVarArgs(IMockMethod method, List<Object> args) {
        List<Class<?>> paramTypes = method.getParameterTypes();
        return !paramTypes.isEmpty() && CollectionUtil.getLastElement(paramTypes).isArray() && CollectionUtil.getLastElement(args) != null;
    }

    private List<Object> expandVarArgs(List<Object> args) {
        ArrayList<Object> expanded = new ArrayList<Object>(args.subList(0, args.size() - 1));
        Object varArgs = CollectionUtil.getLastElement(args);
        int length = Array.getLength(varArgs);
        for (int i = 0; i < length; ++i) {
            expanded.add(Array.get(varArgs, i));
        }
        return expanded;
    }

    private boolean areConstraintsSatisfiedBy(List<Object> args) {
        if (this.argConstraints.isEmpty()) {
            return args.isEmpty();
        }
        if (this.argConstraints.size() - args.size() > 1) {
            return false;
        }
        for (int i = 0; i < this.argConstraints.size() - 1; ++i) {
            if (this.argConstraints.get(i).isSatisfiedBy(args.get(i))) continue;
            return false;
        }
        IArgumentConstraint lastConstraint = CollectionUtil.getLastElement(this.argConstraints);
        if (lastConstraint instanceof SpreadWildcardArgumentConstraint) {
            return true;
        }
        return this.argConstraints.size() == args.size() && lastConstraint.isSatisfiedBy(CollectionUtil.getLastElement(args));
    }
}

