/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.spockframework.runtime.ExpressionInfoBuilder;
import org.spockframework.runtime.ExpressionInfoRenderer;
import org.spockframework.runtime.ExpressionInfoValueRenderer;
import org.spockframework.runtime.model.ExpressionInfo;
import org.spockframework.runtime.model.TextPosition;

public class Condition
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Pattern pattern = Pattern.compile("(?<backslashesToEscape>(:?\\\\\\\\)+)|(?<stripBackslash>\\\\\n)|(?<whitespacesToCollapse>\\s*\n\\s*)");
    private final transient List<Object> values;
    private final String text;
    private final TextPosition position;
    private final String message;
    private final Integer notRecordedVarNumberBecauseOfException;
    private final Throwable exception;
    private volatile transient ExpressionInfo expression;
    private volatile String rendering;

    public Condition(List<Object> values, String text, TextPosition position, String message, Integer notRecordedVarNumberBecauseOfException, Throwable exception) {
        this.text = text;
        this.position = position;
        this.values = values;
        this.message = message;
        this.notRecordedVarNumberBecauseOfException = notRecordedVarNumberBecauseOfException;
        this.exception = exception;
    }

    public List<Object> getValues() {
        return this.values;
    }

    public String getText() {
        return this.text;
    }

    public TextPosition getPosition() {
        return this.position;
    }

    public String getMessage() {
        return this.message;
    }

    public ExpressionInfo getExpression() {
        if (this.expression == null) {
            this.createExpression();
        }
        return this.expression;
    }

    public String getRendering() {
        if (this.rendering == null) {
            this.createRendering();
        }
        return this.rendering;
    }

    private void createExpression() {
        if (this.text == null || this.values == null) {
            return;
        }
        String stripAndFlattenText = Condition.stripAndFlatten(this.text).toString();
        this.expression = new ExpressionInfoBuilder(stripAndFlattenText, TextPosition.create(1, 1), this.values, this.notRecordedVarNumberBecauseOfException, this.exception).build();
    }

    private void createRendering() {
        StringBuilder builder = new StringBuilder();
        if (this.getExpression() != null) {
            ExpressionInfoValueRenderer.render(this.expression);
            builder.append(ExpressionInfoRenderer.render(this.expression));
        } else if (this.text != null) {
            builder.append(Condition.stripAndFlatten(this.text));
            builder.append("\n");
        } else {
            builder.append("(Source code not available)\n");
        }
        if (this.message != null) {
            builder.append("\n");
            builder.append(this.message);
            builder.append("\n");
        }
        this.rendering = builder.toString();
    }

    private static CharSequence stripAndFlatten(String text) {
        Matcher m = pattern.matcher(text);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String backslashesToEscape = m.group("backslashesToEscape");
            String replacement = backslashesToEscape != null ? backslashesToEscape + backslashesToEscape : (m.group("whitespacesToCollapse") != null ? " " : "");
            m.appendReplacement(sb, replacement);
        }
        m.appendTail(sb);
        return sb;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.getRendering();
        out.defaultWriteObject();
    }
}

