/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.manipulation.Sortable;
import org.junit.runner.manipulation.Sorter;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.InitializationError;
import org.spockframework.runtime.JUnitDescriptionGenerator;
import org.spockframework.runtime.JUnitFilterAdapter;
import org.spockframework.runtime.JUnitSorterAdapter;
import org.spockframework.runtime.RunContext;
import org.spockframework.runtime.SpecInfoBuilder;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.SpecInfo;
import org.spockframework.util.IncompatibleGroovyVersionException;
import org.spockframework.util.VersionChecker;

public class Sputnik
extends Runner
implements Filterable,
Sortable {
    private final Class<?> clazz;
    private SpecInfo spec;
    private boolean extensionsRun = false;
    private boolean descriptionGenerated = false;

    public Sputnik(Class<?> clazz) throws InitializationError {
        try {
            VersionChecker.checkGroovyVersion("JUnit runner");
        }
        catch (IncompatibleGroovyVersionException e) {
            throw new InitializationError((Throwable)e);
        }
        this.clazz = clazz;
    }

    public Description getDescription() {
        this.runExtensionsIfNecessary();
        this.generateSpecDescriptionIfNecessary();
        return this.getSpec().getDescription();
    }

    public void run(RunNotifier notifier) {
        this.runExtensionsIfNecessary();
        this.generateSpecDescriptionIfNecessary();
        RunContext.get().createSpecRunner(this.getSpec(), notifier).run();
    }

    public void filter(Filter filter) throws NoTestsRemainException {
        this.invalidateSpecDescription();
        this.getSpec().filterFeatures(new JUnitFilterAdapter(filter));
        if (this.allFeaturesExcluded()) {
            throw new NoTestsRemainException();
        }
    }

    public void sort(Sorter sorter) {
        this.invalidateSpecDescription();
        this.getSpec().sortFeatures(new JUnitSorterAdapter(sorter));
    }

    private SpecInfo getSpec() {
        if (this.spec == null) {
            this.spec = new SpecInfoBuilder(this.clazz).build();
            new JUnitDescriptionGenerator(this.spec).describeSpecMethods();
        }
        return this.spec;
    }

    private void runExtensionsIfNecessary() {
        if (this.extensionsRun) {
            return;
        }
        RunContext.get().createExtensionRunner(this.getSpec()).run();
        this.extensionsRun = true;
    }

    private void generateSpecDescriptionIfNecessary() {
        if (this.descriptionGenerated) {
            return;
        }
        new JUnitDescriptionGenerator(this.getSpec()).describeSpec();
        this.descriptionGenerated = true;
    }

    private void invalidateSpecDescription() {
        this.descriptionGenerated = false;
    }

    private boolean allFeaturesExcluded() {
        for (FeatureInfo feature : this.getSpec().getAllFeatures()) {
            if (feature.isExcluded()) continue;
            return false;
        }
        return true;
    }
}

