/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.spockframework.runtime.model.ExpressionInfo;

public class ValueRecorder {
    private final ArrayList<Object> values = new ArrayList();
    private final Deque<Integer> startedRecordings = new ArrayDeque<Integer>();
    public static final String RESET = "reset";
    public static final String RECORD = "record";
    public static final String START_RECORDING_VALUE = "startRecordingValue";
    public static final String REALIZE_NAS = "realizeNas";

    public ValueRecorder reset() {
        this.values.clear();
        return this;
    }

    public Object record(int index, Object value) {
        this.realizeNas(index, null);
        this.values.add(value);
        boolean foundThisCallOnStack = false;
        while (!this.startedRecordings.isEmpty()) {
            Integer indexFromStack = this.startedRecordings.pop();
            if (indexFromStack != index) continue;
            foundThisCallOnStack = true;
            break;
        }
        if (!foundThisCallOnStack) {
            throw new IllegalStateException("Did not find call #" + index + " on stack. Invalid call of record method?");
        }
        return value;
    }

    public int startRecordingValue(int index) {
        this.startedRecordings.push(index);
        return index;
    }

    public Object realizeNas(int index, Object value) {
        for (int i = this.values.size(); i < index; ++i) {
            this.values.add(ExpressionInfo.VALUE_NOT_AVAILABLE);
        }
        return value;
    }

    public List<Object> getValues() {
        return new ArrayList<Object>(this.values);
    }

    public Integer getCurrentRecordingVarNum() {
        if (this.startedRecordings.isEmpty()) {
            return null;
        }
        return this.startedRecordings.peek();
    }
}

