/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.buildsupport;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.spockframework.buildsupport.AsmClassReader;
import org.spockframework.buildsupport.SpecClassFileVisitor;

public class SpecClassFileFinder {
    public List<File> findRunnableSpecs(File baseDir) throws IOException {
        if (!baseDir.isDirectory()) {
            throw new FileNotFoundException(String.format("directory %s not found", baseDir));
        }
        ArrayList<File> specs = new ArrayList<File>();
        this.doFindRunnableSpecs(baseDir, specs);
        Collections.sort(specs);
        return specs;
    }

    private void doFindRunnableSpecs(File dir, List<File> foundSpecs) throws IOException {
        for (File path : dir.listFiles()) {
            if (path.isDirectory()) {
                this.doFindRunnableSpecs(path, foundSpecs);
                continue;
            }
            if (!this.isRunnableSpec(path)) continue;
            foundSpecs.add(path);
        }
    }

    public boolean isRunnableSpec(File file) throws IOException {
        if (!file.getName().endsWith(".class") || !file.isFile()) {
            return false;
        }
        try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));){
            SpecClassFileVisitor visitor = new SpecClassFileVisitor();
            AsmClassReader reader = new AsmClassReader(stream);
            reader.accept(visitor);
            boolean bl = visitor.isRunnableSpec();
            return bl;
        }
    }
}

