/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.compiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.spockframework.compiler.AstUtil;
import org.spockframework.compiler.ISpecialMethodCall;
import org.spockframework.lang.ConditionBlock;
import org.spockframework.util.CollectionUtil;
import org.spockframework.util.Identifiers;
import org.spockframework.util.ObjectUtil;

public class SpecialMethodCall
implements ISpecialMethodCall {
    private final String methodName;
    private final Expression inferredName;
    private final Expression inferredType;
    private final MethodCallExpression methodCallExpr;
    private final BinaryExpression binaryExpr;
    private final ClosureExpression closureExpr;
    private final boolean conditionBlock;

    public SpecialMethodCall(String methodName, Expression inferredName, Expression inferredType, MethodCallExpression methodCallExpr, BinaryExpression binaryExpr, ClosureExpression closureExpr, boolean conditionBlock) {
        this.methodName = methodName;
        this.inferredName = inferredName;
        this.inferredType = inferredType;
        this.binaryExpr = binaryExpr;
        this.methodCallExpr = methodCallExpr;
        this.closureExpr = closureExpr;
        this.conditionBlock = conditionBlock;
    }

    @Override
    public boolean isMethodName(String name) {
        return name.equals(this.methodName);
    }

    @Override
    public boolean isOneOfMethodNames(Collection<String> names) {
        return names.contains(this.methodName);
    }

    @Override
    public boolean isExceptionCondition() {
        return this.isOneOfMethodNames(Identifiers.EXCEPTION_CONDITION_METHODS);
    }

    @Override
    public boolean isThrownCall() {
        return this.isMethodName("thrown");
    }

    @Override
    public boolean isOldCall() {
        return this.isMethodName("old");
    }

    @Override
    public boolean isInteractionCall() {
        return this.isMethodName("interaction");
    }

    @Override
    public boolean isWithCall() {
        return this.isMethodName("with");
    }

    @Override
    public boolean isConditionBlock() {
        return this.conditionBlock;
    }

    @Override
    public boolean isGroupConditionBlock() {
        return this.isMethodName("verifyAll");
    }

    @Override
    public boolean isTestDouble() {
        return this.isOneOfMethodNames(Identifiers.TEST_DOUBLE_METHODS);
    }

    @Override
    public boolean isExceptionCondition(MethodCallExpression expr) {
        return expr == this.methodCallExpr && this.isExceptionCondition();
    }

    @Override
    public boolean isThrownCall(MethodCallExpression expr) {
        return expr == this.methodCallExpr && this.isThrownCall();
    }

    @Override
    public boolean isOldCall(MethodCallExpression expr) {
        return expr == this.methodCallExpr && this.isOldCall();
    }

    @Override
    public boolean isInteractionCall(MethodCallExpression expr) {
        return expr == this.methodCallExpr && this.isInteractionCall();
    }

    @Override
    public boolean isWithCall(MethodCallExpression expr) {
        return expr == this.methodCallExpr && this.isWithCall();
    }

    public boolean isConditionBlock(MethodCallExpression expr) {
        return expr == this.methodCallExpr && this.isConditionBlock();
    }

    @Override
    public boolean isTestDouble(MethodCallExpression expr) {
        return expr == this.methodCallExpr && this.isTestDouble();
    }

    @Override
    public boolean isMatch(Statement stat) {
        ExpressionStatement exprStat = ObjectUtil.asInstance(stat, ExpressionStatement.class);
        if (exprStat == null) {
            return false;
        }
        Expression expr = exprStat.getExpression();
        return expr == this.binaryExpr || expr == this.methodCallExpr;
    }

    @Override
    public boolean isMatch(ClosureExpression expr) {
        return expr == this.closureExpr;
    }

    @Override
    public ClosureExpression getClosureExpr() {
        return this.closureExpr;
    }

    @Override
    public void expand() {
        ArrayList<Expression> args = new ArrayList<Expression>();
        args.add(this.inferredName);
        args.add(this.inferredType);
        args.addAll(AstUtil.getArgumentList((Expression)this.methodCallExpr));
        ArgumentListExpression argsExpr = new ArgumentListExpression(args);
        AstUtil.copySourcePosition((ASTNode)this.methodCallExpr.getArguments(), (ASTNode)argsExpr);
        this.methodCallExpr.setArguments((Expression)argsExpr);
        this.methodCallExpr.setMethod((Expression)new ConstantExpression((Object)(this.methodName + "Impl")));
    }

    public static SpecialMethodCall parse(MethodCallExpression methodCallExpr, BinaryExpression binaryExpr) {
        Expression lastArg;
        ConstantExpression inferredType;
        ConstantExpression inferredName;
        boolean builtInCall = SpecialMethodCall.checkIsBuiltInMethodCall(methodCallExpr);
        boolean conditionBlock = SpecialMethodCall.checkIsConditionBlock(methodCallExpr);
        if (!builtInCall && !conditionBlock) {
            return null;
        }
        String methodName = methodCallExpr.getMethodAsString();
        if (binaryExpr != null && binaryExpr.getOperation().getType() == 100 && binaryExpr.getRightExpression() == methodCallExpr) {
            inferredName = AstUtil.getVariableName(binaryExpr);
            inferredType = AstUtil.getVariableType(binaryExpr);
        } else {
            binaryExpr = null;
            inferredName = ConstantExpression.NULL;
            inferredType = ConstantExpression.NULL;
        }
        ClosureExpression closureExpr = null;
        List<Expression> arguments = AstUtil.getArgumentList((Expression)methodCallExpr);
        if (!arguments.isEmpty() && (lastArg = CollectionUtil.getLastElement(arguments)) instanceof ClosureExpression) {
            closureExpr = (ClosureExpression)lastArg;
        }
        return new SpecialMethodCall(methodName, (Expression)inferredName, (Expression)inferredType, methodCallExpr, binaryExpr, closureExpr, conditionBlock);
    }

    public String toString() {
        return String.format("method name: %s\ninferred name: %s\ninferred type: %s\nmethod call:%s\nclosure: %s\ncondition block: %s\n", this.methodName, this.inferredName, this.inferredType, this.methodCallExpr, this.closureExpr, this.conditionBlock);
    }

    private static boolean checkIsBuiltInMethodCall(MethodCallExpression expr) {
        if (!AstUtil.isThisOrSuperExpression(expr.getObjectExpression())) {
            return false;
        }
        return Identifiers.BUILT_IN_METHODS.contains(expr.getMethodAsString());
    }

    private static boolean checkIsConditionBlock(MethodCallExpression methodCallExpr) {
        ClassNode targetType = methodCallExpr.getObjectExpression().getType();
        String methodName = methodCallExpr.getMethodAsString();
        List methods = targetType.getMethods(methodName);
        for (MethodNode method : methods) {
            for (AnnotationNode annotation : method.getAnnotations()) {
                if (!annotation.getClassNode().getName().equals(ConditionBlock.class.getName())) continue;
                return true;
            }
        }
        return false;
    }
}

