/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.util.Map;
import java.util.StringJoiner;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.IterationInfo;
import org.spockframework.runtime.model.NameProvider;
import org.spockframework.util.RenderUtil;

public class DataVariablesIterationNameProvider
implements NameProvider<IterationInfo> {
    @Override
    public String getName(IterationInfo iteration) {
        FeatureInfo feature = iteration.getFeature();
        if (!feature.isReportIterations()) {
            return feature.getName();
        }
        StringJoiner nameJoiner = new StringJoiner(", ", "[", "]");
        Map<String, Object> dataVariables = iteration.getDataVariables();
        if (dataVariables != null) {
            dataVariables.forEach((name, value) -> {
                String valueString;
                try {
                    valueString = RenderUtil.toStringOrDump(value);
                }
                catch (Exception e) {
                    valueString = String.format("#Error:%s during rendering", e.getClass().getSimpleName());
                }
                nameJoiner.add(String.format("%s: %s", name, valueString));
            });
        }
        nameJoiner.add(String.format("#%d", iteration.getIterationIndex()));
        return String.format("%s %s", feature.getName(), nameJoiner.toString());
    }
}

