/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.spockframework.runtime.RunContext;
import org.spockframework.runtime.extension.ExtensionException;
import org.spockframework.runtime.extension.IGlobalExtension;
import spock.config.ConfigurationObject;

public class ExtensionClassesLoader {
    public static final String EXTENSION_DESCRIPTOR_PATH = "META-INF/services/" + IGlobalExtension.class.getName();
    public static final String CONFIG_DESCRIPTOR_PATH = "META-INF/services/" + ConfigurationObject.class.getName();

    public List<Class<?>> loadExtensionClassesFromDefaultLocation() {
        return this.loadClasses(EXTENSION_DESCRIPTOR_PATH);
    }

    public List<Class<?>> loadConfigClassesFromDefaultLocation() {
        return this.loadClasses(CONFIG_DESCRIPTOR_PATH);
    }

    public List<Class<?>> loadClasses(String descriptorPath) {
        HashMap<String, URL> discoveredClasses = new HashMap<String, URL>();
        ArrayList extClasses = new ArrayList();
        for (URL url : this.locateDescriptors(descriptorPath)) {
            for (String className : this.readDescriptor(url)) {
                if (discoveredClasses.containsKey(className)) {
                    throw new ExtensionException("Duplicated Extension declaration for [%s]\nSource 1: %s\nSource 2: %s\nThis is most likely caused by having two different version of a library on the classpath.").withArgs(className, url, discoveredClasses.get(className));
                }
                discoveredClasses.put(className, url);
                extClasses.add(this.loadExtensionClass(className));
            }
        }
        return extClasses;
    }

    private List<URL> locateDescriptors(String descriptorPath) {
        try {
            return Collections.list(RunContext.class.getClassLoader().getResources(descriptorPath));
        }
        catch (Exception e) {
            throw new ExtensionException("Failed to locate extension descriptors", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> readDescriptor(URL url) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));){
            ArrayList<String> lines = new ArrayList<String>();
            String line = reader.readLine();
            while (line != null) {
                if ((line = line.trim()).length() > 0 && !line.startsWith("#")) {
                    lines.add(line);
                }
                line = reader.readLine();
            }
            ArrayList<String> arrayList = lines;
            return arrayList;
        }
        catch (IOException e) {
            throw new ExtensionException("Failed to read extension descriptor '%s'", e).withArgs(url);
        }
    }

    private Class<?> loadExtensionClass(String className) {
        try {
            return RunContext.class.getClassLoader().loadClass(className);
        }
        catch (Exception e) {
            throw new ExtensionException("Failed to load extension class '%s'", e).withArgs(className);
        }
    }
}

