/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.spockframework.runtime.IConfigurationRegistry;
import org.spockframework.runtime.IExtensionRegistry;
import org.spockframework.runtime.extension.ExtensionException;
import org.spockframework.runtime.extension.IGlobalExtension;
import org.spockframework.util.InternalSpockError;
import org.spockframework.util.UnreachableCodeError;
import spock.config.ConfigurationObject;

public class GlobalExtensionRegistry
implements IExtensionRegistry,
IConfigurationRegistry {
    private final List<Class<?>> globalExtensionClasses;
    private final Map<Class<?>, Object> configurationsByType = new HashMap();
    private final Map<String, Object> configurationsByName = new HashMap<String, Object>();
    private final List<IGlobalExtension> globalExtensions = new ArrayList<IGlobalExtension>();

    GlobalExtensionRegistry(List<Class<?>> globalExtensionClasses, List<Class<?>> initialConfigurations) {
        this.globalExtensionClasses = globalExtensionClasses;
        this.initializeConfigurations(initialConfigurations);
    }

    private void initializeConfigurations(List<Class<?>> initialConfigurations) {
        for (Class<?> configuration : initialConfigurations) {
            ConfigurationObject annotation = configuration.getAnnotation(ConfigurationObject.class);
            if (annotation == null) {
                throw new InternalSpockError("Not a @ConfigurationObject: %s").withArgs(configuration);
            }
            Object instance = this.createConfiguration(configuration);
            this.configurationsByType.put(configuration, instance);
            this.configurationsByName.put(annotation.value(), instance);
        }
    }

    public void initializeGlobalExtensions() {
        for (Class<?> clazz : this.globalExtensionClasses) {
            this.verifyGlobalExtension(clazz);
            IGlobalExtension extension = this.instantiateGlobalExtension(clazz);
            this.configureExtension(extension);
            this.globalExtensions.add(extension);
        }
    }

    @Override
    public <T> T getConfigurationByType(Class<T> clazz) {
        return clazz.cast(this.configurationsByType.get(clazz));
    }

    @Override
    public Object getConfigurationByName(String name) {
        return this.configurationsByName.get(name);
    }

    @Override
    public List<IGlobalExtension> getGlobalExtensions() {
        return this.globalExtensions;
    }

    private void verifyGlobalExtension(Class<?> clazz) {
        if (!IGlobalExtension.class.isAssignableFrom(clazz)) {
            throw new ExtensionException("Class '%s' is not a valid global extension because it is not derived from '%s'").withArgs(clazz.getName(), IGlobalExtension.class.getName());
        }
    }

    private IGlobalExtension instantiateGlobalExtension(Class<?> clazz) {
        try {
            return (IGlobalExtension)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new ExtensionException("Failed to instantiate extension '%s'", e).withArgs(clazz.getName());
        }
    }

    @Override
    public void configureExtension(Object extension) {
        for (Field field : extension.getClass().getDeclaredFields()) {
            ConfigurationObject annotation = field.getType().getAnnotation(ConfigurationObject.class);
            if (annotation == null) continue;
            this.injectConfiguration(field, annotation.value(), extension);
        }
    }

    public void startGlobalExtensions() {
        for (IGlobalExtension extension : this.globalExtensions) {
            extension.start();
        }
    }

    public void stopGlobalExtensions() {
        for (IGlobalExtension extension : this.globalExtensions) {
            extension.stop();
        }
    }

    private void injectConfiguration(Field field, String name, Object extension) {
        Object config = this.getOrCreateConfiguration(field.getType(), name, extension);
        field.setAccessible(true);
        try {
            field.set(extension, config);
        }
        catch (IllegalAccessException e) {
            throw new UnreachableCodeError();
        }
    }

    private Object getOrCreateConfiguration(Class<?> type, String name, Object extension) {
        Object config = this.configurationsByType.get(type);
        if (config == null) {
            config = this.createConfiguration(type, extension);
            this.configurationsByType.put(type, config);
            this.configurationsByName.put(name, config);
        }
        return config;
    }

    private Object createConfiguration(Class<?> type, Object extension) {
        if (!(extension instanceof IGlobalExtension)) {
            throw new ExtensionException("Extension '%s' references unknown configuration class '%s'").withArgs(extension.getClass(), type);
        }
        return this.createConfiguration(type);
    }

    @NotNull
    private Object createConfiguration(Class<?> type) {
        try {
            return type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            throw new ExtensionException("Cannot instantiate configuration class %s", e).withArgs(type);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new ExtensionException("Configuration class '%s' has no public no-arg constructor", e).withArgs(type);
        }
        catch (Exception e) {
            throw new ExtensionException("Failed to instantiate configuration '%s'", e).withArgs(type.getName());
        }
    }
}

