/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.util.Optional;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.hierarchical.Node;
import org.spockframework.runtime.ErrorInfoCollector;
import org.spockframework.runtime.PlatformParameterizedSpecRunner;
import org.spockframework.runtime.SpockExecutionContext;
import org.spockframework.runtime.SpockNode;
import org.spockframework.runtime.model.ISkippable;
import org.spockframework.runtime.model.SpecInfo;
import spock.config.RunnerConfiguration;

public class SpecNode
extends SpockNode<SpecInfo> {
    protected SpecNode(UniqueId uniqueId, RunnerConfiguration configuration, SpecInfo specInfo) {
        super(uniqueId, specInfo.getName(), (TestSource)ClassSource.from((Class)((Class)specInfo.getReflection())), configuration, specInfo);
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.CONTAINER;
    }

    public SpockExecutionContext prepare(SpockExecutionContext context) throws Exception {
        if (((SpecInfo)this.getNodeInfo()).isSkipped()) {
            return context;
        }
        PlatformParameterizedSpecRunner specRunner = context.getRunContext().createSpecRunner((SpecInfo)this.getNodeInfo());
        ErrorInfoCollector errorInfoCollector = new ErrorInfoCollector();
        context = context.withErrorInfoCollector(errorInfoCollector);
        context = context.withRunner(specRunner).withSpec((SpecInfo)this.getNodeInfo());
        context = specRunner.runSharedSpec(context);
        errorInfoCollector.assertEmpty();
        return context;
    }

    public Node.SkipResult shouldBeSkipped(SpockExecutionContext context) throws Exception {
        return this.shouldBeSkipped((ISkippable)this.getNodeInfo());
    }

    public SpockExecutionContext before(SpockExecutionContext context) throws Exception {
        ErrorInfoCollector errorInfoCollector = new ErrorInfoCollector();
        context = context.withErrorInfoCollector(errorInfoCollector);
        context.getRunner().runSetupSpec(context);
        errorInfoCollector.assertEmpty();
        return context;
    }

    public void after(SpockExecutionContext context) throws Exception {
        ErrorInfoCollector errorInfoCollector = new ErrorInfoCollector();
        context = context.withErrorInfoCollector(errorInfoCollector);
        context.getRunner().runCleanupSpec(context);
        errorInfoCollector.assertEmpty();
    }

    public void around(SpockExecutionContext context, Node.Invocation<SpockExecutionContext> invocation) throws Exception {
        context.getRunner().runSpec(context, () -> this.sneakyInvoke(invocation, context));
    }

    @Override
    public Node.ExecutionMode getExecutionMode() {
        return this.getExplicitExecutionMode().orElseGet(() -> SpecNode.toExecutionMode(this.getConfiguration().parallel.defaultSpecificationExecutionMode));
    }

    @Override
    protected Optional<Node.ExecutionMode> getDefaultChildExecutionMode() {
        return ((SpecInfo)this.getNodeInfo()).getChildExecutionMode().map(SpockNode::toExecutionMode);
    }
}

