/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension.builtin;

import org.spockframework.runtime.DataVariablesIterationNameProvider;
import org.spockframework.runtime.InvalidSpecException;
import org.spockframework.runtime.extension.AbstractGlobalExtension;
import org.spockframework.runtime.extension.builtin.UnrollConfiguration;
import org.spockframework.runtime.extension.builtin.UnrollIterationNameProvider;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.IterationInfo;
import org.spockframework.runtime.model.MethodInfo;
import org.spockframework.runtime.model.NameProvider;
import org.spockframework.runtime.model.SpecInfo;
import spock.lang.Rollup;
import spock.lang.Unroll;

public class UnrollExtension
extends AbstractGlobalExtension {
    private UnrollConfiguration unrollConfiguration;

    @Override
    public void visitSpec(SpecInfo spec) {
        String specUnrollPattern;
        boolean doUnrollSpec;
        boolean rollupSpec;
        Unroll unroll = spec.getAnnotation(Unroll.class);
        boolean unrollSpec = unroll != null;
        boolean bl = rollupSpec = spec.getAnnotation(Rollup.class) != null;
        if (unrollSpec && rollupSpec) {
            throw new InvalidSpecException("@Unroll and @Rollup must not be used on the same spec: " + spec.getName());
        }
        if (unrollSpec) {
            doUnrollSpec = true;
            specUnrollPattern = unroll.value();
        } else if (rollupSpec) {
            doUnrollSpec = false;
            specUnrollPattern = "";
        } else {
            doUnrollSpec = this.unrollConfiguration.unrollByDefault;
            specUnrollPattern = "";
        }
        spec.getFeatures().stream().filter(FeatureInfo::isParameterized).forEach(feature -> this.visitFeature((FeatureInfo)feature, doUnrollSpec, specUnrollPattern));
        SpecInfo superSpec = spec.getSuperSpec();
        if (superSpec != null) {
            this.visitSpec(superSpec);
        }
    }

    private void visitFeature(FeatureInfo feature, boolean doUnrollSpec, String specUnrollPattern) {
        String featureUnrollPattern;
        boolean doUnrollFeature;
        boolean rollupFeature;
        MethodInfo featureMethod = feature.getFeatureMethod();
        Unroll unroll = featureMethod.getAnnotation(Unroll.class);
        boolean unrollFeature = unroll != null;
        boolean bl = rollupFeature = featureMethod.getAnnotation(Rollup.class) != null;
        if (unrollFeature && rollupFeature) {
            throw new InvalidSpecException("@Unroll and @Rollup must not be used on the same feature: " + feature.getName());
        }
        if (unrollFeature) {
            doUnrollFeature = true;
            featureUnrollPattern = unroll.value();
        } else if (rollupFeature) {
            doUnrollFeature = false;
            featureUnrollPattern = "";
        } else {
            doUnrollFeature = doUnrollSpec;
            featureUnrollPattern = "";
        }
        feature.setReportIterations(doUnrollFeature);
        feature.setIterationNameProvider(doUnrollFeature ? this.chooseNameProvider(specUnrollPattern, featureUnrollPattern, feature) : null);
    }

    private NameProvider<IterationInfo> chooseNameProvider(String specUnrollPattern, String featureUnrollPattern, FeatureInfo feature) {
        if (!featureUnrollPattern.isEmpty()) {
            return new UnrollIterationNameProvider(feature, featureUnrollPattern, this.unrollConfiguration.validateExpressions);
        }
        if (feature.getName().contains("#")) {
            return new UnrollIterationNameProvider(feature, feature.getName(), this.unrollConfiguration.validateExpressions);
        }
        if (!specUnrollPattern.isEmpty()) {
            return new UnrollIterationNameProvider(feature, specUnrollPattern, this.unrollConfiguration.validateExpressions);
        }
        if (this.unrollConfiguration.defaultPattern != null) {
            return new UnrollIterationNameProvider(feature, this.unrollConfiguration.defaultPattern, this.unrollConfiguration.validateExpressions);
        }
        return new DataVariablesIterationNameProvider();
    }
}

