/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.spockframework.runtime.model.TextPosition;
import org.spockframework.runtime.model.TextRegion;
import org.spockframework.util.ReflectionUtil;

public class ExpressionInfo
implements Iterable<ExpressionInfo> {
    public static final String TEXT_NOT_AVAILABLE = "(n/a)";
    public static final Object VALUE_NOT_AVAILABLE = new Object(){

        public String toString() {
            return ExpressionInfo.TEXT_NOT_AVAILABLE;
        }
    };
    private TextRegion region;
    private TextPosition anchor;
    private final String operation;
    private final List<ExpressionInfo> children;
    private String text;
    private Object value;
    private String renderedValue;
    private boolean relevant = true;

    public ExpressionInfo(TextRegion region, TextPosition anchor, String operation, List<ExpressionInfo> children) {
        this.region = region;
        this.anchor = anchor;
        this.operation = operation;
        this.children = children;
    }

    public ExpressionInfo(TextRegion region, TextPosition anchor, String operation, ExpressionInfo ... children) {
        this(region, anchor, operation, Arrays.asList(children));
    }

    public TextRegion getRegion() {
        return this.region;
    }

    public TextPosition getAnchor() {
        return this.anchor;
    }

    public String getOperation() {
        return this.operation;
    }

    public List<ExpressionInfo> getChildren() {
        return this.children;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Object getValue() {
        return this.value;
    }

    public ExpressionInfo setValue(Object value) {
        this.value = value;
        return this;
    }

    public String getRenderedValue() {
        return this.renderedValue;
    }

    public void setRenderedValue(String renderedValue) {
        this.renderedValue = renderedValue;
    }

    public String getEffectiveRenderedValue() {
        return this.renderedValue != null ? this.renderedValue : this.text;
    }

    public boolean isRelevant() {
        return this.relevant && this.value != VALUE_NOT_AVAILABLE;
    }

    public ExpressionInfo setRelevant(boolean relevant) {
        this.relevant = relevant;
        return this;
    }

    public void shiftVertically(int numLines) {
        this.region = this.region.shiftVertically(numLines);
        this.anchor = this.anchor.shiftVertically(numLines);
    }

    @Override
    public Iterator<ExpressionInfo> iterator() {
        ArrayList<ExpressionInfo> list = new ArrayList<ExpressionInfo>();
        this.collectPrefix(list, false);
        return list.iterator();
    }

    public Iterable<ExpressionInfo> inPrefixOrder(boolean skipIrrelevant) {
        return () -> {
            ArrayList<ExpressionInfo> list = new ArrayList<ExpressionInfo>();
            this.collectPrefix(list, skipIrrelevant);
            return list.iterator();
        };
    }

    public List<ExpressionInfo> inPostfixOrder(boolean skipIrrelevant) {
        ArrayList<ExpressionInfo> list = new ArrayList<ExpressionInfo>();
        this.collectPostfix(list, skipIrrelevant);
        return list;
    }

    public Iterable<ExpressionInfo> inCustomOrder(boolean skipIrrelevant, Comparator<ExpressionInfo> comparator) {
        ArrayList<ExpressionInfo> list = new ArrayList<ExpressionInfo>();
        this.collectPrefix(list, skipIrrelevant);
        list.sort(comparator);
        return list;
    }

    public boolean isEqualityComparison() {
        return "==".equals(this.operation) && this.children.size() == 2;
    }

    public boolean isInstanceOfComparison() {
        return "instanceof".equals(this.operation) && this.children.size() == 2;
    }

    public boolean isEqualityComparison(Class<?> ... types) {
        if (!this.isEqualityComparison()) {
            return false;
        }
        if (!ReflectionUtil.hasAnyOfTypes(this.children.get(0).getValue(), types)) {
            return false;
        }
        return ReflectionUtil.hasAnyOfTypes(this.children.get(1).getValue(), types);
    }

    private void collectPrefix(List<ExpressionInfo> collector, boolean skipIrrelevant) {
        if (!skipIrrelevant || this.isRelevant()) {
            collector.add(this);
        }
        for (ExpressionInfo expr : this.children) {
            expr.collectPrefix(collector, skipIrrelevant);
        }
    }

    private void collectPostfix(List<ExpressionInfo> collector, boolean skipIrrelevant) {
        for (ExpressionInfo expr : this.children) {
            expr.collectPostfix(collector, skipIrrelevant);
        }
        if (!skipIrrelevant || this.isRelevant()) {
            collector.add(this);
        }
    }
}

