/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.mock.runtime;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.spockframework.mock.IMockConfiguration;
import org.spockframework.mock.IResponseGenerator;
import org.spockframework.mock.ISpockMockObject;
import org.spockframework.mock.runtime.IProxyBasedMockInterceptor;
import org.spockframework.mock.runtime.MockController;
import org.spockframework.mock.runtime.MockInvocation;
import org.spockframework.mock.runtime.MockObject;
import org.spockframework.mock.runtime.StaticMockMethod;
import org.spockframework.runtime.GroovyRuntimeUtil;
import spock.lang.Specification;

public class JavaMockInterceptor
implements IProxyBasedMockInterceptor {
    private final IMockConfiguration mockConfiguration;
    private Specification specification;
    private MockController fallbackMockController;
    private final MetaClass mockMetaClass;

    public JavaMockInterceptor(IMockConfiguration mockConfiguration, Specification specification, MetaClass mockMetaClass) {
        this.mockConfiguration = mockConfiguration;
        this.specification = specification;
        this.mockMetaClass = mockMetaClass;
    }

    @Override
    public Object intercept(Object target, Method method, Object[] arguments, IResponseGenerator realMethodInvoker) {
        MockObject mockObject = new MockObject(this.mockConfiguration.getName(), this.mockConfiguration.getExactType(), target, this.mockConfiguration.isVerified(), false, this.mockConfiguration.getDefaultResponse(), this.specification, this);
        if (method.getDeclaringClass() == ISpockMockObject.class) {
            return mockObject;
        }
        Object[] args = GroovyRuntimeUtil.asArgumentArray(arguments);
        if (target instanceof GroovyObject) {
            Throwable throwable;
            StackTraceElement mockCaller;
            if (this.isMethod(method, "getMetaClass", new Class[0])) {
                return this.mockMetaClass;
            }
            if (this.isMethod(method, "setProperty", String.class, Object.class) && ("org.codehaus.groovy.runtime.ScriptBytecodeAdapter".equals((mockCaller = (throwable = new Throwable()).getStackTrace()[3]).getClassName()) || "org.codehaus.groovy.runtime.InvokerHelper".equals(mockCaller.getClassName()))) {
                String methodName = GroovyRuntimeUtil.propertyToMethodName("set", (String)args[0]);
                return GroovyRuntimeUtil.invokeMethod(target, methodName, GroovyRuntimeUtil.asArgumentArray(args[1]));
            }
            if (!(!this.isMethod(method, "getProperty", String.class) || (mockCaller = (throwable = new Throwable()).getStackTrace()[3]).getClassName().startsWith("groovy.lang.GroovyObject$getProperty") && "call".equals(mockCaller.getMethodName()))) {
                String methodName = GroovyRuntimeUtil.propertyToMethodName("get", (String)args[0]);
                return GroovyRuntimeUtil.invokeMethod(target, methodName, new Object[0]);
            }
        }
        StaticMockMethod mockMethod = new StaticMockMethod(method, this.mockConfiguration.getExactType());
        MockInvocation invocation = new MockInvocation(mockObject, mockMethod, Arrays.asList(args), realMethodInvoker);
        MockController mockController = this.specification == null ? this.getFallbackMockController() : this.specification.getSpecificationContext().getMockController();
        return mockController.handle(invocation);
    }

    private boolean isMethod(Method method, String name, Class<?> ... parameterTypes) {
        return method.getName().equals(name) && Arrays.equals(method.getParameterTypes(), parameterTypes);
    }

    @Override
    public void attach(Specification specification) {
        this.specification = specification;
    }

    @Override
    public void detach() {
        this.specification = null;
    }

    public MockController getFallbackMockController() {
        if (this.fallbackMockController == null) {
            this.fallbackMockController = new MockController();
        }
        return this.fallbackMockController;
    }
}

