/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension.builtin;

import groovy.lang.MissingPropertyException;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import spock.util.environment.Jvm;
import spock.util.environment.OperatingSystem;

public class PreconditionContext {
    private final Object theInstance;
    private final Map<String, Object> dataVariables = new HashMap<String, Object>();

    public PreconditionContext() {
        this(null, Collections.emptyMap());
    }

    public PreconditionContext(Map<String, Object> dataVariables) {
        this(null, dataVariables);
    }

    public PreconditionContext(Object instance) {
        this(instance, Collections.emptyMap());
    }

    public PreconditionContext(Object instance, Map<String, Object> dataVariables) {
        this.theInstance = instance;
        this.dataVariables.putAll(dataVariables);
    }

    public Object propertyMissing(String propertyName) {
        if (this.dataVariables.containsKey(propertyName)) {
            return this.dataVariables.get(propertyName);
        }
        if (this.theInstance != null && "instance".equals(propertyName)) {
            return this.theInstance;
        }
        throw new MissingPropertyException(propertyName, this.getClass());
    }

    public Map<String, String> getEnv() {
        return System.getenv();
    }

    public Properties getSys() {
        return System.getProperties();
    }

    @Deprecated
    public Properties getProperties() {
        return this.getSys();
    }

    public OperatingSystem getOs() {
        return OperatingSystem.getCurrent();
    }

    public Jvm getJvm() {
        return Jvm.getCurrent();
    }

    public BigDecimal getJavaVersion() {
        String version = System.getProperty("java.specification.version");
        return new BigDecimal(version);
    }
}

