/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension.builtin;

import java.io.File;
import java.nio.file.Path;
import org.spockframework.runtime.InvalidSpecException;
import org.spockframework.runtime.extension.IAnnotationDrivenExtension;
import org.spockframework.runtime.extension.builtin.TempDirInterceptor;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.FieldInfo;
import org.spockframework.runtime.model.SpecInfo;
import org.spockframework.tempdir.TempDirConfiguration;
import spock.lang.TempDir;

public class TempDirExtension
implements IAnnotationDrivenExtension<TempDir> {
    private TempDirConfiguration configuration;

    @Override
    public void visitFieldAnnotation(TempDir annotation, FieldInfo field) {
        Class<Comparable<File>> fieldType = field.getType();
        if (!fieldType.isAssignableFrom(File.class) && !fieldType.isAssignableFrom(Path.class)) {
            throw new InvalidSpecException("@TempDir can only be used on File, Path or untyped field");
        }
        TempDirInterceptor interceptor = new TempDirInterceptor(fieldType, field, this.configuration.baseDir, this.configuration.keep);
        SpecInfo specInfo = (SpecInfo)field.getParent();
        if (field.isShared()) {
            specInfo.addInterceptor(interceptor);
        } else {
            for (FeatureInfo featureInfo : specInfo.getAllFeatures()) {
                featureInfo.addIterationInterceptor(interceptor);
            }
        }
    }
}

