/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.platform.engine.TestDescriptor;
import org.spockframework.runtime.GroovyRuntimeUtil;
import org.spockframework.runtime.IRunSupervisor;
import org.spockframework.runtime.IterationNode;
import org.spockframework.runtime.ParameterizedFeatureChildExecutor;
import org.spockframework.runtime.PlatformSpecRunner;
import org.spockframework.runtime.SpockExecutionContext;
import org.spockframework.runtime.SpockExecutionException;
import org.spockframework.runtime.model.DataProviderInfo;
import org.spockframework.runtime.model.ErrorInfo;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.IterationInfo;
import org.spockframework.runtime.model.MethodInfo;
import org.spockframework.runtime.model.SpecInfo;
import spock.config.RunnerConfiguration;

public class PlatformParameterizedSpecRunner
extends PlatformSpecRunner {
    public PlatformParameterizedSpecRunner(IRunSupervisor supervisor) {
        super(supervisor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void runParameterizedFeature(SpockExecutionContext context, ParameterizedFeatureChildExecutor childExecutor) throws InterruptedException {
        if (context.getErrorInfoCollector().hasErrors()) {
            return;
        }
        Object[] dataProviders = this.createDataProviders(context);
        int numIterations = this.estimateNumIterations(context, dataProviders);
        Iterator[] iterators = this.createIterators(context, dataProviders);
        this.runIterations(context, childExecutor, iterators, numIterations);
        try {
            childExecutor.awaitFinished();
        }
        finally {
            this.closeDataProviders(dataProviders);
        }
    }

    private Object[] createDataProviders(SpockExecutionContext context) {
        if (context.getErrorInfoCollector().hasErrors()) {
            return null;
        }
        List<DataProviderInfo> dataProviderInfos = context.getCurrentFeature().getDataProviders();
        if (dataProviderInfos.isEmpty()) {
            return new Object[0];
        }
        List<String> dataProviderVariables = dataProviderInfos.stream().map(DataProviderInfo::getDataVariables).flatMap(Collection::stream).collect(Collectors.toList());
        Object[] dataProviders = new Object[dataProviderInfos.size()];
        int size = dataProviderInfos.size();
        for (int i = 0; i < size; ++i) {
            DataProviderInfo dataProviderInfo = dataProviderInfos.get(i);
            MethodInfo method = dataProviderInfo.getDataProviderMethod();
            Object provider = this.invokeRaw(context, context.getCurrentInstance(), method, this.getPreviousDataTableProviders(dataProviderVariables, dataProviders, dataProviderInfo));
            if (context.getErrorInfoCollector().hasErrors()) {
                if (provider == null) break;
                dataProviders[i] = provider;
                break;
            }
            if (provider == null) {
                SpockExecutionException error = new SpockExecutionException("Data provider is null!");
                this.supervisor.error(context.getErrorInfoCollector(), new ErrorInfo(method, error));
                break;
            }
            dataProviders[i] = provider;
        }
        return dataProviders;
    }

    private Object[] getPreviousDataTableProviders(List<String> dataProviderVariables, Object[] dataProviders, DataProviderInfo dataProviderInfo) {
        ArrayList<Object> result = new ArrayList<Object>();
        block0: for (String previousDataTableVariable : dataProviderInfo.getPreviousDataTableVariables()) {
            int size = dataProviderVariables.size();
            for (int i = 0; i < size; ++i) {
                String dataProviderVariable = dataProviderVariables.get(i);
                if (!previousDataTableVariable.equals(dataProviderVariable)) continue;
                result.add(dataProviders[i]);
                continue block0;
            }
            throw new IllegalStateException(String.format("Variable name not defined (%s not in %s)!", previousDataTableVariable, dataProviderVariables));
        }
        return result.toArray();
    }

    private Iterator[] createIterators(SpockExecutionContext context, Object[] dataProviders) {
        if (context.getErrorInfoCollector().hasErrors()) {
            return null;
        }
        Iterator[] iterators = new Iterator[dataProviders.length];
        for (int i = 0; i < dataProviders.length; ++i) {
            try {
                Iterator<Object> iter = GroovyRuntimeUtil.asIterator(dataProviders[i]);
                if (iter == null) {
                    this.supervisor.error(context.getErrorInfoCollector(), new ErrorInfo(context.getCurrentFeature().getDataProviders().get(i).getDataProviderMethod(), new SpockExecutionException("Data provider's iterator() method returned null")));
                    return null;
                }
                iterators[i] = iter;
                continue;
            }
            catch (Throwable t) {
                this.supervisor.error(context.getErrorInfoCollector(), new ErrorInfo(context.getCurrentFeature().getDataProviders().get(i).getDataProviderMethod(), t));
                return null;
            }
        }
        return iterators;
    }

    private int estimateNumIterations(SpockExecutionContext context, Object[] dataProviders) {
        if (context.getErrorInfoCollector().hasErrors()) {
            return -1;
        }
        if (dataProviders.length == 0) {
            return 1;
        }
        int result = Integer.MAX_VALUE;
        for (Object prov : dataProviders) {
            int size;
            Object rawSize;
            if (prov instanceof Iterator || !((rawSize = GroovyRuntimeUtil.invokeMethodQuietly(prov, "size", new Object[0])) instanceof Number) || (size = ((Number)rawSize).intValue()) < 0 || size >= result) continue;
            result = size;
        }
        return result == Integer.MAX_VALUE ? -1 : result;
    }

    private void runIterations(SpockExecutionContext context, ParameterizedFeatureChildExecutor childExecutor, Iterator[] iterators, int estimatedNumIterations) {
        if (context.getErrorInfoCollector().hasErrors()) {
            return;
        }
        int iterationIndex = 0;
        while (this.haveNext(context, iterators)) {
            IterationInfo iterationInfo = this.createIterationInfo(context, iterationIndex, this.nextArgs(context, iterators), estimatedNumIterations);
            IterationNode iterationNode = new IterationNode(context.getParentId().append("iteration", String.valueOf(iterationIndex++)), context.getRunContext().getConfiguration(RunnerConfiguration.class), iterationInfo);
            if (context.getErrorInfoCollector().hasErrors()) {
                return;
            }
            childExecutor.execute((TestDescriptor)iterationNode);
            if (iterators.length != 0) continue;
            break;
        }
    }

    private void closeDataProviders(Object[] dataProviders) {
        if (dataProviders == null) {
            return;
        }
        for (Object provider : dataProviders) {
            GroovyRuntimeUtil.invokeMethodQuietly(provider, "close", new Object[0]);
        }
    }

    private boolean haveNext(SpockExecutionContext context, Iterator[] iterators) {
        if (context.getErrorInfoCollector().hasErrors()) {
            return false;
        }
        boolean haveNext = true;
        for (int i = 0; i < iterators.length; ++i) {
            try {
                boolean hasNext = iterators[i].hasNext();
                if (i == 0) {
                    haveNext = hasNext;
                    continue;
                }
                if (haveNext == hasNext) continue;
                DataProviderInfo provider = context.getCurrentFeature().getDataProviders().get(i);
                this.supervisor.error(context.getErrorInfoCollector(), new ErrorInfo(provider.getDataProviderMethod(), this.createDifferentNumberOfDataValuesException(provider, hasNext)));
                return false;
            }
            catch (Throwable t) {
                this.supervisor.error(context.getErrorInfoCollector(), new ErrorInfo(context.getCurrentFeature().getDataProviders().get(i).getDataProviderMethod(), t));
                return false;
            }
        }
        return haveNext;
    }

    private SpockExecutionException createDifferentNumberOfDataValuesException(DataProviderInfo provider, boolean hasNext) {
        String msg = String.format("Data provider for variable '%s' has %s values than previous data provider(s)", provider.getDataVariables().get(0), hasNext ? "more" : "fewer");
        SpockExecutionException exception = new SpockExecutionException(msg);
        FeatureInfo feature = (FeatureInfo)provider.getParent();
        SpecInfo spec = (SpecInfo)feature.getParent();
        StackTraceElement elem = new StackTraceElement(((Class)spec.getReflection()).getName(), feature.getName(), spec.getFilename(), provider.getLine());
        exception.setStackTrace(new StackTraceElement[]{elem});
        return exception;
    }

    private Object[] nextArgs(SpockExecutionContext context, Iterator[] iterators) {
        if (context.getErrorInfoCollector().hasErrors()) {
            return null;
        }
        Object[] next = new Object[iterators.length];
        for (int i = 0; i < iterators.length; ++i) {
            try {
                next[i] = iterators[i].next();
                continue;
            }
            catch (Throwable t) {
                this.supervisor.error(context.getErrorInfoCollector(), new ErrorInfo(context.getCurrentFeature().getDataProviders().get(i).getDataProviderMethod(), t));
                return null;
            }
        }
        try {
            return (Object[])this.invokeRaw(context, context.getSharedInstance(), context.getCurrentFeature().getDataProcessorMethod(), next);
        }
        catch (Throwable t) {
            this.supervisor.error(context.getErrorInfoCollector(), new ErrorInfo(context.getCurrentFeature().getDataProcessorMethod(), t));
            return null;
        }
    }
}

