/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension.builtin;

import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.List;
import org.opentest4j.MultipleFailuresError;
import org.spockframework.runtime.extension.IMethodInterceptor;
import org.spockframework.runtime.extension.IMethodInvocation;
import org.spockframework.runtime.extension.builtin.RetryBaseInterceptor;
import org.spockframework.runtime.model.MethodInfo;
import spock.lang.Retry;

public class RetryIterationInterceptor
extends RetryBaseInterceptor
implements IMethodInterceptor {
    private final IterationState iterationState = new IterationState();

    public RetryIterationInterceptor(Retry retry, MethodInfo featureMethod) {
        super(retry);
        featureMethod.addInterceptor(new InnerRetryInterceptor(retry, this.condition));
    }

    @Override
    public void intercept(IMethodInvocation invocation) throws Throwable {
        this.iterationState.startIteration();
        for (int i = 0; i <= this.retry.count(); ++i) {
            this.iterationState.setRetryAttempt(i);
            invocation.proceed();
            if (this.iterationState.notFailed()) break;
            if (this.retry.delay() <= 0) continue;
            Thread.sleep(this.retry.delay());
        }
    }

    private class IterationState {
        private final ThreadLocal<Boolean> finalIteration = ThreadLocal.withInitial(() -> false);
        private final ThreadLocal<List<Throwable>> throwables = new ThreadLocal();

        private IterationState() {
        }

        void startIteration() {
            this.throwables.set(new ArrayList());
        }

        void setRetryAttempt(int retryAttempt) {
            this.finalIteration.set(retryAttempt == RetryIterationInterceptor.this.retry.count());
        }

        void failIteration(Throwable failure) {
            this.throwables.get().add(failure);
            if (this.finalIteration.get().booleanValue()) {
                throw new MultipleFailuresError("Retries exhausted", this.throwables.get());
            }
        }

        boolean notFailed() {
            return this.throwables.get().isEmpty();
        }
    }

    private class InnerRetryInterceptor
    extends RetryBaseInterceptor
    implements IMethodInterceptor {
        public InnerRetryInterceptor(Retry retry, Closure condition) {
            super(retry, condition);
        }

        @Override
        public void intercept(IMethodInvocation invocation) throws Throwable {
            try {
                invocation.proceed();
                RetryIterationInterceptor.this.iterationState.startIteration();
            }
            catch (Throwable e) {
                if (this.isExpected(invocation, e)) {
                    RetryIterationInterceptor.this.iterationState.failIteration(e);
                }
                throw e;
            }
        }
    }
}

