/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.model;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.spockframework.runtime.IFeatureFilter;
import org.spockframework.runtime.IFeatureSortOrder;
import org.spockframework.runtime.IMethodNameMapper;
import org.spockframework.runtime.IRunListener;
import org.spockframework.runtime.extension.IMethodInterceptor;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.FieldInfo;
import org.spockframework.runtime.model.MethodInfo;
import org.spockframework.runtime.model.NodeInfo;
import org.spockframework.runtime.model.SpecElementInfo;
import org.spockframework.runtime.model.parallel.ExclusiveResource;
import org.spockframework.runtime.model.parallel.ExecutionMode;
import org.spockframework.util.CollectionUtil;
import org.spockframework.util.InternalIdentifiers;

public class SpecInfo
extends SpecElementInfo<NodeInfo, Class<?>>
implements IMethodNameMapper {
    private final List<FieldInfo> fields = new ArrayList<FieldInfo>();
    private final List<IMethodInterceptor> setupInterceptors = new ArrayList<IMethodInterceptor>();
    private final List<IMethodInterceptor> cleanupInterceptors = new ArrayList<IMethodInterceptor>();
    private final List<IMethodInterceptor> setupSpecInterceptors = new ArrayList<IMethodInterceptor>();
    private final List<IMethodInterceptor> cleanupSpecInterceptors = new ArrayList<IMethodInterceptor>();
    private final List<IMethodInterceptor> sharedInitializerInterceptors = new ArrayList<IMethodInterceptor>();
    private final List<IMethodInterceptor> initializerInterceptors = new ArrayList<IMethodInterceptor>();
    private final List<IRunListener> listeners = new ArrayList<IRunListener>();
    private final Set<ExclusiveResource> exclusiveResources = new HashSet<ExclusiveResource>();
    private ExecutionMode executionMode = null;
    private ExecutionMode childExecutionMode = null;
    private String pkg;
    private String filename;
    private String narrative;
    private SpecInfo superSpec;
    private SpecInfo subSpec;
    private List<SpecInfo> specsTopToBottom;
    private List<SpecInfo> specsBottomToTop;
    private MethodInfo initializerMethod;
    private MethodInfo sharedInitializerMethod;
    private final List<MethodInfo> setupMethods = new ArrayList<MethodInfo>();
    private final List<MethodInfo> cleanupMethods = new ArrayList<MethodInfo>();
    private final List<MethodInfo> setupSpecMethods = new ArrayList<MethodInfo>();
    private final List<MethodInfo> cleanupSpecMethods = new ArrayList<MethodInfo>();
    private final List<FeatureInfo> features = new ArrayList<FeatureInfo>();

    public String getPackage() {
        return this.pkg;
    }

    public void setPackage(String pkg) {
        this.pkg = pkg;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getNarrative() {
        return this.narrative;
    }

    public void setNarrative(String narrative) {
        this.narrative = narrative;
    }

    public SpecInfo getSuperSpec() {
        return this.superSpec;
    }

    public void setSuperSpec(SpecInfo superSpec) {
        this.superSpec = superSpec;
    }

    public SpecInfo getSubSpec() {
        return this.subSpec;
    }

    public void setSubSpec(SpecInfo subSpec) {
        this.subSpec = subSpec;
    }

    public SpecInfo getTopSpec() {
        SpecInfo curr = this;
        while (curr.getSuperSpec() != null) {
            curr = curr.getSuperSpec();
        }
        return curr;
    }

    public boolean getIsTopSpec() {
        return this.superSpec == null;
    }

    public SpecInfo getBottomSpec() {
        SpecInfo curr = this;
        while (curr.getSubSpec() != null) {
            curr = curr.getSubSpec();
        }
        return curr;
    }

    public boolean getIsBottomSpec() {
        return this.subSpec == null;
    }

    public List<SpecInfo> getSpecsTopToBottom() {
        if (this.specsTopToBottom == null) {
            this.specsTopToBottom = new ArrayList<SpecInfo>();
            for (SpecInfo curr = this.getTopSpec(); curr != null; curr = curr.getSubSpec()) {
                this.specsTopToBottom.add(curr);
            }
        }
        return this.specsTopToBottom;
    }

    public List<SpecInfo> getSpecsBottomToTop() {
        if (this.specsBottomToTop == null) {
            this.specsBottomToTop = new ArrayList<SpecInfo>();
            for (SpecInfo curr = this.getBottomSpec(); curr != null; curr = curr.getSuperSpec()) {
                this.specsBottomToTop.add(curr);
            }
        }
        return this.specsBottomToTop;
    }

    public MethodInfo getInitializerMethod() {
        return this.initializerMethod;
    }

    public void setInitializerMethod(MethodInfo initializerMethod) {
        this.initializerMethod = initializerMethod;
    }

    public MethodInfo getSharedInitializerMethod() {
        return this.sharedInitializerMethod;
    }

    public void setSharedInitializerMethod(MethodInfo sharedInitializerMethod) {
        this.sharedInitializerMethod = sharedInitializerMethod;
    }

    public List<MethodInfo> getSetupMethods() {
        return this.setupMethods;
    }

    public void addSetupMethod(MethodInfo setupMethod) {
        this.setupMethods.add(setupMethod);
    }

    public List<MethodInfo> getCleanupMethods() {
        return this.cleanupMethods;
    }

    public void addCleanupMethod(MethodInfo cleanupMethod) {
        this.cleanupMethods.add(cleanupMethod);
    }

    public List<MethodInfo> getSetupSpecMethods() {
        return this.setupSpecMethods;
    }

    public void addSetupSpecMethod(MethodInfo setupSpecMethod) {
        this.setupSpecMethods.add(setupSpecMethod);
    }

    public List<MethodInfo> getCleanupSpecMethods() {
        return this.cleanupSpecMethods;
    }

    public void addCleanupSpecMethod(MethodInfo cleanupSpecMethod) {
        this.cleanupSpecMethods.add(cleanupSpecMethod);
    }

    public Iterable<MethodInfo> getFixtureMethods() {
        return CollectionUtil.concat(this.setupSpecMethods, this.setupMethods, this.cleanupMethods, this.cleanupSpecMethods);
    }

    public Iterable<MethodInfo> getAllFixtureMethods() {
        if (this.superSpec == null) {
            return this.getFixtureMethods();
        }
        return CollectionUtil.concat(this.superSpec.getAllFixtureMethods(), this.getFixtureMethods());
    }

    public List<FieldInfo> getFields() {
        return this.fields;
    }

    public List<FieldInfo> getAllFields() {
        if (this.superSpec == null) {
            return this.fields;
        }
        ArrayList<FieldInfo> result = new ArrayList<FieldInfo>(this.superSpec.getAllFields());
        result.addAll(this.fields);
        return result;
    }

    public void addField(FieldInfo field) {
        this.fields.add(field);
    }

    public List<FeatureInfo> getFeatures() {
        return this.features;
    }

    public List<FeatureInfo> getAllFeatures() {
        if (this.superSpec == null) {
            return this.features;
        }
        ArrayList<FeatureInfo> result = new ArrayList<FeatureInfo>(this.superSpec.getAllFeatures());
        result.addAll(this.features);
        return result;
    }

    public List<FeatureInfo> getAllFeaturesInExecutionOrder() {
        List<FeatureInfo> result = this.getAllFeatures();
        result.sort(Comparator.comparingInt(FeatureInfo::getExecutionOrder));
        return result;
    }

    public void addFeature(FeatureInfo feature) {
        this.features.add(feature);
    }

    public List<IMethodInterceptor> getSetupInterceptors() {
        return this.setupInterceptors;
    }

    public void addSetupInterceptor(IMethodInterceptor interceptor) {
        this.setupInterceptors.add(interceptor);
    }

    public List<IMethodInterceptor> getCleanupInterceptors() {
        return this.cleanupInterceptors;
    }

    public void addCleanupInterceptor(IMethodInterceptor interceptor) {
        this.cleanupInterceptors.add(interceptor);
    }

    public List<IMethodInterceptor> getSetupSpecInterceptors() {
        return this.setupSpecInterceptors;
    }

    public void addSetupSpecInterceptor(IMethodInterceptor interceptor) {
        this.setupSpecInterceptors.add(interceptor);
    }

    public List<IMethodInterceptor> getCleanupSpecInterceptors() {
        return this.cleanupSpecInterceptors;
    }

    public void addCleanupSpecInterceptor(IMethodInterceptor interceptor) {
        this.cleanupSpecInterceptors.add(interceptor);
    }

    public List<IMethodInterceptor> getSharedInitializerInterceptors() {
        return this.sharedInitializerInterceptors;
    }

    public void addSharedInitializerInterceptor(IMethodInterceptor interceptor) {
        this.sharedInitializerInterceptors.add(interceptor);
    }

    public List<IMethodInterceptor> getInitializerInterceptors() {
        return this.initializerInterceptors;
    }

    public void addInitializerInterceptor(IMethodInterceptor interceptor) {
        this.initializerInterceptors.add(interceptor);
    }

    public List<IRunListener> getListeners() {
        return this.listeners;
    }

    public void addListener(IRunListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void addExclusiveResource(ExclusiveResource exclusiveResource) {
        this.exclusiveResources.add(exclusiveResource);
    }

    @Override
    public Set<ExclusiveResource> getExclusiveResources() {
        return this.exclusiveResources;
    }

    @Override
    public void setExecutionMode(ExecutionMode executionMode) {
        this.executionMode = executionMode;
    }

    @Override
    public Optional<ExecutionMode> getExecutionMode() {
        return Optional.ofNullable(this.executionMode);
    }

    public Optional<ExecutionMode> getChildExecutionMode() {
        return Optional.ofNullable(this.childExecutionMode);
    }

    public void setChildExecutionMode(ExecutionMode childExecutionMode) {
        this.childExecutionMode = childExecutionMode;
    }

    public void filterFeatures(IFeatureFilter filter) {
        for (FeatureInfo feature : this.getAllFeatures()) {
            if (filter.matches(feature)) continue;
            feature.setExcluded(true);
        }
    }

    public void sortFeatures(IFeatureSortOrder order) {
        List<FeatureInfo> features = this.getAllFeatures();
        features.sort(order);
        for (int i = 0; i < features.size(); ++i) {
            features.get(i).setExecutionOrder(i);
        }
    }

    @Override
    public boolean isInitializerOrFixtureMethod(String className, String methodName) {
        if (!InternalIdentifiers.INITIALIZER_AND_FIXTURE_METHODS.contains(methodName)) {
            return false;
        }
        for (SpecInfo spec : this.getSpecsBottomToTop()) {
            if (!((Class)spec.getReflection()).getName().equals(className)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toFeatureName(String methodName) {
        for (FeatureInfo feature : this.getAllFeatures()) {
            if (!feature.hasBytecodeName(methodName)) continue;
            return feature.getName();
        }
        return methodName;
    }
}

