/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.spockframework.util.IMultiset;
import org.spockframework.util.InternalSpockError;

public abstract class AbstractMultiset<E>
implements IMultiset<E> {
    private final Map<E, Integer> elements;

    public AbstractMultiset(Map<E, Integer> elements) {
        this.elements = elements;
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    @Override
    public boolean contains(Object element) {
        return this.elements.containsKey(element);
    }

    @Override
    public Iterator<E> iterator() {
        return this.elements.keySet().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.elements.keySet().toArray();
    }

    @Override
    public <T> T[] toArray(T[] array) {
        return this.elements.keySet().toArray(array);
    }

    @Override
    public boolean add(E element) {
        this.elements.merge(element, 1, Integer::sum);
        return true;
    }

    @Override
    public boolean remove(Object element) {
        Integer count = this.elements.get(element);
        if (count == null) {
            return false;
        }
        if (count == 0) {
            throw new InternalSpockError("MultiSet element count is zero");
        }
        if (count == 1) {
            this.elements.remove(element);
        } else {
            this.elements.put(element, count - 1);
        }
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object element : collection) {
            if (this.elements.containsKey(element)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        if (collection.isEmpty()) {
            return false;
        }
        for (E element : collection) {
            this.add(element);
        }
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean changed = false;
        Iterator<E> iterator = this.elements.keySet().iterator();
        while (iterator.hasNext()) {
            E next = iterator.next();
            if (collection.contains(next)) continue;
            iterator.remove();
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean changed = false;
        for (Object element : collection) {
            changed |= this.elements.remove(element) != null;
        }
        return changed;
    }

    @Override
    public void clear() {
        this.elements.clear();
    }

    @Override
    public int count(E element) {
        Integer count = this.elements.get(element);
        return count == null ? 0 : count;
    }

    @Override
    public Set<Map.Entry<E, Integer>> entrySet() {
        return this.elements.entrySet();
    }
}

