/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.lang.reflect.Method;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.ClassSelector;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.engine.discovery.IterationSelector;
import org.junit.platform.engine.discovery.MethodSelector;
import org.junit.platform.engine.discovery.UniqueIdSelector;
import org.junit.platform.engine.support.discovery.SelectorResolver;
import org.spockframework.runtime.SpecNode;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.IterationFilter;
import org.spockframework.runtime.model.SpecInfo;

public class MethodSelectorResolver
implements SelectorResolver {
    public SelectorResolver.Resolution resolve(MethodSelector selector, SelectorResolver.Context context) {
        String methodName = selector.getMethodName();
        Predicate<FeatureInfo> filter = feature -> MethodSelectorResolver.reflectionNameOrMethodNameEquals(methodName, feature);
        ClassSelector parentSelector = DiscoverySelectors.selectClass((Class)selector.getJavaClass());
        return this.resolveAllowingAllIndexes(context, (DiscoverySelector)parentSelector, filter);
    }

    public SelectorResolver.Resolution resolve(UniqueIdSelector selector, SelectorResolver.Context context) {
        UniqueId uniqueId = selector.getUniqueId();
        UniqueId.Segment lastSegment = uniqueId.getLastSegment();
        if ("feature".equals(lastSegment.getType())) {
            String methodName = lastSegment.getValue();
            return this.resolveAllowingAllIndexes(context, (DiscoverySelector)DiscoverySelectors.selectUniqueId((UniqueId)uniqueId.removeLastSegment()), feature -> methodName.equals(((Method)feature.getFeatureMethod().getReflection()).getName()));
        }
        if ("iteration".equals(lastSegment.getType())) {
            int index = Integer.parseInt(lastSegment.getValue());
            UniqueId featureMethodUniqueId = uniqueId.removeLastSegment();
            String methodName = featureMethodUniqueId.getLastSegment().getValue();
            return this.resolveWithIterationFilter(context, (DiscoverySelector)DiscoverySelectors.selectUniqueId((UniqueId)featureMethodUniqueId.removeLastSegment()), feature -> methodName.equals(((Method)feature.getFeatureMethod().getReflection()).getName()), iterationFilter -> iterationFilter.allow(index));
        }
        return SelectorResolver.Resolution.unresolved();
    }

    public SelectorResolver.Resolution resolve(IterationSelector selector, SelectorResolver.Context context) {
        if (selector.getParentSelector() instanceof MethodSelector) {
            MethodSelector methodSelector = (MethodSelector)selector.getParentSelector();
            return this.resolveWithIterationFilter(context, (DiscoverySelector)DiscoverySelectors.selectClass((Class)methodSelector.getJavaClass()), feature -> MethodSelectorResolver.reflectionNameOrMethodNameEquals(methodSelector.getMethodName(), feature), iterationFilter -> selector.getIterationIndices().forEach(iterationFilter::allow));
        }
        return super.resolve(selector, context);
    }

    private SelectorResolver.Resolution resolveAllowingAllIndexes(SelectorResolver.Context context, DiscoverySelector parentSelector, Predicate<FeatureInfo> featureFilter) {
        return this.resolveWithIterationFilter(context, parentSelector, featureFilter, IterationFilter::allowAll);
    }

    private SelectorResolver.Resolution resolveWithIterationFilter(SelectorResolver.Context context, DiscoverySelector parentSelector, Predicate<FeatureInfo> featureFilter, Consumer<IterationFilter> iterationFilterAdjuster) {
        return this.resolve(context, parentSelector, featureFilter, testDescriptor -> {
            ((SpecInfo)((SpecNode)((Object)testDescriptor)).getNodeInfo()).getAllFeatures().stream().filter(featureFilter).findAny().map(FeatureInfo::getIterationFilter).ifPresent(iterationFilterAdjuster);
            return SelectorResolver.Match.partial((TestDescriptor)testDescriptor);
        });
    }

    private SelectorResolver.Resolution resolve(SelectorResolver.Context context, DiscoverySelector parentSelector, Predicate<FeatureInfo> filter, Function<TestDescriptor, SelectorResolver.Match> matchCreator) {
        return context.resolve(parentSelector).map(testDescriptor -> this.handle((TestDescriptor)testDescriptor, filter)).map(descriptor -> SelectorResolver.Resolution.match((SelectorResolver.Match)((SelectorResolver.Match)matchCreator.apply((TestDescriptor)descriptor)))).orElseGet(SelectorResolver.Resolution::unresolved);
    }

    private TestDescriptor handle(TestDescriptor testDescriptor, Predicate<FeatureInfo> filter) {
        if (testDescriptor instanceof SpecNode) {
            SpecNode specNode = (SpecNode)testDescriptor;
            long count = ((SpecInfo)specNode.getNodeInfo()).getAllFeaturesInExecutionOrder().stream().filter(filter).peek(featureInfo -> featureInfo.setExcluded(false)).count();
            return count == 0L ? null : testDescriptor;
        }
        return null;
    }

    private static boolean reflectionNameOrMethodNameEquals(String methodName, FeatureInfo feature) {
        return ((Method)feature.getFeatureMethod().getReflection()).getName().equals(methodName) || methodName.equals(feature.getName());
    }
}

