/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.hierarchical.EngineExecutionContext;
import org.junit.platform.engine.support.hierarchical.Node;
import org.spockframework.runtime.ErrorInfoCollector;
import org.spockframework.runtime.FeatureNode;
import org.spockframework.runtime.IterationNode;
import org.spockframework.runtime.SpockExecutionContext;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.ISkippable;
import spock.config.RunnerConfiguration;

public class SimpleFeatureNode
extends FeatureNode {
    private final IterationNode delegate;

    public SimpleFeatureNode(UniqueId uniqueId, RunnerConfiguration configuration, FeatureInfo featureInfo, IterationNode delegate) {
        super(uniqueId, featureInfo.getDisplayName(), (TestSource)SimpleFeatureNode.featureToMethodSource(featureInfo), configuration, featureInfo);
        this.delegate = delegate;
    }

    @Override
    public TestDescriptor.Type getType() {
        return this.delegate.getType();
    }

    public SpockExecutionContext prepare(SpockExecutionContext context) throws Exception {
        return this.delegate.prepare(context.withCurrentFeature((FeatureInfo)this.getNodeInfo()));
    }

    public SpockExecutionContext before(SpockExecutionContext context) throws Exception {
        context = (SpockExecutionContext)super.before((EngineExecutionContext)context);
        ErrorInfoCollector errorInfoCollector = new ErrorInfoCollector();
        context = context.withErrorInfoCollector(errorInfoCollector);
        context.getRunner().runSetup(context);
        errorInfoCollector.assertEmpty();
        return context;
    }

    @Override
    public void around(SpockExecutionContext context, Node.Invocation<SpockExecutionContext> invocation) {
        super.around(context, (Node.Invocation<SpockExecutionContext>)((Node.Invocation)ctx -> this.delegate.around((SpockExecutionContext)ctx, invocation)));
    }

    public SpockExecutionContext execute(SpockExecutionContext context, Node.DynamicTestExecutor dynamicTestExecutor) throws Exception {
        this.verifyNotSkipped((ISkippable)this.getNodeInfo());
        this.delegate.execute(context, dynamicTestExecutor);
        return context;
    }

    public void after(SpockExecutionContext context) throws Exception {
        ErrorInfoCollector errorInfoCollector = new ErrorInfoCollector();
        context = context.withErrorInfoCollector(errorInfoCollector);
        this.delegate.after(context);
        errorInfoCollector.assertEmpty();
        super.after((EngineExecutionContext)context);
    }

    public void nodeFinished(SpockExecutionContext context, TestDescriptor testDescriptor, TestExecutionResult result) {
        this.delegate.nodeFinished(context, testDescriptor, result);
        super.nodeFinished((EngineExecutionContext)context, testDescriptor, result);
    }

    public void nodeSkipped(SpockExecutionContext context, TestDescriptor testDescriptor, Node.SkipResult result) {
        this.delegate.nodeSkipped(context, testDescriptor, result);
        super.nodeSkipped((EngineExecutionContext)context, testDescriptor, result);
    }

    @Override
    public Node.SkipResult shouldBeSkipped(SpockExecutionContext context) throws Exception {
        return this.delegate.shouldBeSkipped(context);
    }
}

