/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension;

import java.util.Arrays;
import java.util.List;
import org.spockframework.runtime.IDataIterator;
import org.spockframework.runtime.extension.IIterationRunner;
import org.spockframework.runtime.model.MethodInfo;
import org.spockframework.runtime.model.ParameterInfo;

public interface IDataDriver {
    public static final IDataDriver DEFAULT = (dataIterator, iterationRunner, parameters) -> {
        while (dataIterator.hasNext()) {
            Object[] arguments = (Object[])dataIterator.next();
            if (arguments == null) continue;
            iterationRunner.runIteration(IDataDriver.prepareArgumentArray(arguments, parameters));
        }
    };

    public void runIterations(IDataIterator var1, IIterationRunner var2, List<ParameterInfo> var3);

    public static Object[] prepareArgumentArray(Object[] arguments, List<ParameterInfo> parameters) {
        int parameterCount = parameters.size();
        if (arguments.length == parameterCount) {
            return arguments;
        }
        Object[] methodArguments = new Object[parameterCount];
        System.arraycopy(arguments, 0, methodArguments, 0, arguments.length);
        Arrays.fill(methodArguments, arguments.length, parameterCount, MethodInfo.MISSING_ARGUMENT);
        return methodArguments;
    }
}

