/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension.builtin;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import spock.util.environment.Jvm;
import spock.util.environment.OperatingSystem;

public class PreconditionContext {
    private final Object theSharedInstance;
    private final Object theInstance;
    private final Map<String, Object> dataVariables;

    public PreconditionContext() {
        this(null, null, Collections.emptyMap());
    }

    public PreconditionContext(Object sharedInstance, Object instance, Map<String, Object> dataVariables) {
        this.theSharedInstance = sharedInstance;
        this.theInstance = instance;
        this.dataVariables = new StrictHashMap<String, Object>(dataVariables);
    }

    public Map<String, String> getEnv() {
        return System.getenv();
    }

    public Properties getSys() {
        return System.getProperties();
    }

    public OperatingSystem getOs() {
        return OperatingSystem.getCurrent();
    }

    public Jvm getJvm() {
        return Jvm.getCurrent();
    }

    public Object getInstance() {
        if (this.theInstance == null) {
            throw new InstanceContextException();
        }
        return this.theInstance;
    }

    public Object getShared() {
        if (this.theSharedInstance == null) {
            throw new SharedContextException();
        }
        return this.theSharedInstance;
    }

    public Map<String, Object> getData() {
        return this.dataVariables;
    }

    public BigDecimal getJavaVersion() {
        String version = System.getProperty("java.specification.version");
        return new BigDecimal(version);
    }

    public static class DataVariableContextException
    extends PreconditionContextException {
        private final String dataVariable;

        public DataVariableContextException(String dataVariable) {
            this.dataVariable = dataVariable;
        }

        public String getDataVariable() {
            return this.dataVariable;
        }
    }

    public static class InstanceContextException
    extends PreconditionContextException {
    }

    public static class SharedContextException
    extends PreconditionContextException {
    }

    public static class PreconditionContextException
    extends RuntimeException {
    }

    private static class StrictHashMap<K, V>
    extends HashMap<K, V> {
        public StrictHashMap(Map<K, V> map) {
            super(map);
        }

        @Override
        public V get(Object key) {
            if (!this.containsKey(key)) {
                throw new DataVariableContextException(key.toString());
            }
            return super.get(key);
        }

        @Override
        public V put(K key, V value) {
            throw new UnsupportedOperationException("Unmodifiable");
        }
    }
}

