/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension.builtin;

import groovy.lang.Closure;
import java.util.Collections;
import java.util.List;
import org.opentest4j.TestAbortedException;
import org.spockframework.runtime.extension.IMethodInvocation;
import org.spockframework.runtime.extension.builtin.ConditionalExtension;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.SpecInfo;
import spock.lang.Requires;

public class RequiresExtension
extends ConditionalExtension<Requires> {
    private static final String DEFAULT_MESSAGE = "Ignored via @" + Requires.class.getSimpleName();

    @Override
    protected Class<? extends Closure> getConditionClass(Requires annotation) {
        return annotation.value();
    }

    @Override
    protected void specConditionResult(boolean result, Requires annotation, SpecInfo spec) {
        if (result) {
            return;
        }
        List<SpecInfo> specsToSkip = annotation.inherited() ? spec.getSpecsCurrentToBottom() : Collections.singletonList(spec);
        specsToSkip.forEach(toSkip -> toSkip.skip(RequiresExtension.ignoredMessage(annotation)));
    }

    @Override
    protected void featureConditionResult(boolean result, Requires annotation, FeatureInfo feature) {
        if (!result) {
            feature.skip(RequiresExtension.ignoredMessage(annotation));
        }
    }

    @Override
    protected void iterationConditionResult(boolean result, Requires annotation, IMethodInvocation invocation) {
        if (!result) {
            throw new TestAbortedException(RequiresExtension.ignoredMessage(annotation));
        }
    }

    private static String ignoredMessage(Requires annotation) {
        String reason = annotation.reason();
        if (reason.isEmpty()) {
            return DEFAULT_MESSAGE;
        }
        return DEFAULT_MESSAGE + ": " + reason;
    }
}

