/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.compiler;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.AttributeExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BitwiseNegationExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ClosureListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.ElvisOperatorExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.LambdaExpression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.MethodPointerExpression;
import org.codehaus.groovy.ast.expr.MethodReferenceExpression;
import org.codehaus.groovy.ast.expr.NamedArgumentListExpression;
import org.codehaus.groovy.ast.expr.NotExpression;
import org.codehaus.groovy.ast.expr.PostfixExpression;
import org.codehaus.groovy.ast.expr.PrefixExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.RangeExpression;
import org.codehaus.groovy.ast.expr.SpreadExpression;
import org.codehaus.groovy.ast.expr.SpreadMapExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TernaryExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.UnaryMinusExpression;
import org.codehaus.groovy.ast.expr.UnaryPlusExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.AssertStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;
import org.codehaus.groovy.classgen.BytecodeExpression;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.syntax.Types;
import org.spockframework.compat.groovy2.GroovyCodeVisitorCompat;
import org.spockframework.compiler.AstUtil;
import org.spockframework.compiler.IRewriteResources;
import org.spockframework.compiler.OldValueExpression;
import org.spockframework.util.AbstractExpressionConverter;
import org.spockframework.util.Assert;
import org.spockframework.util.Identifiers;
import org.spockframework.util.ReflectionUtil;
import org.spockframework.util.TextUtil;

public class ConditionRewriter
extends AbstractExpressionConverter<Expression>
implements GroovyCodeVisitorCompat {
    private static final Pattern COMMENTS_PATTERN = Pattern.compile("/\\*.*?\\*/|//.*$");
    private static final String THROWABLE = "$spock_condition_throwable";
    private static final Constructor<RangeExpression> RANGE_EXPRESSION_CONSTRUCTOR_GROOVY_4 = ReflectionUtil.getDeclaredConstructorBySignature(RangeExpression.class, Expression.class, Expression.class, Boolean.TYPE, Boolean.TYPE);
    private static final Method RANGE_EXPRESSION_IS_EXCLUSIVE_LEFT = ReflectionUtil.getDeclaredMethodBySignature(RangeExpression.class, "isExclusiveLeft", new Class[0]);
    private static final Method RANGE_EXPRESSION_IS_EXCLUSIVE_RIGHT = ReflectionUtil.getDeclaredMethodBySignature(RangeExpression.class, "isExclusiveRight", new Class[0]);
    private final IRewriteResources resources;
    private final String valueRecorderName;
    private final String errorCollectorName;
    private int recordCount = 0;

    private ConditionRewriter(IRewriteResources resources, String valueRecorderSuffix, String errorCollectorSuffix) {
        this.resources = resources;
        this.valueRecorderName = "$spock_valueRecorder" + valueRecorderSuffix;
        this.errorCollectorName = "$spock_errorCollector" + errorCollectorSuffix;
    }

    public static Statement rewriteExplicitCondition(AssertStatement stat, IRewriteResources resources) {
        return ConditionRewriter.rewriteExplicitCondition(stat, resources, "", "");
    }

    public static Statement rewriteExplicitCondition(AssertStatement stat, IRewriteResources resources, String valueRecorderSuffix, String errorCollectorSuffix) {
        ConditionRewriter rewriter = new ConditionRewriter(resources, valueRecorderSuffix, errorCollectorSuffix);
        Expression message = AstUtil.getAssertionMessage(stat);
        return rewriter.rewriteCondition((Statement)stat, stat.getBooleanExpression().getExpression(), message, true);
    }

    public static Statement rewriteImplicitCondition(ExpressionStatement stat, IRewriteResources resources) {
        return ConditionRewriter.rewriteImplicitCondition(stat, resources, "", "");
    }

    public static Statement rewriteImplicitCondition(ExpressionStatement stat, IRewriteResources resources, String valueRecorderSuffix, String errorCollectorSuffix) {
        ConditionRewriter rewriter = new ConditionRewriter(resources, valueRecorderSuffix, errorCollectorSuffix);
        return rewriter.rewriteCondition((Statement)stat, stat.getExpression(), null, false);
    }

    public void visitMethodCallExpression(MethodCallExpression expr) {
        boolean objectExprSeenAsMethodNameAtRuntime = !expr.isImplicitThis() && expr.getObjectExpression() instanceof VariableExpression && "call".equals(expr.getMethodAsString()) && (!AstUtil.hasPlausibleSourcePosition((ASTNode)expr.getMethod()) || expr.getMethod().getColumnNumber() == expr.getObjectExpression().getColumnNumber());
        MethodCallExpression conversion = new MethodCallExpression(expr.isImplicitThis() ? expr.getObjectExpression() : (Expression)this.convert(expr.getObjectExpression()), objectExprSeenAsMethodNameAtRuntime ? expr.getMethod() : (Expression)this.convert(expr.getMethod()), (Expression)this.convert(expr.getArguments()));
        conversion.setSafe(expr.isSafe());
        conversion.setSpreadSafe(expr.isSpreadSafe());
        conversion.setSourcePosition((ASTNode)expr);
        this.result = this.record((Expression)conversion);
    }

    public void visitStaticMethodCallExpression(StaticMethodCallExpression expr) {
        StaticMethodCallExpression conversion = new StaticMethodCallExpression(expr.getOwnerType(), this.recordNa(expr.getMethod()), (Expression)this.convert(expr.getArguments()));
        conversion.setSourcePosition((ASTNode)expr);
        conversion.setMetaMethod(expr.getMetaMethod());
        this.result = this.record((Expression)conversion);
    }

    public void visitBytecodeExpression(BytecodeExpression expr) {
        this.unsupported();
    }

    public void visitArgumentlistExpression(ArgumentListExpression expr) {
        ArgumentListExpression conversion = new ArgumentListExpression(this.convertAll(expr.getExpressions()));
        conversion.setSourcePosition((ASTNode)expr);
        this.result = this.recordNa(conversion);
    }

    public void visitPropertyExpression(PropertyExpression expr) {
        PropertyExpression conversion = new PropertyExpression(expr.isImplicitThis() ? expr.getObjectExpression() : (Expression)this.convert(expr.getObjectExpression()), expr.getProperty(), expr.isSafe());
        conversion.setSourcePosition((ASTNode)expr);
        conversion.setSpreadSafe(expr.isSpreadSafe());
        conversion.setStatic(expr.isStatic());
        conversion.setImplicitThis(expr.isImplicitThis());
        this.result = this.record((Expression)conversion);
    }

    public void visitAttributeExpression(AttributeExpression expr) {
        AttributeExpression conversion = new AttributeExpression(expr.isImplicitThis() ? expr.getObjectExpression() : (Expression)this.convert(expr.getObjectExpression()), expr.getProperty(), expr.isSafe());
        conversion.setSourcePosition((ASTNode)expr);
        conversion.setSpreadSafe(expr.isSpreadSafe());
        conversion.setStatic(expr.isStatic());
        conversion.setImplicitThis(expr.isImplicitThis());
        this.result = this.record((Expression)conversion);
    }

    public void visitFieldExpression(FieldExpression expr) {
        this.result = this.record((Expression)expr);
    }

    public void visitMethodPointerExpression(MethodPointerExpression expr) {
        MethodPointerExpression conversion = new MethodPointerExpression((Expression)this.convert(expr.getExpression()), (Expression)this.convert(expr.getMethodName()));
        conversion.setSourcePosition((ASTNode)expr);
        this.result = this.record((Expression)conversion);
    }

    @Override
    public void visitMethodReferenceExpression(MethodReferenceExpression expr) {
        this.visitMethodPointerExpression((MethodPointerExpression)expr);
    }

    public void visitVariableExpression(VariableExpression expr) {
        if (expr instanceof OldValueExpression) {
            Expression originalExpr = ((OldValueExpression)expr).getOriginalExpression();
            originalExpr.visit((GroovyCodeVisitor)this);
            this.result = expr;
            return;
        }
        this.result = this.record((Expression)expr);
    }

    public void visitDeclarationExpression(DeclarationExpression expr) {
        this.unsupported();
    }

    public void visitBinaryExpression(BinaryExpression expr) {
        BinaryExpression conversion;
        Expression convertedLeftExpression = Types.ofType((int)expr.getOperation().getType(), (int)1100) ? this.convertAndRecordNa(expr.getLeftExpression()) : (Expression)this.convert(expr.getLeftExpression());
        Expression convertedRightExpression = (Expression)this.convert(expr.getRightExpression());
        Object object = conversion = Types.ofType((int)expr.getOperation().getType(), (int)544) ? AstUtil.createDirectMethodCall(convertedRightExpression, this.resources.getAstNodeCache().Class_IsInstance, convertedLeftExpression) : new BinaryExpression(convertedLeftExpression, expr.getOperation(), convertedRightExpression);
        if (this.isSpecialCollectionCondition((Expression)conversion)) {
            conversion = this.transformSpecialCollectionCondition((Expression)conversion);
        }
        conversion.setSourcePosition((ASTNode)expr);
        this.result = this.record((Expression)conversion);
    }

    public void visitConstantExpression(ConstantExpression expr) {
        this.result = this.record((Expression)expr);
    }

    public void visitClassExpression(ClassExpression expr) {
        this.result = expr;
        if (!AstUtil.hasPlausibleSourcePosition((ASTNode)expr)) {
            return;
        }
        String text = COMMENTS_PATTERN.matcher(this.resources.getSourceText((ASTNode)expr)).replaceAll("");
        this.recordCount += text == null ? 0 : TextUtil.countOccurrences(text, '.');
        this.result = this.record((Expression)expr);
    }

    public void visitUnaryMinusExpression(UnaryMinusExpression expr) {
        UnaryMinusExpression conversion = new UnaryMinusExpression((Expression)this.convert(expr.getExpression()));
        conversion.setSourcePosition((ASTNode)expr);
        this.result = this.record((Expression)conversion);
    }

    public void visitUnaryPlusExpression(UnaryPlusExpression expr) {
        UnaryPlusExpression conversion = new UnaryPlusExpression((Expression)this.convert(expr.getExpression()));
        conversion.setSourcePosition((ASTNode)expr);
        this.result = this.record((Expression)conversion);
    }

    public void visitBitwiseNegationExpression(BitwiseNegationExpression expr) {
        BitwiseNegationExpression conversion = new BitwiseNegationExpression((Expression)this.convert(expr.getExpression()));
        conversion.setSourcePosition((ASTNode)expr);
        this.result = this.record((Expression)conversion);
    }

    public void visitCastExpression(CastExpression expr) {
        CastExpression conversion = new CastExpression(expr.getType(), (Expression)this.convert(expr.getExpression()), expr.isIgnoringAutoboxing());
        conversion.setSourcePosition((ASTNode)expr);
        conversion.setCoerce(expr.isCoerce());
        this.result = this.record((Expression)conversion);
    }

    public void visitClosureListExpression(ClosureListExpression expr) {
        this.unsupported();
    }

    public void visitNotExpression(NotExpression expr) {
        NotExpression conversion = new NotExpression((Expression)this.convert(expr.getExpression()));
        conversion.setSourcePosition((ASTNode)expr);
        this.result = this.record((Expression)conversion);
    }

    public void visitListExpression(ListExpression expr) {
        ListExpression conversion = new ListExpression(this.convertAll(expr.getExpressions()));
        conversion.setSourcePosition((ASTNode)expr);
        this.result = this.record((Expression)conversion);
    }

    public void visitRangeExpression(RangeExpression expr) {
        RangeExpression conversion = RANGE_EXPRESSION_CONSTRUCTOR_GROOVY_4 != null ? ReflectionUtil.newInstance(RANGE_EXPRESSION_CONSTRUCTOR_GROOVY_4, this.convert(expr.getFrom()), this.convert(expr.getTo()), ReflectionUtil.invokeMethod(expr, RANGE_EXPRESSION_IS_EXCLUSIVE_LEFT, new Object[0]), ReflectionUtil.invokeMethod(expr, RANGE_EXPRESSION_IS_EXCLUSIVE_RIGHT, new Object[0])) : new RangeExpression((Expression)this.convert(expr.getFrom()), (Expression)this.convert(expr.getTo()), expr.isInclusive());
        conversion.setSourcePosition((ASTNode)expr);
        this.result = this.record((Expression)conversion);
    }

    public void visitMapExpression(MapExpression expr) {
        boolean namedArgumentListExpr = expr instanceof NamedArgumentListExpression;
        NamedArgumentListExpression conversion = namedArgumentListExpr ? new NamedArgumentListExpression(this.convertAll(expr.getMapEntryExpressions())) : new MapExpression(this.convertAll(expr.getMapEntryExpressions()));
        conversion.setSourcePosition((ASTNode)expr);
        this.result = namedArgumentListExpr ? (Expression)this.recordNa(conversion) : this.record((Expression)conversion);
    }

    public void visitMapEntryExpression(MapEntryExpression expr) {
        MapEntryExpression conversion = new MapEntryExpression((Expression)this.convert(expr.getKeyExpression()), (Expression)this.convert(expr.getValueExpression()));
        conversion.setSourcePosition((ASTNode)expr);
        this.result = this.recordNa(conversion);
    }

    public void visitConstructorCallExpression(ConstructorCallExpression expr) {
        ConstructorCallExpression conversion = new ConstructorCallExpression(expr.getType(), (Expression)this.convert(expr.getArguments()));
        conversion.setSourcePosition((ASTNode)expr);
        conversion.setUsingAnonymousInnerClass(expr.isUsingAnonymousInnerClass());
        this.result = this.record((Expression)conversion);
    }

    public void visitGStringExpression(GStringExpression expr) {
        GStringExpression conversion = new GStringExpression(expr.getText(), expr.getStrings(), this.convertAll(expr.getValues()));
        conversion.setSourcePosition((ASTNode)expr);
        this.result = this.record((Expression)conversion);
    }

    public void visitArrayExpression(ArrayExpression expr) {
        ArrayExpression conversion = new ArrayExpression(expr.getElementType(), this.convertAll(expr.getExpressions()), expr.getSizeExpression() == null ? null : this.convertAll(expr.getSizeExpression()));
        conversion.setSourcePosition((ASTNode)expr);
        this.result = this.record((Expression)conversion);
    }

    public void visitSpreadExpression(SpreadExpression expr) {
        SpreadExpression conversion = new SpreadExpression((Expression)this.convert(expr.getExpression()));
        conversion.setSourcePosition((ASTNode)expr);
        this.result = this.recordNa(conversion);
    }

    public void visitSpreadMapExpression(SpreadMapExpression expr) {
        this.result = this.recordNa(expr);
    }

    public void visitTernaryExpression(TernaryExpression expr) {
        TernaryExpression conversion = new TernaryExpression(this.convertCompatibly(expr.getBooleanExpression()), (Expression)this.convert(expr.getTrueExpression()), (Expression)this.convert(expr.getFalseExpression()));
        conversion.setSourcePosition((ASTNode)expr);
        this.result = this.record((Expression)conversion);
    }

    public void visitShortTernaryExpression(ElvisOperatorExpression expr) {
        ElvisOperatorExpression conversion = new ElvisOperatorExpression((Expression)this.convert(expr.getTrueExpression()), (Expression)this.convert(expr.getFalseExpression()));
        conversion.setSourcePosition((ASTNode)expr);
        this.result = this.record((Expression)conversion);
    }

    public void visitPrefixExpression(PrefixExpression expr) {
        PrefixExpression conversion = new PrefixExpression(expr.getOperation(), this.convertAndRecordNa(expr.getExpression()));
        conversion.setSourcePosition((ASTNode)expr);
        this.result = this.record((Expression)conversion);
    }

    public void visitPostfixExpression(PostfixExpression expr) {
        PostfixExpression conversion = new PostfixExpression(this.convertAndRecordNa(expr.getExpression()), expr.getOperation());
        conversion.setSourcePosition((ASTNode)expr);
        this.result = this.record((Expression)conversion);
    }

    public void visitBooleanExpression(BooleanExpression expr) {
        BooleanExpression conversion = new BooleanExpression((Expression)this.convert(expr.getExpression()));
        conversion.setSourcePosition((ASTNode)expr);
        this.result = this.recordNa(conversion);
    }

    public void visitClosureExpression(ClosureExpression expr) {
        this.result = this.record((Expression)expr);
    }

    @Override
    public void visitLambdaExpression(LambdaExpression expr) {
        this.visitClosureExpression((ClosureExpression)expr);
    }

    public void visitTupleExpression(TupleExpression expr) {
        TupleExpression conversion = new TupleExpression(this.convertAllAndRecordNa(expr.getExpressions()));
        conversion.setSourcePosition((ASTNode)expr);
        this.result = this.recordNa(conversion);
    }

    private Expression record(Expression expr) {
        MethodCallExpression result = AstUtil.createDirectMethodCall((Expression)new VariableExpression(this.valueRecorderName), this.resources.getAstNodeCache().ValueRecorder_Record, (Expression)new ArgumentListExpression((Expression)AstUtil.createDirectMethodCall((Expression)new VariableExpression(this.valueRecorderName), this.resources.getAstNodeCache().ValueRecorder_StartRecordingValue, (Expression)new ArgumentListExpression((Expression)AstUtil.primitiveConstExpression(this.recordCount++))), expr));
        if (expr instanceof CastExpression) {
            return new CastExpression(expr.getType(), (Expression)result);
        }
        return result;
    }

    private Expression realizeNas(Expression expr) {
        return AstUtil.createDirectMethodCall((Expression)new VariableExpression(this.valueRecorderName), this.resources.getAstNodeCache().ValueRecorder_RealizeNas, (Expression)new ArgumentListExpression((Expression)AstUtil.primitiveConstExpression(this.recordCount), expr));
    }

    private <T> T recordNa(T expr) {
        ++this.recordCount;
        return expr;
    }

    private Expression convertAndRecordNa(Expression expr) {
        return this.unrecord((Expression)this.convert(expr));
    }

    private List<Expression> convertAllAndRecordNa(List<Expression> expressions) {
        ArrayList<Expression> conversions = new ArrayList<Expression>(expressions.size());
        for (Expression expr : expressions) {
            conversions.add(this.convertAndRecordNa(expr));
        }
        return conversions;
    }

    private <T extends Expression> T convertCompatibly(T expr) {
        Expression conversion = (Expression)this.convert(expr);
        Assert.that(expr.getClass().isInstance(conversion));
        return (T)conversion;
    }

    private Expression unrecord(Expression expr) {
        if (!(expr instanceof MethodCallExpression)) {
            return expr;
        }
        MethodCallExpression methodExpr = (MethodCallExpression)expr;
        Expression targetExpr = methodExpr.getObjectExpression();
        if (!(targetExpr instanceof VariableExpression)) {
            return expr;
        }
        VariableExpression var = (VariableExpression)targetExpr;
        if (!this.valueRecorderName.equals(var.getName())) {
            return expr;
        }
        if (!"record".equals(methodExpr.getMethodAsString())) {
            return expr;
        }
        return ((ArgumentListExpression)methodExpr.getArguments()).getExpression(1);
    }

    private int extractVariableNumber(Expression expr) {
        if (!(expr instanceof MethodCallExpression)) {
            return -1;
        }
        MethodCallExpression methodExpr = (MethodCallExpression)expr;
        Expression targetExpr = methodExpr.getObjectExpression();
        if (!(targetExpr instanceof VariableExpression)) {
            return -1;
        }
        VariableExpression var = (VariableExpression)targetExpr;
        if (!this.valueRecorderName.equals(var.getName())) {
            return -1;
        }
        if (!"record".equals(methodExpr.getMethodAsString())) {
            return -1;
        }
        Expression startRecordingEpr = ((ArgumentListExpression)methodExpr.getArguments()).getExpression(0);
        if (!(startRecordingEpr instanceof MethodCallExpression)) {
            return -1;
        }
        MethodCallExpression startRecording = (MethodCallExpression)startRecordingEpr;
        if (!"startRecordingValue".equals(startRecording.getMethodAsString())) {
            return -1;
        }
        Expression variableNumExpression = ((ArgumentListExpression)startRecording.getArguments()).getExpression(0);
        if (!(variableNumExpression instanceof ConstantExpression)) {
            return -1;
        }
        return (Integer)((ConstantExpression)variableNumExpression).getValue();
    }

    private Statement rewriteCondition(Statement conditionStat, Expression conditionExpr, Expression message, boolean explicit) {
        Statement result = this.rewriteCondition(conditionExpr, message, explicit);
        result.setSourcePosition((ASTNode)conditionStat);
        return result;
    }

    private Statement rewriteCondition(Expression expr, Expression message, boolean explicit) {
        boolean optOut = this.isOptOutExpression(expr);
        if (optOut) {
            expr = this.removeOptOutPrefix(expr);
            if (!explicit) {
                return new ExpressionStatement(expr);
            }
        }
        if (this.isSpecialCollectionCondition(expr)) {
            expr = this.transformSpecialCollectionCondition(expr);
        }
        if (expr instanceof MethodCallExpression && !((MethodCallExpression)expr).isSpreadSafe()) {
            MethodCallExpression methodCallExpression = (MethodCallExpression)expr;
            String methodName = AstUtil.getMethodName((Expression)methodCallExpression);
            if (Identifiers.CONDITION_METHODS.contains(methodName)) {
                return this.surroundSpecialTryCatch(expr);
            }
            return this.rewriteMethodCondition(methodCallExpression, message, explicit, optOut);
        }
        if (expr instanceof StaticMethodCallExpression) {
            return this.rewriteStaticMethodCondition((StaticMethodCallExpression)expr, message, explicit, optOut);
        }
        return this.rewriteOtherCondition(expr, message, optOut);
    }

    private boolean isOptOutExpression(Expression expr) {
        return expr instanceof NotExpression && ((NotExpression)expr).getExpression() instanceof NotExpression;
    }

    private Expression removeOptOutPrefix(Expression expr) {
        return ((NotExpression)((NotExpression)expr).getExpression()).getExpression();
    }

    private Statement rewriteMethodCondition(MethodCallExpression condition, Expression message, boolean explicit, boolean optOut) {
        int lastVariableNum;
        MethodCallExpression rewritten;
        if (explicit && optOut) {
            rewritten = condition;
            lastVariableNum = -1;
        } else {
            Expression converted = (Expression)this.convert((Expression)condition);
            rewritten = (MethodCallExpression)this.unrecord(converted);
            lastVariableNum = this.extractVariableNumber(converted);
        }
        ArrayList<Expression> args = new ArrayList<Expression>();
        args.add(rewritten.getObjectExpression());
        args.add(rewritten.getMethod());
        args.add(AstUtil.toArgumentArray(AstUtil.getArgumentList((Expression)rewritten), this.resources));
        args.add(this.realizeNas((Expression)AstUtil.primitiveConstExpression(rewritten.isSafe())));
        args.add((Expression)AstUtil.primitiveConstExpression(explicit));
        args.add((Expression)AstUtil.primitiveConstExpression(lastVariableNum));
        return this.surroundWithTryCatch((Expression)condition, message, this.rewriteToSpockRuntimeCall(this.resources.getAstNodeCache().SpockRuntime_VerifyMethodCondition, (Expression)condition, message, args, optOut), optOut);
    }

    private Statement rewriteStaticMethodCondition(StaticMethodCallExpression condition, Expression message, boolean explicit, boolean optOut) {
        int lastVariableNum;
        StaticMethodCallExpression rewritten;
        if (explicit && optOut) {
            rewritten = condition;
            lastVariableNum = -1;
        } else {
            Expression converted = (Expression)this.convert((Expression)condition);
            rewritten = (StaticMethodCallExpression)this.unrecord(converted);
            lastVariableNum = this.extractVariableNumber(converted);
        }
        ArrayList<Expression> args = new ArrayList<Expression>();
        args.add((Expression)new ClassExpression(rewritten.getOwnerType()));
        args.add((Expression)new ConstantExpression((Object)rewritten.getMethod()));
        args.add(AstUtil.toArgumentArray(AstUtil.getArgumentList((Expression)rewritten), this.resources));
        args.add(this.realizeNas((Expression)ConstantExpression.PRIM_FALSE));
        args.add((Expression)AstUtil.primitiveConstExpression(explicit));
        args.add((Expression)AstUtil.primitiveConstExpression(lastVariableNum));
        return this.surroundWithTryCatch((Expression)condition, message, this.rewriteToSpockRuntimeCall(this.resources.getAstNodeCache().SpockRuntime_VerifyMethodCondition, (Expression)condition, message, args, optOut), optOut);
    }

    private Statement rewriteOtherCondition(Expression condition, Expression message, boolean optOut) {
        Expression rewritten = optOut ? condition : (Expression)this.convert(condition);
        Expression executeAndVerify = this.rewriteToSpockRuntimeCall(this.resources.getAstNodeCache().SpockRuntime_VerifyCondition, condition, message, Collections.singletonList(rewritten), optOut);
        return this.surroundWithTryCatch(condition, message, executeAndVerify, optOut);
    }

    private Expression transformSpecialCollectionCondition(Expression condition) {
        BinaryExpression binaryExpression = (BinaryExpression)condition;
        Token operation = binaryExpression.getOperation();
        int operationType = operation.getType();
        if (operationType == 90) {
            MethodCallExpression result = AstUtil.createDirectMethodCall((Expression)new ClassExpression(this.resources.getAstNodeCache().SpockRuntime), this.resources.getAstNodeCache().SpockRuntime_MatchCollectionsAsSet, (Expression)new ArgumentListExpression(Arrays.asList(binaryExpression.getLeftExpression(), binaryExpression.getRightExpression())));
            result.setSourcePosition((ASTNode)condition);
            return result;
        }
        if (operationType == 94) {
            MethodCallExpression result = AstUtil.createDirectMethodCall((Expression)new ClassExpression(this.resources.getAstNodeCache().SpockRuntime), this.resources.getAstNodeCache().SpockRuntime_MatchCollectionsInAnyOrder, (Expression)new ArgumentListExpression(Arrays.asList(binaryExpression.getLeftExpression(), binaryExpression.getRightExpression())));
            result.setSourcePosition((ASTNode)condition);
            return result;
        }
        throw new IllegalStateException("This should never happen");
    }

    private boolean isSpecialCollectionCondition(Expression condition) {
        if (!(condition instanceof BinaryExpression)) {
            return false;
        }
        BinaryExpression binaryExpression = (BinaryExpression)condition;
        int operationType = binaryExpression.getOperation().getType();
        return (operationType == 94 || operationType == 90) && !this.isStringLikeExpression(binaryExpression.getLeftExpression()) && !this.isStringLikeExpression(binaryExpression.getRightExpression());
    }

    private boolean isStringLikeExpression(Expression expression) {
        if (expression instanceof ConstantExpression) {
            return expression.getType().getTypeClass() == String.class;
        }
        return expression instanceof GStringExpression;
    }

    private TryCatchStatement surroundWithTryCatch(Expression condition, Expression message, Expression executeAndVerify, boolean optOut) {
        TryCatchStatement tryCatchStatement = new TryCatchStatement((Statement)new ExpressionStatement(executeAndVerify), (Statement)EmptyStatement.INSTANCE);
        tryCatchStatement.addCatch(new CatchStatement(new Parameter(new ClassNode(Throwable.class), THROWABLE), (Statement)new ExpressionStatement((Expression)AstUtil.createDirectMethodCall((Expression)new ClassExpression(this.resources.getAstNodeCache().SpockRuntime), this.resources.getAstNodeCache().SpockRuntime_ConditionFailedWithException, (Expression)new ArgumentListExpression(Arrays.asList(new VariableExpression(this.errorCollectorName), optOut ? ConstantExpression.NULL : new VariableExpression(this.valueRecorderName), new ConstantExpression((Object)this.resources.getSourceText((ASTNode)condition)), AstUtil.primitiveConstExpression(condition.getLineNumber()), AstUtil.primitiveConstExpression(condition.getColumnNumber()), message == null ? ConstantExpression.NULL : message, new VariableExpression(THROWABLE)))))));
        return tryCatchStatement;
    }

    private TryCatchStatement surroundSpecialTryCatch(Expression executeAndVerify) {
        TryCatchStatement tryCatchStatement = new TryCatchStatement((Statement)new ExpressionStatement(executeAndVerify), (Statement)EmptyStatement.INSTANCE);
        tryCatchStatement.addCatch(new CatchStatement(new Parameter(new ClassNode(Throwable.class), THROWABLE), (Statement)new ExpressionStatement((Expression)AstUtil.createDirectMethodCall((Expression)new ClassExpression(this.resources.getAstNodeCache().SpockRuntime), this.resources.getAstNodeCache().SpockRuntime_GroupConditionFailedWithException, (Expression)new ArgumentListExpression(Arrays.asList(new VariableExpression(this.errorCollectorName), new VariableExpression(THROWABLE)))))));
        return tryCatchStatement;
    }

    private Expression rewriteToSpockRuntimeCall(MethodNode method, Expression condition, Expression message, List<Expression> additionalArgs, boolean optOut) {
        ArrayList<Object> args = new ArrayList<Object>();
        MethodCallExpression result = AstUtil.createDirectMethodCall((Expression)new ClassExpression(this.resources.getAstNodeCache().SpockRuntime), method, (Expression)new ArgumentListExpression(args));
        args.add(new VariableExpression(this.errorCollectorName, this.resources.getAstNodeCache().ErrorCollector));
        args.add(AstUtil.createDirectMethodCall((Expression)(optOut ? ConstantExpression.NULL : new VariableExpression(this.valueRecorderName)), this.resources.getAstNodeCache().ValueRecorder_Reset, (Expression)ArgumentListExpression.EMPTY_ARGUMENTS));
        args.add(new ConstantExpression((Object)this.resources.getSourceText((ASTNode)condition)));
        args.add(AstUtil.primitiveConstExpression(condition.getLineNumber()));
        args.add(AstUtil.primitiveConstExpression(condition.getColumnNumber()));
        args.add(message == null ? ConstantExpression.NULL : message);
        args.addAll(additionalArgs);
        result.setSourcePosition((ASTNode)condition);
        return result;
    }
}

