/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.compiler;

import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.AssertStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.spockframework.compiler.AbstractDeepBlockRewriter;
import org.spockframework.compiler.AstUtil;
import org.spockframework.compiler.ConditionRewriter;
import org.spockframework.compiler.ISpecRewriteResources;
import org.spockframework.compiler.InteractionRewriter;
import org.spockframework.compiler.InvalidSpecCompileException;
import org.spockframework.compiler.condition.ImplicitConditionsUtils;
import org.spockframework.compiler.model.Block;
import org.spockframework.compiler.model.ExpectBlock;
import org.spockframework.compiler.model.FilterBlock;
import org.spockframework.compiler.model.FixtureMethod;
import org.spockframework.compiler.model.Method;
import org.spockframework.compiler.model.ThenBlock;
import org.spockframework.util.Identifiers;

public class DeepBlockRewriter
extends AbstractDeepBlockRewriter {
    private final ISpecRewriteResources resources;
    private boolean insideInteraction = false;
    private int interactionClosureDepth = 0;
    private int closureDepth = 0;

    public DeepBlockRewriter(ISpecRewriteResources resources) {
        super(resources.getCurrentBlock(), resources.getAstNodeCache());
        this.resources = resources;
    }

    @Override
    public void visit(Block block) {
        super.visit(block);
    }

    public void visitAssertStatement(AssertStatement stat) {
        super.visitAssertStatement(stat);
        this.conditionFound();
        this.replaceVisitedStatementWith(ConditionRewriter.rewriteExplicitCondition(stat, this.resources, this.getValueRecorderSuffix(), this.getErrorCollectorSuffix()));
    }

    private String getValueRecorderSuffix() {
        return this.closureDepth == 0 ? "" : String.valueOf(this.closureDepth);
    }

    private String getErrorCollectorSuffix() {
        return this.groupConditionFound ? String.valueOf(this.closureDepth) : "";
    }

    @Override
    protected void doVisitExpressionStatement(ExpressionStatement stat) {
        boolean handled;
        InteractionRewriter rewriter = this.visitInteractionAwareExpressionStatement(stat);
        if ((!this.pastSpecialMethodCallStats.contains(stat) || this.currSpecialMethodCall.isConditionMethodCall() || this.currSpecialMethodCall.isGroupConditionBlock()) && !(handled = this.handleInteraction(rewriter, stat))) {
            this.handleImplicitCondition(stat);
        }
    }

    private InteractionRewriter visitInteractionAwareExpressionStatement(ExpressionStatement stat) {
        InteractionRewriter rewriter = new InteractionRewriter(this.resources, this.getCurrentWithOrMockClosure());
        if (this.isInteractionExpression(rewriter, stat)) {
            this.insideInteraction = true;
            super.doVisitExpressionStatement(stat);
            this.insideInteraction = false;
        } else {
            super.doVisitExpressionStatement(stat);
        }
        return rewriter;
    }

    @Override
    protected void doVisitBinaryExpression(BinaryExpression expression) {
        if (this.insideInteraction) {
            BinaryExpression binExpr;
            int type;
            BinaryExpression expr = expression;
            this.insideInteraction = false;
            boolean found = false;
            while (expr instanceof BinaryExpression && ((type = (binExpr = expr).getOperation().getType()) == 281 || type == 282)) {
                found = true;
                binExpr.getRightExpression().visit((GroovyCodeVisitor)this);
                expr = binExpr.getLeftExpression();
            }
            this.insideInteraction = true;
            if (found) {
                expr.visit((GroovyCodeVisitor)this);
            } else {
                super.doVisitBinaryExpression(expression);
            }
        } else {
            super.doVisitBinaryExpression(expression);
        }
    }

    @Override
    protected void doVisitClosureExpression(ClosureExpression expr) {
        if (this.insideInteraction) {
            ++this.interactionClosureDepth;
        }
        ++this.closureDepth;
        super.doVisitClosureExpression(expr);
        this.defineRecorders(expr);
        --this.closureDepth;
        if (this.insideInteraction) {
            --this.interactionClosureDepth;
        }
    }

    public void visitDeclarationExpression(DeclarationExpression expr) {
        this.visitBinaryExpression((BinaryExpression)expr);
    }

    @Override
    protected void doVisitMethodCallExpression(MethodCallExpression expr) {
        super.doVisitMethodCallExpression(expr);
        boolean handled = this.handleMockCall(expr) || this.handleThrownCall(expr) || this.handleOldCall(expr) || this.handleInteractionBlockCall(expr) || this.handleImplicitCallOnMethodParam(expr) || this.forbidUseOfSuperInFixtureMethod(expr);
    }

    private boolean handleImplicitCallOnMethodParam(MethodCallExpression expr) {
        Parameter[] params;
        if (!expr.isImplicitThis()) {
            return false;
        }
        String methodName = expr.getMethodAsString();
        for (Parameter param : params = ((MethodNode)this.resources.getCurrentMethod().getAst()).getParameters()) {
            if (!param.getName().equals(methodName)) continue;
            expr.setMethod((Expression)new ConstantExpression((Object)"call"));
            expr.setObjectExpression((Expression)new VariableExpression(methodName));
            return true;
        }
        return false;
    }

    private boolean handleInteraction(InteractionRewriter rewriter, ExpressionStatement stat) {
        ExpressionStatement interaction = rewriter.rewrite(stat);
        if (interaction == null) {
            return false;
        }
        if (this.block instanceof ExpectBlock) {
            this.resources.getErrorReporter().error((ASTNode)stat, "Interactions are not allowed in '%s' blocks. Put them before the '%s' block or into a 'then' block.", this.block.getName(), this.block.getName());
            return true;
        }
        this.replaceVisitedStatementWith((Statement)interaction);
        this.interactionFound = true;
        return true;
    }

    private boolean handleImplicitCondition(ExpressionStatement stat) {
        if (!(stat == this.currTopLevelStat && this.isThenOrExpectOrFilterBlock() || this.currSpecialMethodCall.isConditionMethodCall() || this.currSpecialMethodCall.isConditionBlock() || this.currSpecialMethodCall.isGroupConditionBlock() || this.insideInteraction && this.interactionClosureDepth == 1)) {
            return false;
        }
        if (!ImplicitConditionsUtils.isImplicitCondition((Statement)stat)) {
            return false;
        }
        ImplicitConditionsUtils.checkIsValidImplicitCondition((Statement)stat, this.resources.getErrorReporter());
        String methodName = AstUtil.getMethodName(stat.getExpression());
        boolean isConditionMethodCall = Identifiers.CONDITION_METHODS.contains(methodName);
        if (isConditionMethodCall) {
            this.groupConditionFound = this.currSpecialMethodCall.isGroupConditionBlock();
        } else {
            this.conditionFound();
        }
        if ((this.currSpecialMethodCall.isConditionMethodCall() || this.currSpecialMethodCall.isGroupConditionBlock()) && AstUtil.isInvocationWithImplicitThis(stat.getExpression()) && !isConditionMethodCall) {
            this.replaceObjectExpressionWithCurrentClosure(stat);
        }
        Statement condition = ConditionRewriter.rewriteImplicitCondition(stat, this.resources, this.getValueRecorderSuffix(), this.getErrorCollectorSuffix());
        this.replaceVisitedStatementWith(condition);
        return true;
    }

    private void replaceObjectExpressionWithCurrentClosure(ExpressionStatement stat) {
        MethodCallExpression methodCall = AstUtil.getExpression((Statement)stat, MethodCallExpression.class);
        if (methodCall == null) {
            return;
        }
        MethodCallExpression target = this.referenceToCurrentClosure();
        methodCall.setObjectExpression((Expression)target);
    }

    private MethodCallExpression referenceToCurrentClosure() {
        return new MethodCallExpression((Expression)new VariableExpression("this"), (Expression)new ConstantExpression((Object)"find"), MethodCallExpression.NO_ARGUMENTS);
    }

    private boolean handleMockCall(MethodCallExpression expr) {
        if (!this.currSpecialMethodCall.isTestDouble(expr)) {
            return false;
        }
        if (((MethodNode)this.resources.getCurrentMethod().getAst()).isStatic()) {
            this.resources.getErrorReporter().error((ASTNode)expr, "Mocks cannot be created in static scope", new Object[0]);
        }
        this.currSpecialMethodCall.expand();
        return true;
    }

    private boolean handleThrownCall(MethodCallExpression expr) {
        if (!this.currSpecialMethodCall.isExceptionCondition(expr)) {
            return false;
        }
        if (!(this.block instanceof ThenBlock)) {
            this.resources.getErrorReporter().error((ASTNode)expr, "Exception conditions are only allowed in 'then' blocks", new Object[0]);
            return true;
        }
        if (this.isExceptionConditionFound()) {
            this.resources.getErrorReporter().error((ASTNode)expr, "Only one exception condition is allowed per 'then' block", new Object[0]);
            return true;
        }
        if (!this.currSpecialMethodCall.isMatch(this.currTopLevelStat)) {
            this.resources.getErrorReporter().error((ASTNode)expr, "Exception conditions are only allowed as top-level statements", new Object[0]);
            return true;
        }
        this.foundExceptionCondition = expr;
        if (this.currSpecialMethodCall.isThrownCall()) {
            this.currSpecialMethodCall.expand();
        }
        return true;
    }

    private boolean handleOldCall(MethodCallExpression expr) {
        if (!this.currSpecialMethodCall.isOldCall(expr)) {
            return false;
        }
        if (!(this.block instanceof ThenBlock)) {
            this.resources.getErrorReporter().error((ASTNode)expr, "old() is only allowed in 'then' blocks", new Object[0]);
            return true;
        }
        expr.setMethod((Expression)new ConstantExpression((Object)(expr.getMethodAsString() + "Impl")));
        List<Expression> args = AstUtil.getArgumentList((Expression)expr);
        if (args.size() != 1) {
            this.resources.getErrorReporter().error((ASTNode)expr, "old() must have exactly one argument", new Object[0]);
            return true;
        }
        VariableExpression oldValue = this.resources.captureOldValue(args.get(0));
        args.set(0, (Expression)oldValue);
        return true;
    }

    private boolean handleInteractionBlockCall(MethodCallExpression expr) {
        if (!this.currSpecialMethodCall.isInteractionCall(expr)) {
            return false;
        }
        this.interactionFound = true;
        return true;
    }

    private void defineRecorders(ClosureExpression expr) {
        if (this.groupConditionFound) {
            this.resources.getErrorRecorders().defineErrorCollector(AstUtil.getStatements(expr), this.getErrorCollectorSuffix());
        }
        if (this.conditionFound) {
            this.resources.getErrorRecorders().defineValueRecorder(AstUtil.getStatements(expr), this.getValueRecorderSuffix());
        }
    }

    private boolean forbidUseOfSuperInFixtureMethod(MethodCallExpression expr) {
        Method currMethod = this.resources.getCurrentMethod();
        Expression target = expr.getObjectExpression();
        if (currMethod instanceof FixtureMethod && target instanceof VariableExpression && ((VariableExpression)target).isSuperExpression() && currMethod.getName().equals(expr.getMethodAsString())) {
            this.resources.getErrorReporter().error((ASTNode)expr, "A base class fixture method should not be called explicitly because it is always invoked automatically by the framework", new Object[0]);
            return true;
        }
        return false;
    }

    private ClosureExpression getCurrentWithOrMockClosure() {
        if (this.currSpecialMethodCall.isWithCall() || this.currSpecialMethodCall.isTestDouble()) {
            return this.currSpecialMethodCall.getClosureExpr();
        }
        return null;
    }

    private boolean isThenOrExpectOrFilterBlock() {
        return this.block instanceof ThenBlock || this.block instanceof ExpectBlock || this.block instanceof FilterBlock;
    }

    private boolean isInteractionExpression(InteractionRewriter rewriter, ExpressionStatement stat) {
        try {
            return rewriter.isInteraction(stat);
        }
        catch (InvalidSpecCompileException e) {
            return false;
        }
    }
}

