/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.compiler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.DynamicVariable;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.NamedArgumentListExpression;
import org.codehaus.groovy.ast.expr.NotExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.RangeExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.spockframework.compiler.AstUtil;
import org.spockframework.compiler.ISpecRewriteResources;
import org.spockframework.compiler.InvalidSpecCompileException;
import org.spockframework.lang.Wildcard;
import org.spockframework.util.Assert;
import org.spockframework.util.ObjectUtil;
import org.spockframework.util.UnreachableCodeError;

public class InteractionRewriter {
    private final ISpecRewriteResources resources;
    private final ClosureExpression activeWithOrMockClosure;
    private ExpressionStatement stat;
    private Expression count;
    private Expression call;
    private boolean wildcardCall;
    private boolean implicitTarget;
    private List<InteractionResponse> responses = new ArrayList<InteractionResponse>();
    private Boolean scanResult;
    private Expression builderExpr;

    public InteractionRewriter(ISpecRewriteResources resources, ClosureExpression activeWithOrMockClosure) {
        this.resources = resources;
        this.activeWithOrMockClosure = activeWithOrMockClosure;
    }

    public ExpressionStatement rewrite(ExpressionStatement stat) {
        try {
            if (!this.isInteraction(stat)) {
                return null;
            }
            this.createBuilder();
            this.setCount();
            this.setCall();
            this.addResponses();
            this.build();
            return this.register();
        }
        catch (InvalidSpecCompileException e) {
            this.resources.getErrorReporter().error(e);
            return null;
        }
    }

    public boolean isInteraction(ExpressionStatement stat) throws InvalidSpecCompileException {
        boolean interaction;
        if (this.scanResult != null) {
            if (stat != this.stat) {
                throw new InvalidSpecCompileException((ASTNode)stat, "InteractionRewriter was reused", new Object[0]);
            }
            return this.scanResult;
        }
        this.stat = stat;
        Expression expr = this.parseCount(this.parseResults(stat.getExpression()));
        boolean bl = interaction = (this.count != null || !this.responses.isEmpty()) && this.parseCall(expr);
        if (interaction && ((MethodNode)this.resources.getCurrentMethod().getAst()).isStatic()) {
            throw new InvalidSpecCompileException((ASTNode)stat, "Interactions cannot be declared in static scope", new Object[0]);
        }
        this.scanResult = interaction;
        return this.scanResult;
    }

    private Expression parseResults(Expression expr) {
        BinaryExpression binExpr;
        int type;
        while (expr instanceof BinaryExpression && ((type = (binExpr = (BinaryExpression)expr).getOperation().getType()) == 281 || type == 282)) {
            this.responses.add(new InteractionResponse(binExpr.getRightExpression(), type == 282));
            expr = binExpr.getLeftExpression();
        }
        return expr;
    }

    private Expression parseCount(Expression expr) {
        BinaryExpression binExpr = ObjectUtil.asInstance(expr, BinaryExpression.class);
        if (binExpr == null || binExpr.getOperation().getType() != 202) {
            return expr;
        }
        this.count = binExpr.getLeftExpression();
        return binExpr.getRightExpression();
    }

    private boolean parseCall(Expression expr) throws InvalidSpecCompileException {
        this.call = expr;
        if (AstUtil.isWildcardRef(expr)) {
            this.wildcardCall = true;
            this.implicitTarget = this.activeWithOrMockClosure != null;
            return true;
        }
        if (expr instanceof PropertyExpression || expr instanceof MethodCallExpression || expr instanceof ConstructorCallExpression) {
            if (AstUtil.isInvocationWithImplicitThis(expr)) {
                if (this.activeWithOrMockClosure == null || !AstUtil.hasImplicitParameter(this.activeWithOrMockClosure)) {
                    throw new InvalidSpecCompileException((ASTNode)this.call, "Interaction is missing a target", new Object[0]);
                }
                this.implicitTarget = true;
            }
            return true;
        }
        if (expr instanceof VariableExpression && ((VariableExpression)expr).getAccessedVariable() instanceof DynamicVariable) {
            if (this.activeWithOrMockClosure == null || !AstUtil.hasImplicitParameter(this.activeWithOrMockClosure)) {
                throw new InvalidSpecCompileException((ASTNode)this.call, "Interaction is missing a target", new Object[0]);
            }
            this.call = new PropertyExpression((Expression)new VariableExpression((Variable)new DynamicVariable("it", false)), ((VariableExpression)expr).getName());
            this.call.setSourcePosition((ASTNode)expr);
            this.implicitTarget = true;
            return true;
        }
        if (expr instanceof StaticMethodCallExpression) {
            return false;
        }
        return false;
    }

    private void createBuilder() {
        Expression expr = this.stat.getExpression();
        this.builderExpr = new ConstructorCallExpression(this.resources.getAstNodeCache().InteractionBuilder, (Expression)new ArgumentListExpression(Arrays.asList(AstUtil.primitiveConstExpression(expr.getLineNumber()), AstUtil.primitiveConstExpression(expr.getColumnNumber()), new ConstantExpression((Object)this.resources.getSourceText((ASTNode)expr)))));
    }

    private void setCount() {
        if (this.count == null) {
            return;
        }
        if (this.count instanceof RangeExpression) {
            RangeExpression range = (RangeExpression)this.count;
            this.call(this.resources.getAstNodeCache().InteractionBuilder_SetRangeCount, new Expression[]{range.getFrom(), range.getTo(), AstUtil.primitiveConstExpression(range.isInclusive())});
            return;
        }
        this.call(this.resources.getAstNodeCache().InteractionBuilder_SetFixedCount, this.count);
    }

    private void setCall() {
        if (this.wildcardCall) {
            if (this.implicitTarget) {
                this.call(this.resources.getAstNodeCache().InteractionBuilder_AddEqualTarget, AstUtil.getImplicitParameterRef(this.activeWithOrMockClosure));
            } else {
                this.call(this.resources.getAstNodeCache().InteractionBuilder_AddWildcardTarget, new Expression[0]);
            }
            this.call(this.resources.getAstNodeCache().InteractionBuilder_AddEqualMethodName, new Expression[]{new ConstantExpression((Object)Wildcard.INSTANCE.toString())});
        } else if (this.call instanceof PropertyExpression) {
            this.setPropertyCall();
        } else if (this.call instanceof MethodCallExpression) {
            this.setMethodCall();
        } else if (this.call instanceof ConstructorCallExpression) {
            this.setConstructorCall();
        } else {
            throw new UnreachableCodeError();
        }
    }

    private void setPropertyCall() {
        this.setTarget();
        this.setPropertyName();
    }

    private void setPropertyName() {
        Expression propertyNameExpr = ((PropertyExpression)this.call).getProperty();
        MethodNode constraint = this.selectNameConstraint(propertyNameExpr, this.resources.getAstNodeCache().InteractionBuilder_AddEqualPropertyName, this.resources.getAstNodeCache().InteractionBuilder_AddRegexPropertyName);
        this.call(constraint, propertyNameExpr);
    }

    private void setMethodCall() {
        this.setTarget();
        this.setMethodName();
        this.addArgs();
    }

    private void setConstructorCall() {
        this.setTarget();
        this.call(this.resources.getAstNodeCache().InteractionBuilder_AddEqualMethodName, new Expression[]{new ConstantExpression((Object)"<init>")});
        this.addArgs();
    }

    private void setTarget() {
        if (this.implicitTarget) {
            this.call(this.resources.getAstNodeCache().InteractionBuilder_AddEqualTarget, AstUtil.getImplicitParameterRef(this.activeWithOrMockClosure));
        } else {
            this.call(this.resources.getAstNodeCache().InteractionBuilder_AddEqualTarget, AstUtil.getInvocationTarget(this.call));
        }
    }

    private void setMethodName() {
        Expression methodNameExpr = ((MethodCallExpression)this.call).getMethod();
        MethodNode constraint = this.selectNameConstraint(methodNameExpr, this.resources.getAstNodeCache().InteractionBuilder_AddEqualMethodName, this.resources.getAstNodeCache().InteractionBuilder_AddRegexMethodName);
        this.call(constraint, methodNameExpr);
    }

    private MethodNode selectNameConstraint(Expression nameExpr, MethodNode constraint1, MethodNode constraint2) {
        if (!(nameExpr instanceof ConstantExpression)) {
            return constraint1;
        }
        String method = (String)((ConstantExpression)nameExpr).getValue();
        return AstUtil.isJavaIdentifier(method) ? constraint1 : constraint2;
    }

    private void addArgs() {
        if (this.call instanceof PropertyExpression) {
            return;
        }
        Expression args = AstUtil.getArguments(this.call);
        if (args == ArgumentListExpression.EMPTY_ARGUMENTS) {
            return;
        }
        if (args instanceof ArgumentListExpression) {
            this.addPositionalArgs((ArgumentListExpression)args);
        } else if (args instanceof NamedArgumentListExpression) {
            this.addNamedArgs((MapExpression)((NamedArgumentListExpression)args), false);
        } else if (args instanceof TupleExpression && ((TupleExpression)args).getExpression(0) instanceof NamedArgumentListExpression) {
            this.addNamedArgs((MapExpression)((NamedArgumentListExpression)((TupleExpression)args).getExpression(0)), false);
        } else {
            Assert.that(false, "unknown kind of argument list: " + args, new Object[0]);
        }
    }

    private void addPositionalArgs(ArgumentListExpression args) {
        List expressions = args.getExpressions();
        if (expressions.size() > 0 && expressions.get(0) instanceof MapExpression) {
            boolean isMixed = expressions.size() > 1;
            this.addNamedArgs((MapExpression)expressions.get(0), isMixed);
            if (isMixed) {
                this.addPositionalListArgs(expressions.subList(1, expressions.size()), true);
            }
        } else {
            this.addPositionalListArgs(expressions, false);
        }
    }

    private void addPositionalListArgs(List<Expression> expressions, boolean isMixed) {
        this.usePositionalArgs(isMixed);
        for (Expression arg : expressions) {
            this.addArg(arg);
        }
    }

    private void addNamedArgs(MapExpression args, boolean isMixed) {
        this.useNamedArgs(isMixed);
        for (MapEntryExpression arg : args.getMapEntryExpressions()) {
            this.addName(arg.getKeyExpression());
            this.addArg(arg.getValueExpression());
        }
    }

    private void useNamedArgs(boolean isMixed) {
        this.call(this.resources.getAstNodeCache().InteractionBuilder_SetArgListKind_boolean_boolean, new Expression[]{ConstantExpression.PRIM_FALSE, AstUtil.primitiveConstExpression(isMixed)});
    }

    private void usePositionalArgs(boolean isMixed) {
        this.call(this.resources.getAstNodeCache().InteractionBuilder_SetArgListKind_boolean_boolean, new Expression[]{ConstantExpression.PRIM_TRUE, AstUtil.primitiveConstExpression(isMixed)});
    }

    private void addName(Expression name) {
        this.call(this.resources.getAstNodeCache().InteractionBuilder_AddArgName, name);
    }

    private void addArg(Expression arg) {
        if (arg instanceof NotExpression) {
            NotExpression not = (NotExpression)arg;
            this.addArg(not.getExpression());
            this.call(this.resources.getAstNodeCache().InteractionBuilder_NegateLastArg, new Expression[0]);
            return;
        }
        if (arg instanceof CastExpression) {
            CastExpression cast = (CastExpression)arg;
            if (cast.getExpression() instanceof ListExpression) {
                this.call(this.resources.getAstNodeCache().InteractionBuilder_AddEqualArg, arg);
            } else {
                this.addArg(cast.getExpression());
            }
            this.call(this.resources.getAstNodeCache().InteractionBuilder_TypeLastArg, new Expression[]{new ClassExpression(cast.getType())});
            return;
        }
        if (arg instanceof ClosureExpression) {
            this.call(this.resources.getAstNodeCache().InteractionBuilder_AddCodeArg, arg);
            return;
        }
        this.call(this.resources.getAstNodeCache().InteractionBuilder_AddEqualArg, arg);
    }

    private void addResponses() {
        for (InteractionResponse response : this.responses) {
            if (response.iterable) {
                this.call(this.resources.getAstNodeCache().InteractionBuilder_AddIterableResponse, response.expr);
                continue;
            }
            if (response.expr instanceof ClosureExpression) {
                this.call(this.resources.getAstNodeCache().InteractionBuilder_AddCodeResponse, response.expr);
                continue;
            }
            this.call(this.resources.getAstNodeCache().InteractionBuilder_AddConstantResponse, response.expr);
        }
    }

    private void build() {
        this.call(this.resources.getAstNodeCache().InteractionBuilder_Build, new Expression[0]);
    }

    private ExpressionStatement register() {
        ExpressionStatement result = new ExpressionStatement((Expression)AstUtil.createDirectMethodCall((Expression)this.resources.getMockInvocationMatcher(), this.resources.getAstNodeCache().MockController_AddInteraction, (Expression)new ArgumentListExpression(this.builderExpr)));
        result.setSourcePosition((ASTNode)this.stat);
        return result;
    }

    private void call(MethodNode method, Expression ... args) {
        this.builderExpr = AstUtil.createDirectMethodCall(this.builderExpr, method, (Expression)new ArgumentListExpression(args));
    }

    private static class InteractionResponse {
        final Expression expr;
        final boolean iterable;

        private InteractionResponse(Expression expr, boolean iterable) {
            this.expr = expr;
            this.iterable = iterable;
        }
    }
}

