/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.compiler;

import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.control.Janitor;
import org.codehaus.groovy.control.SourceUnit;

public class SourceLookup
implements AutoCloseable {
    private final SourceUnit sourceUnit;
    private final Janitor janitor = new Janitor();

    public SourceLookup(SourceUnit sourceUnit) {
        this.sourceUnit = sourceUnit;
    }

    public String lookup(ASTNode node) {
        StringBuilder text = new StringBuilder();
        for (int i = node.getLineNumber(); i <= node.getLastLineNumber(); ++i) {
            String line = this.sourceUnit.getSample(i, 0, this.janitor);
            if (line == null) {
                return null;
            }
            try {
                if (i == node.getLastLineNumber()) {
                    line = line.substring(0, node.getLastColumnNumber() - 1);
                }
                if (i == node.getLineNumber()) {
                    line = line.substring(node.getColumnNumber() - 1);
                }
                text.append(line);
                if (i == node.getLastLineNumber()) continue;
                text.append('\n');
                continue;
            }
            catch (StringIndexOutOfBoundsException e) {
                return null;
            }
        }
        return text.toString().trim();
    }

    @Override
    public void close() {
        this.janitor.cleanup();
    }
}

