/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.compiler.condition;

import java.util.List;
import java.util.ListIterator;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.stmt.AssertStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.spockframework.compiler.AstUtil;
import org.spockframework.compiler.ConditionRewriter;
import org.spockframework.compiler.IRewriteResources;
import org.spockframework.compiler.StatementReplacingVisitorSupport;
import org.spockframework.compiler.condition.IVerifyMethodRewriter;
import org.spockframework.compiler.condition.ImplicitConditionsUtils;
import org.spockframework.util.Assert;

abstract class BaseVerifyMethodRewriter
extends StatementReplacingVisitorSupport
implements IVerifyMethodRewriter {
    final IRewriteResources resources;
    private final MethodNode methodNode;
    private boolean conditionFound = false;

    BaseVerifyMethodRewriter(MethodNode methodNode, IRewriteResources resources) {
        this.resources = Assert.notNull(resources);
        this.methodNode = Assert.notNull(methodNode);
    }

    abstract void defineErrorCollector(List<Statement> var1);

    @Override
    public void rewrite() {
        ListIterator<Statement> statements = AstUtil.getStatements(this.methodNode).listIterator();
        while (statements.hasNext()) {
            Statement next = statements.next();
            statements.set(this.replace(next));
        }
        this.defineRecorders();
    }

    public void visitAssertStatement(AssertStatement stat) {
        super.visitAssertStatement(stat);
        this.conditionFound();
        this.replaceVisitedStatementWith(ConditionRewriter.rewriteExplicitCondition(stat, this.resources));
    }

    public void visitExpressionStatement(ExpressionStatement stat) {
        super.visitExpressionStatement(stat);
        if (ImplicitConditionsUtils.isImplicitCondition((Statement)stat)) {
            ImplicitConditionsUtils.checkIsValidImplicitCondition((Statement)stat, this.resources.getErrorReporter());
            this.conditionFound();
            this.replaceVisitedStatementWith(ConditionRewriter.rewriteImplicitCondition(stat, this.resources));
        }
    }

    private void conditionFound() {
        this.conditionFound = true;
    }

    private void defineRecorders() {
        if (this.conditionFound) {
            this.defineErrorCollector(AstUtil.getStatements(this.methodNode));
            this.resources.getErrorRecorders().defineValueRecorder(AstUtil.getStatements(this.methodNode));
        }
    }
}

