/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.compiler.condition;

import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.ASTTransformation;
import org.spockframework.compiler.AstNodeCache;
import org.spockframework.compiler.ErrorReporter;
import org.spockframework.compiler.IRewriteResources;
import org.spockframework.compiler.SourceLookup;
import org.spockframework.compiler.condition.DefaultConditionErrorRecorders;
import org.spockframework.compiler.condition.DefaultConditionRewriterResources;
import org.spockframework.compiler.condition.IVerifyMethodRewriter;

abstract class BaseVerifyMethodTransform
implements ASTTransformation {
    static final AstNodeCache nodeCache = new AstNodeCache();

    BaseVerifyMethodTransform() {
    }

    abstract IVerifyMethodRewriter createRewriter(MethodNode var1, IRewriteResources var2);

    public void visit(ASTNode[] astNodes, SourceUnit sourceUnit) {
        ErrorReporter errorReporter = new ErrorReporter(sourceUnit);
        try (SourceLookup sourceLookup = new SourceLookup(sourceUnit);){
            for (ASTNode node : astNodes) {
                if (!(node instanceof MethodNode)) continue;
                this.processVerificationHelperMethod((MethodNode)node, errorReporter, sourceLookup);
            }
        }
    }

    private void processVerificationHelperMethod(MethodNode method, ErrorReporter errorReporter, SourceLookup sourceLookup) {
        if (!method.isVoidMethod()) {
            errorReporter.error("Verification helper method '%s' must have a void return type.", method.getName());
            return;
        }
        IVerifyMethodRewriter rewriter = this.createRewriter(method, new DefaultConditionRewriterResources(nodeCache, sourceLookup, errorReporter, new DefaultConditionErrorRecorders(nodeCache)));
        try {
            rewriter.rewrite();
        }
        catch (Exception e) {
            errorReporter.error("Unexpected error during compilation of verification helper method '%s'. Maybe you have used invalid Spock syntax? Anyway, please file a bug report at https://issues.spockframework.org.", e, method.getName());
        }
    }
}

