/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.compiler.condition;

import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.syntax.Types;
import org.spockframework.compiler.AstUtil;
import org.spockframework.compiler.ErrorReporter;

public class ImplicitConditionsUtils {
    private ImplicitConditionsUtils() {
    }

    public static boolean isImplicitCondition(Statement stat) {
        return stat instanceof ExpressionStatement && !(((ExpressionStatement)stat).getExpression() instanceof DeclarationExpression);
    }

    public static void checkIsValidImplicitCondition(Statement stat, ErrorReporter errorReporter) {
        BinaryExpression binExpr = AstUtil.getExpression(stat, BinaryExpression.class);
        if (binExpr == null) {
            return;
        }
        if (Types.ofType((int)binExpr.getOperation().getType(), (int)1100)) {
            errorReporter.error((ASTNode)stat, "Expected a condition, but found an assignment. Did you intend to write '==' ?", new Object[0]);
        }
    }
}

