/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.compiler.model;

import java.util.EnumSet;
import java.util.Locale;
import org.spockframework.compiler.model.AnonymousBlock;
import org.spockframework.compiler.model.Block;
import org.spockframework.compiler.model.CleanupBlock;
import org.spockframework.compiler.model.ExpectBlock;
import org.spockframework.compiler.model.FilterBlock;
import org.spockframework.compiler.model.Method;
import org.spockframework.compiler.model.SetupBlock;
import org.spockframework.compiler.model.ThenBlock;
import org.spockframework.compiler.model.WhenBlock;
import org.spockframework.compiler.model.WhereBlock;
import org.spockframework.util.InternalSpockError;

public enum BlockParseInfo {
    AND{

        @Override
        public EnumSet<BlockParseInfo> getSuccessors(Method method) {
            return method.getLastBlock().getParseInfo().getSuccessors(method);
        }

        @Override
        public Block addNewBlock(Method method) {
            return method.getLastBlock();
        }

        @Override
        public boolean isSupportingBlockListeners() {
            throw new InternalSpockError("AND block should have been replaced by a more specific block");
        }
    }
    ,
    ANONYMOUS{

        @Override
        public Block addNewBlock(Method method) {
            return method.addBlock(new AnonymousBlock(method));
        }

        @Override
        public EnumSet<BlockParseInfo> getSuccessors(Method method) {
            return EnumSet.of(SETUP, new BlockParseInfo[]{GIVEN, EXPECT, WHEN, CLEANUP, WHERE, METHOD_END});
        }

        @Override
        public boolean isSupportingBlockListeners() {
            return false;
        }
    }
    ,
    SETUP{

        @Override
        public Block addNewBlock(Method method) {
            return method.addBlock(new SetupBlock(method));
        }

        @Override
        public EnumSet<BlockParseInfo> getSuccessors(Method method) {
            return EnumSet.of(AND, new BlockParseInfo[]{EXPECT, WHEN, CLEANUP, WHERE, METHOD_END});
        }

        @Override
        public boolean isSupportingBlockListeners() {
            return true;
        }
    }
    ,
    GIVEN{

        @Override
        public Block addNewBlock(Method method) {
            return SETUP.addNewBlock(method);
        }

        @Override
        public EnumSet<BlockParseInfo> getSuccessors(Method method) {
            return SETUP.getSuccessors(method);
        }

        @Override
        public boolean isSupportingBlockListeners() {
            throw new InternalSpockError("GIVEN block should have been replaced by a SETUP block");
        }
    }
    ,
    EXPECT{

        @Override
        public Block addNewBlock(Method method) {
            return method.addBlock(new ExpectBlock(method));
        }

        @Override
        public EnumSet<BlockParseInfo> getSuccessors(Method method) {
            return EnumSet.of(AND, WHEN, CLEANUP, WHERE, METHOD_END);
        }

        @Override
        public boolean isSupportingBlockListeners() {
            return true;
        }
    }
    ,
    WHEN{

        @Override
        public Block addNewBlock(Method method) {
            return method.addBlock(new WhenBlock(method));
        }

        @Override
        public EnumSet<BlockParseInfo> getSuccessors(Method method) {
            return EnumSet.of(AND, THEN);
        }

        @Override
        public boolean isSupportingBlockListeners() {
            return true;
        }
    }
    ,
    THEN{

        @Override
        public Block addNewBlock(Method method) {
            return method.addBlock(new ThenBlock(method));
        }

        @Override
        public EnumSet<BlockParseInfo> getSuccessors(Method method) {
            return EnumSet.of(AND, new BlockParseInfo[]{EXPECT, WHEN, THEN, CLEANUP, WHERE, METHOD_END});
        }

        @Override
        public boolean isSupportingBlockListeners() {
            return true;
        }
    }
    ,
    CLEANUP{

        @Override
        public Block addNewBlock(Method method) {
            return method.addBlock(new CleanupBlock(method));
        }

        @Override
        public EnumSet<BlockParseInfo> getSuccessors(Method method) {
            return EnumSet.of(AND, WHERE, METHOD_END);
        }

        @Override
        public boolean isSupportingBlockListeners() {
            return true;
        }
    }
    ,
    WHERE{

        @Override
        public Block addNewBlock(Method method) {
            return method.addBlock(new WhereBlock(method));
        }

        @Override
        public EnumSet<BlockParseInfo> getSuccessors(Method method) {
            return EnumSet.of(AND, COMBINED, FILTER, METHOD_END);
        }

        @Override
        public boolean isSupportingBlockListeners() {
            return false;
        }
    }
    ,
    COMBINED{

        @Override
        public Block addNewBlock(Method method) {
            return method.getLastBlock();
        }

        @Override
        public EnumSet<BlockParseInfo> getSuccessors(Method method) {
            return WHERE.getSuccessors(method);
        }

        @Override
        public boolean isSupportingBlockListeners() {
            return false;
        }
    }
    ,
    FILTER{

        @Override
        public Block addNewBlock(Method method) {
            return method.addBlock(new FilterBlock(method));
        }

        @Override
        public EnumSet<BlockParseInfo> getSuccessors(Method method) {
            return EnumSet.of(AND, METHOD_END);
        }

        @Override
        public boolean isSupportingBlockListeners() {
            return false;
        }
    }
    ,
    METHOD_END{

        @Override
        public Block addNewBlock(Method method) {
            throw new UnsupportedOperationException("addNewBlock");
        }

        @Override
        public EnumSet<BlockParseInfo> getSuccessors(Method method) {
            throw new UnsupportedOperationException("getSuccessors");
        }

        @Override
        public boolean isSupportingBlockListeners() {
            return false;
        }

        @Override
        public String toString() {
            return "end-of-method";
        }
    };


    public String toString() {
        return super.toString().toLowerCase(Locale.ROOT);
    }

    public abstract Block addNewBlock(Method var1);

    public abstract EnumSet<BlockParseInfo> getSuccessors(Method var1);

    public abstract boolean isSupportingBlockListeners();
}

