/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.mock.constraint;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.spockframework.mock.IArgumentConstraint;
import org.spockframework.mock.IInvocationConstraint;
import org.spockframework.mock.IMockInvocation;
import org.spockframework.util.Assert;
import org.spockframework.util.TextUtil;

public class NamedArgumentListConstraint
implements IInvocationConstraint {
    private final List<Object> argNames;
    private final List<IArgumentConstraint> argConstraints;
    private final boolean isMixed;

    public NamedArgumentListConstraint(List<Object> argNames, List<IArgumentConstraint> argConstraints, boolean isMixed) {
        this.isMixed = isMixed;
        Assert.that(argNames.size() == argConstraints.size());
        this.argNames = argNames;
        this.argConstraints = argConstraints;
    }

    @Override
    public boolean isSatisfiedBy(IMockInvocation invocation) {
        List<Object> args = invocation.getArguments();
        if ((args.size() == 1 || this.isMixed) && args.get(0) instanceof Map) {
            return this.matchesArgMap(new HashMap((Map)args.get(0)));
        }
        return false;
    }

    @Override
    public String describeMismatch(IMockInvocation invocation) {
        List<Object> args = invocation.getArguments();
        if ((args.size() == 1 || this.isMixed) && args.get(0) instanceof Map) {
            return this.describeMismatchArgMap(new HashMap((Map)args.get(0)));
        }
        return "<named arguments expected>";
    }

    private String describeMismatchArgMap(Map argMap) {
        StringBuilder result = new StringBuilder("One or more arguments(s) didn't match:\n");
        for (int i = 0; i < this.argConstraints.size(); ++i) {
            Object name = this.argNames.get(i);
            IArgumentConstraint matcher = this.argConstraints.get(i);
            if (!argMap.containsKey(name)) {
                result.append("[").append(name).append("]: <missing>\n");
                continue;
            }
            Object arg = argMap.remove(name);
            if (matcher.isSatisfiedBy(arg)) continue;
            int prev = result.length();
            result.append("[").append(name).append("]: ");
            int indent = result.length() - prev;
            result.append(TextUtil.changeSubsequentIndent(matcher.describeMismatch(arg), indent, "\n")).append("\n");
        }
        for (Object arg : argMap.keySet()) {
            result.append("[").append(arg).append("]: <unexpected argument>\n");
        }
        return result.toString();
    }

    private boolean matchesArgMap(Map argMap) {
        if (this.argConstraints.size() != argMap.size()) {
            return false;
        }
        for (int i = 0; i < this.argConstraints.size(); ++i) {
            Object name = this.argNames.get(i);
            IArgumentConstraint matcher = this.argConstraints.get(i);
            if (argMap.containsKey(name) && matcher.isSatisfiedBy(argMap.remove(name))) continue;
            return false;
        }
        return true;
    }
}

