/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.mock.constraint;

import org.spockframework.mock.IInteractionAware;
import org.spockframework.mock.IInvocationConstraint;
import org.spockframework.mock.IMockInteraction;
import org.spockframework.mock.IMockInvocation;
import org.spockframework.mock.IMockObject;
import org.spockframework.mock.ISpockMockObject;
import org.spockframework.mock.MockUtil;
import org.spockframework.mock.runtime.IMockInteractionValidator;
import org.spockframework.runtime.Condition;
import org.spockframework.runtime.InvalidSpecException;
import org.spockframework.util.CollectionUtil;

public class TargetConstraint
implements IInvocationConstraint,
IInteractionAware {
    private static final MockUtil MOCK_UTIL = new MockUtil();
    private final Object target;
    private IMockInteraction interaction;

    public TargetConstraint(Object target) {
        this.target = target;
    }

    @Override
    public boolean isSatisfiedBy(IMockInvocation invocation) {
        return invocation.getMockObject().matches(this.target, this.interaction);
    }

    @Override
    public String describeMismatch(IMockInvocation invocation) {
        Condition condition = new Condition(CollectionUtil.listOf(invocation.getMockObject().getInstance().toString(), this.target.toString(), false), "instance == target", null, null, null, null);
        return condition.getRendering();
    }

    @Override
    public void setInteraction(IMockInteraction interaction) {
        this.interaction = interaction;
        IMockObject mockObject = MOCK_UTIL.asMockOrNull(this.target);
        if (mockObject != null) {
            this.checkRequiredInteraction(mockObject, interaction);
            this.validateMockInteraction(mockObject, interaction);
        }
    }

    private void checkRequiredInteraction(IMockObject mockObject, IMockInteraction interaction) {
        if (interaction.isRequired() && !mockObject.isVerified()) {
            throw new InvalidSpecException("Stub '%s' matches the following required interaction:\n\n%s\n\nRemove the cardinality (e.g. '1 *'), or turn the stub into a mock.\n").withArgs(mockObject.getMockName(), interaction);
        }
    }

    private void validateMockInteraction(IMockObject mockObject, IMockInteraction interaction) {
        IMockInteractionValidator validation;
        if (this.target instanceof ISpockMockObject && (validation = ((ISpockMockObject)this.target).$spock_mockInteractionValidator()) != null) {
            validation.validateMockInteraction(mockObject, interaction);
        }
    }
}

