/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.mock.runtime;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.MetaMethod;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;
import org.spockframework.mock.IMockObject;
import org.spockframework.mock.runtime.IProxyBasedMockInterceptor;
import org.spockframework.runtime.GroovyRuntimeUtil;

public abstract class BaseMockInterceptor
implements IProxyBasedMockInterceptor {
    private MetaClass mockMetaClass;

    BaseMockInterceptor(MetaClass mockMetaClass) {
        this.mockMetaClass = mockMetaClass;
    }

    protected MetaClass getMockMetaClass() {
        return this.mockMetaClass;
    }

    public void setMetaClass(MetaClass mockMetaClass) {
        this.mockMetaClass = Objects.requireNonNull(mockMetaClass);
    }

    @Nullable
    protected String handleGetProperty(GroovyObject target, Object[] args) {
        String methodName = null;
        Throwable throwable = new Throwable();
        StackTraceElement mockCaller = throwable.getStackTrace()[4];
        if (!mockCaller.getClassName().startsWith("groovy.lang.GroovyObject$getProperty") || !"call".equals(mockCaller.getMethodName())) {
            String propertyName = (String)args[0];
            MetaClass metaClass = target.getMetaClass();
            MetaMethod booleanVariant = metaClass.getMetaMethod(GroovyRuntimeUtil.propertyToBooleanGetterMethodName(propertyName), GroovyRuntimeUtil.EMPTY_ARGUMENTS);
            methodName = booleanVariant != null && booleanVariant.getReturnType() == Boolean.TYPE ? booleanVariant.getName() : GroovyRuntimeUtil.propertyToGetterMethodName(propertyName);
        }
        return methodName;
    }

    protected boolean isMethod(Method method, String name, Class<?> ... parameterTypes) {
        return method.getName().equals(name) && Arrays.equals(method.getParameterTypes(), parameterTypes);
    }

    public static Object handleSpockMockInterface(Method method, IMockObject mockObject) {
        if ("$spock_mockInteractionValidator".equals(method.getName())) {
            return null;
        }
        return mockObject;
    }
}

